/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.machine.solar;

import com.enderio.core.api.client.gui.IResourceTooltipProvider;
import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import crazypants.enderio.BlockEio;
import crazypants.enderio.EnderIO;
import crazypants.enderio.ModObject;
import crazypants.enderio.config.Config;
import crazypants.enderio.machine.solar.BlockItemSolarPanel;
import crazypants.enderio.machine.solar.TileEntitySolarPanel;
import crazypants.enderio.waila.IWailaInfoProvider;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class BlockSolarPanel
extends BlockEio
implements IResourceTooltipProvider,
IWailaInfoProvider {
    public static int renderId;
    private static final float BLOCK_HEIGHT = 0.15f;
    IIcon sideIcon;
    IIcon advancedSideIcon;
    IIcon advancedIcon;
    IIcon borderIcon;
    IIcon advancedBorderIcon;

    public static BlockSolarPanel create() {
        BlockSolarPanel result = new BlockSolarPanel();
        result.init();
        return result;
    }

    private BlockSolarPanel() {
        super(ModObject.blockSolarPanel.unlocalisedName, TileEntitySolarPanel.class);
        if (!Config.photovoltaicCellEnabled) {
            this.setCreativeTab(null);
        }
        this.setBlockBounds(0.0f, 0.0f, 0.0f, 1.0f, 0.15f, 1.0f);
    }

    protected void init() {
        GameRegistry.registerBlock((Block)this, BlockItemSolarPanel.class, (String)this.name);
        if (this.teClass != null) {
            GameRegistry.registerTileEntity((Class)this.teClass, (String)(this.name + "TileEntity"));
        }
    }

    public int damageDropped(int damage) {
        return damage;
    }

    public boolean renderAsNormalBlock() {
        return false;
    }

    public boolean isOpaqueCube() {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon getIcon(int side, int meta) {
        if (side == ForgeDirection.UP.ordinal()) {
            return meta == 0 ? this.blockIcon : this.advancedIcon;
        }
        return meta == 0 ? this.sideIcon : this.advancedSideIcon;
    }

    public IIcon getBorderIcon(int i, int meta) {
        return meta == 0 ? this.borderIcon : this.advancedBorderIcon;
    }

    public int getRenderType() {
        return renderId;
    }

    public void onNeighborBlockChange(World world, int x, int y, int z, Block par5) {
        TileEntity te = world.getTileEntity(x, y, z);
        if (te instanceof TileEntitySolarPanel) {
            ((TileEntitySolarPanel)te).onNeighborBlockChange();
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void registerBlockIcons(IIconRegister register) {
        this.blockIcon = register.registerIcon("enderio:solarPanelTop");
        this.advancedIcon = register.registerIcon("enderio:solarPanelAdvancedTop");
        this.sideIcon = register.registerIcon("enderio:solarPanelSide");
        this.advancedSideIcon = register.registerIcon("enderio:solarPanelAdvancedSide");
        this.borderIcon = register.registerIcon("enderio:solarPanelBorder");
        this.advancedBorderIcon = register.registerIcon("enderio:solarPanelAdvancedBorder");
    }

    public void setBlockBoundsBasedOnState(IBlockAccess par1IBlockAccess, int par2, int par3, int par4) {
        this.setBlockBounds(0.0f, 0.0f, 0.0f, 1.0f, 0.15f, 1.0f);
    }

    public void setBlockBoundsForItemRender() {
        this.setBlockBounds(0.0f, 0.0f, 0.0f, 1.0f, 0.15f, 1.0f);
    }

    public void addCollisionBoxesToList(World par1World, int par2, int par3, int par4, AxisAlignedBB par5AxisAlignedBB, List par6List, Entity par7Entity) {
        this.setBlockBoundsBasedOnState((IBlockAccess)par1World, par2, par3, par4);
        super.addCollisionBoxesToList(par1World, par2, par3, par4, par5AxisAlignedBB, par6List, par7Entity);
    }

    public String getUnlocalizedNameForTooltip(ItemStack itemStack) {
        return this.getUnlocalizedName();
    }

    @Override
    public void getWailaInfo(List<String> tooltip, EntityPlayer player, World world, int x, int y, int z) {
        TileEntity te = world.getTileEntity(x, y, z);
        if (te instanceof TileEntitySolarPanel) {
            TileEntitySolarPanel solar = (TileEntitySolarPanel)te;
            float efficiency = solar.calculateLightRatio();
            if (!solar.canSeeSun()) {
                tooltip.add(EnumChatFormatting.RED + EnderIO.lang.localize("tooltip.sunlightBlocked"));
            } else {
                tooltip.add(String.format("%s : %s%.0f%%", EnumChatFormatting.WHITE + EnderIO.lang.localize("tooltip.efficiency") + EnumChatFormatting.RESET, EnumChatFormatting.WHITE, Float.valueOf(efficiency * 100.0f)));
            }
        }
    }

    @Override
    public int getDefaultDisplayMask(World world, int x, int y, int z) {
        return 0;
    }
}

