/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.machine.power;

import cofh.api.energy.IEnergyContainerItem;
import com.enderio.core.common.util.BlockCoord;
import com.enderio.core.common.util.Util;
import com.enderio.core.common.vecmath.VecmathUtil;
import crazypants.enderio.EnderIO;
import crazypants.enderio.TileEntityEio;
import crazypants.enderio.conduit.ConnectionMode;
import crazypants.enderio.conduit.IConduitBundle;
import crazypants.enderio.conduit.power.IPowerConduit;
import crazypants.enderio.config.Config;
import crazypants.enderio.machine.IIoConfigurable;
import crazypants.enderio.machine.IoMode;
import crazypants.enderio.machine.RedstoneControlMode;
import crazypants.enderio.machine.power.GaugeBounds;
import crazypants.enderio.machine.power.PacketPowerStorage;
import crazypants.enderio.network.PacketHandler;
import crazypants.enderio.power.BasicCapacitor;
import crazypants.enderio.power.IInternalPowerHandler;
import crazypants.enderio.power.IInternalPoweredTile;
import crazypants.enderio.power.IPowerInterface;
import crazypants.enderio.power.IPowerStorage;
import crazypants.enderio.power.PowerHandlerUtil;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class TileCapacitorBank
extends TileEntityEio
implements IInternalPowerHandler,
IInventory,
IIoConfigurable,
IPowerStorage {
    static final BasicCapacitor BASE_CAP = new BasicCapacitor(Config.capacitorBankMaxIoRF, Config.capacitorBankMaxStorageRF);
    private static final int MAX_SIZE = Integer.MAX_VALUE / Config.capacitorBankMaxStorageRF;
    BlockCoord[] multiblock = null;
    private int lastSyncPowerStored;
    int storedEnergyRF = 0;
    private int maxStoredEnergy;
    private int maxIO;
    private int maxInput;
    private int maxOutput;
    private boolean multiblockDirty = false;
    private RedstoneControlMode inputControlMode;
    private RedstoneControlMode outputControlMode;
    private boolean outputEnabled;
    private boolean inputEnabled;
    private boolean isRecievingRedstoneSignal;
    private boolean redstoneStateDirty = true;
    private int lastComparatorState = 0;
    private List<Receptor> masterReceptors;
    private ListIterator<Receptor> receptorIterator;
    private List<Receptor> localReceptors;
    private boolean receptorsDirty = true;
    private final ItemStack[] inventory = new ItemStack[4];
    private List<GaugeBounds> gaugeBounds;
    private Map<ForgeDirection, IoMode> faceModes;
    private boolean render = false;
    private boolean masterReceptorsDirty;
    private boolean notifyNeighbours = false;
    int energyAtLastRender = -1;
    private boolean isCreative = false;
    double lastRenderStoredRatio;

    public TileCapacitorBank() {
        this.inputControlMode = RedstoneControlMode.IGNORE;
        this.outputControlMode = RedstoneControlMode.IGNORE;
        this.maxStoredEnergy = BASE_CAP.getMaxEnergyStored();
        this.maxInput = this.maxIO = BASE_CAP.getMaxEnergyExtracted();
        this.maxOutput = this.maxIO;
    }

    @Override
    public IoMode toggleIoModeForFace(ForgeDirection faceHit) {
        IPowerInterface rec = this.getReceptorForFace(faceHit);
        IoMode curMode = this.getIoMode(faceHit);
        if (curMode == IoMode.PULL) {
            this.setIoMode(faceHit, IoMode.PUSH, true);
            return IoMode.PUSH;
        }
        if (curMode == IoMode.PUSH) {
            this.setIoMode(faceHit, IoMode.DISABLED, true);
            return IoMode.DISABLED;
        }
        if (curMode == IoMode.DISABLED && (rec == null || rec.getDelegate() instanceof IConduitBundle)) {
            this.setIoMode(faceHit, IoMode.NONE, true);
            return IoMode.NONE;
        }
        this.setIoMode(faceHit, IoMode.PULL, true);
        return IoMode.PULL;
    }

    @Override
    public boolean supportsMode(ForgeDirection faceHit, IoMode mode) {
        IPowerInterface rec = this.getReceptorForFace(faceHit);
        if (mode == IoMode.NONE) {
            return rec == null || rec.getDelegate() instanceof IConduitBundle;
        }
        return true;
    }

    @Override
    public void setIoMode(ForgeDirection faceHit, IoMode mode) {
        this.setIoMode(faceHit, mode, true);
    }

    @Override
    public void clearAllIoModes() {
        if (this.faceModes != null) {
            this.faceModes = null;
            this.receptorsDirty = true;
            this.getController().masterReceptorsDirty = true;
            this.notifyNeighbours = true;
            this.render = true;
            this.updateBlock();
        }
    }

    public void setIoMode(ForgeDirection faceHit, IoMode mode, boolean updateReceptors) {
        if (mode == IoMode.NONE && this.faceModes == null) {
            return;
        }
        if (this.faceModes == null) {
            this.faceModes = new EnumMap<ForgeDirection, IoMode>(ForgeDirection.class);
        }
        this.faceModes.put(faceHit, mode);
        if (updateReceptors) {
            this.receptorsDirty = true;
            this.getController().masterReceptorsDirty = true;
            this.notifyNeighbours = true;
        }
        this.render = true;
        this.updateBlock();
    }

    @Override
    public IoMode getIoMode(ForgeDirection face) {
        if (this.faceModes == null) {
            return IoMode.NONE;
        }
        IoMode res = this.faceModes.get(face);
        if (res == null) {
            return IoMode.NONE;
        }
        return res;
    }

    private IPowerInterface getReceptorForFace(ForgeDirection faceHit) {
        BlockCoord checkLoc = new BlockCoord((TileEntity)this).getLocation(faceHit);
        TileEntity te = this.worldObj.getTileEntity(checkLoc.x, checkLoc.y, checkLoc.z);
        if (!(te instanceof TileCapacitorBank)) {
            return PowerHandlerUtil.create(te);
        }
        return null;
    }

    public void doUpdate() {
        int comparatorState;
        if (this.blockMetadata == -1) {
            boolean bl = this.isCreative = this.getBlockMetadata() == 1;
        }
        if (this.worldObj.isRemote) {
            if (this.render) {
                this.worldObj.markBlockForUpdate(this.xCoord, this.yCoord, this.zCoord);
                this.render = false;
            }
            return;
        }
        if (this.multiblockDirty) {
            this.formMultiblock();
            this.multiblockDirty = false;
        }
        if (this.lastComparatorState != (comparatorState = this.getComparatorOutput())) {
            this.worldObj.func_147453_f(this.xCoord, this.yCoord, this.zCoord, this.getBlockType());
            this.lastComparatorState = comparatorState;
        }
        if (!this.isContoller()) {
            if (this.notifyNeighbours) {
                this.worldObj.notifyBlocksOfNeighborChange(this.xCoord, this.yCoord, this.zCoord, this.getBlockType());
                this.notifyNeighbours = false;
            }
            return;
        }
        this.chargeItems();
        boolean hasSignal = this.isRecievingRedstoneSignal();
        if (this.inputControlMode == RedstoneControlMode.IGNORE) {
            this.inputEnabled = true;
        } else if (this.inputControlMode == RedstoneControlMode.NEVER) {
            this.inputEnabled = false;
        } else {
            boolean bl = this.inputEnabled = this.inputControlMode == RedstoneControlMode.ON && hasSignal || this.inputControlMode == RedstoneControlMode.OFF && !hasSignal;
        }
        this.outputEnabled = this.outputControlMode == RedstoneControlMode.IGNORE ? true : (this.outputControlMode == RedstoneControlMode.NEVER ? false : this.outputControlMode == RedstoneControlMode.ON && hasSignal || this.outputControlMode == RedstoneControlMode.OFF && !hasSignal);
        this.updateMasterReceptors();
        if (this.outputEnabled) {
            this.transmitEnergy();
        }
        if (this.isCreative) {
            this.setEnergyStored(this.getMaxEnergyStored() / 2);
        }
        if (this.lastSyncPowerStored != this.getEnergyStored() && this.shouldDoWorkThisTick(10)) {
            this.lastSyncPowerStored = this.getEnergyStored();
            PacketHandler.sendToAllAround(new PacketPowerStorage(this), (TileEntity)this, 64);
        }
        if (this.notifyNeighbours) {
            this.worldObj.notifyBlocksOfNeighborChange(this.xCoord, this.yCoord, this.zCoord, this.getBlockType());
            this.notifyNeighbours = false;
        }
    }

    public int getComparatorOutput() {
        double stored = this.getEnergyStored();
        return stored == 0.0 ? 0 : (int)(1.0 + stored / (double)this.getMaxEnergyStored() * 14.0);
    }

    public List<GaugeBounds> getGaugeBounds() {
        if (this.gaugeBounds == null) {
            this.gaugeBounds = GaugeBounds.calculateGaugeBounds(new BlockCoord((TileEntity)this), this.multiblock);
        }
        return this.gaugeBounds;
    }

    public boolean chargeItems(ItemStack[] items) {
        boolean chargedItem = false;
        int available = Math.min(this.maxIO, this.getEnergyStored());
        for (ItemStack item : items) {
            if (item == null || available <= 0) continue;
            int used = 0;
            if (item.getItem() instanceof IEnergyContainerItem) {
                IEnergyContainerItem chargable = (IEnergyContainerItem)item.getItem();
                int max = chargable.getMaxEnergyStored(item);
                int cur = chargable.getEnergyStored(item);
                int canUse = Math.min(available, max - cur);
                if (cur < max) {
                    used = chargable.receiveEnergy(item, canUse, false);
                }
            }
            if (used <= 0) continue;
            this.setEnergyStored(this.getEnergyStored() - used);
            chargedItem = true;
            available -= used;
        }
        return chargedItem;
    }

    private void chargeItems() {
        boolean chargedItem = this.chargeItems(this.inventory);
        if (chargedItem) {
            this.markDirty();
        }
    }

    public boolean isOutputEnabled() {
        return this.getController().outputEnabled;
    }

    @Override
    public boolean isOutputEnabled(ForgeDirection direction) {
        IoMode mode = this.getIoMode(direction);
        return mode == IoMode.PUSH || mode == IoMode.NONE && this.isOutputEnabled();
    }

    public boolean isInputEnabled() {
        return this.getController().inputEnabled;
    }

    @Override
    public boolean isInputEnabled(ForgeDirection direction) {
        IoMode mode = this.getIoMode(direction);
        return mode == IoMode.PULL || mode == IoMode.NONE && this.isInputEnabled();
    }

    @Override
    public boolean isNetworkControlledIo(ForgeDirection direction) {
        IoMode mode = this.getIoMode(direction);
        return mode == IoMode.NONE || mode == IoMode.PULL;
    }

    private boolean transmitEnergy() {
        if (this.getEnergyStored() <= 0) {
            return false;
        }
        int canTransmit = Math.min(this.getEnergyStored(), this.maxOutput);
        int transmitted = 0;
        if (!this.masterReceptors.isEmpty() && !this.receptorIterator.hasNext()) {
            this.receptorIterator = this.masterReceptors.listIterator();
        }
        int numReceptors = this.masterReceptors.size();
        for (int appliedCount = 0; this.receptorIterator.hasNext() && canTransmit > 0 && appliedCount < numReceptors; ++appliedCount) {
            Receptor receptor = this.receptorIterator.next();
            IPowerInterface powerInterface = receptor.receptor;
            IoMode mode = receptor.mode;
            if (powerInterface != null && mode != IoMode.PULL && mode != IoMode.DISABLED && powerInterface.getMinEnergyReceived(receptor.fromDir.getOpposite()) <= canTransmit) {
                IConduitBundle bundle;
                IPowerConduit conduit;
                double used = receptor.receptor.getDelegate() instanceof IConduitBundle && !this.isCreative ? ((conduit = (bundle = (IConduitBundle)receptor.receptor.getDelegate()).getConduit(IPowerConduit.class)) != null && conduit.getConnectionMode(receptor.fromDir.getOpposite()) == ConnectionMode.INPUT ? (double)powerInterface.recieveEnergy(receptor.fromDir.getOpposite(), canTransmit) : 0.0) : (double)powerInterface.recieveEnergy(receptor.fromDir.getOpposite(), canTransmit);
                transmitted = (int)((double)transmitted + used);
                canTransmit = (int)((double)canTransmit - used);
            }
            if (canTransmit <= 0) break;
            if (this.masterReceptors.isEmpty() || this.receptorIterator.hasNext()) continue;
            this.receptorIterator = this.masterReceptors.listIterator();
        }
        this.setEnergyStored(this.getEnergyStored() - transmitted);
        return transmitted > 0;
    }

    private void updateMasterReceptors() {
        if (!this.masterReceptorsDirty && this.masterReceptors != null) {
            return;
        }
        if (this.masterReceptors == null) {
            this.masterReceptors = new ArrayList<Receptor>();
        }
        this.masterReceptors.clear();
        if (this.multiblock == null) {
            this.updateReceptors();
            if (this.localReceptors != null) {
                this.masterReceptors.addAll(this.localReceptors);
            }
        } else {
            for (BlockCoord bc : this.multiblock) {
                TileEntity te = this.worldObj.getTileEntity(bc.x, bc.y, bc.z);
                if (!(te instanceof TileCapacitorBank)) continue;
                TileCapacitorBank cb = (TileCapacitorBank)te;
                cb.updateReceptors();
                if (cb.localReceptors == null) continue;
                this.masterReceptors.addAll(cb.localReceptors);
            }
        }
        this.receptorIterator = this.masterReceptors.listIterator();
        this.masterReceptorsDirty = false;
    }

    private void updateReceptors() {
        if (!this.receptorsDirty) {
            return;
        }
        if (this.localReceptors != null) {
            this.localReceptors.clear();
        }
        BlockCoord bc = new BlockCoord((TileEntity)this);
        for (ForgeDirection dir : ForgeDirection.VALID_DIRECTIONS) {
            IPowerInterface ph;
            IoMode mode = this.getIoMode(dir);
            if (mode == IoMode.DISABLED) continue;
            BlockCoord checkLoc = bc.getLocation(dir);
            TileEntity te = this.worldObj.getTileEntity(checkLoc.x, checkLoc.y, checkLoc.z);
            if (te instanceof TileCapacitorBank || (ph = PowerHandlerUtil.create(te)) == null || !ph.canConduitConnect(dir)) continue;
            if (this.localReceptors == null) {
                this.localReceptors = new ArrayList<Receptor>();
            }
            Receptor r = new Receptor(ph, dir, mode);
            this.localReceptors.add(r);
            if (mode != IoMode.NONE || ph.getDelegate() instanceof IInternalPoweredTile) continue;
            this.setIoMode(dir, IoMode.PULL, false);
            r.mode = IoMode.PULL;
            this.render = true;
        }
        this.receptorsDirty = false;
    }

    public int getEnergyStoredScaled(int scale) {
        return this.getController().doGetEnergyStoredScaled(scale);
    }

    @Override
    public int getMaxInput() {
        return this.maxInput;
    }

    public void setMaxInput(int maxInput) {
        this.getController().doSetMaxInput(maxInput);
        this.updateBlock();
    }

    @Override
    public int getMaxOutput() {
        return this.maxOutput;
    }

    public void setMaxOutput(int maxOutput) {
        this.getController().doSetMaxOutput(maxOutput);
        this.updateBlock();
    }

    @Override
    public int getEnergyStored() {
        return this.getController().doGetEnergyStored();
    }

    @Override
    public long getEnergyStoredL() {
        return this.getEnergyStored();
    }

    public double getEnergyStoredRatio() {
        return this.getController().doGetEnergyStoredRatio();
    }

    @Override
    public int getMaxEnergyStored() {
        return this.getController().doGetMaxEnergyStored();
    }

    @Override
    public long getMaxEnergyStoredL() {
        return this.getMaxEnergyStored();
    }

    public int getMaxIO() {
        return this.getController().doGetMaxIO();
    }

    @Override
    public int getMaxEnergyRecieved(ForgeDirection dir) {
        return this.getMaxEnergyStored();
    }

    @Override
    public void setEnergyStored(int stored) {
        this.getController().doSetEnergyStored(stored);
    }

    @Override
    public int extractEnergy(ForgeDirection from, int maxExtract, boolean simulate) {
        return 0;
    }

    @Override
    public boolean canConnectEnergy(ForgeDirection from) {
        return this.getIoMode(from) != IoMode.DISABLED;
    }

    @Override
    public int receiveEnergy(ForgeDirection from, int maxReceive, boolean simulate) {
        IoMode mode = this.getIoMode(from);
        if (mode == IoMode.DISABLED || mode == IoMode.PUSH) {
            return 0;
        }
        return this.getController().doReceiveEnergy(from, maxReceive, simulate);
    }

    @Override
    public int getEnergyStored(ForgeDirection from) {
        return this.getController().doGetEnergyStored(from);
    }

    @Override
    public int getMaxEnergyStored(ForgeDirection from) {
        return this.getController().doGetMaxEnergyStored();
    }

    public int doReceiveEnergy(ForgeDirection from, int maxReceive, boolean simulate) {
        return PowerHandlerUtil.recieveInternal(this, maxReceive, from, simulate);
    }

    public int doGetEnergyStored(ForgeDirection from) {
        return this.doGetEnergyStored();
    }

    public int doGetMaxEnergyStored(ForgeDirection from) {
        return this.doGetMaxEnergyStored();
    }

    @Override
    public void addEnergy(int add) {
        this.getController().doAddEnergy(add);
    }

    private boolean isRecievingRedstoneSignal() {
        if (!this.redstoneStateDirty) {
            return this.isRecievingRedstoneSignal;
        }
        this.isRecievingRedstoneSignal = false;
        this.redstoneStateDirty = false;
        if (!this.isMultiblock()) {
            this.isRecievingRedstoneSignal = this.worldObj.getStrongestIndirectPower(this.xCoord, this.yCoord, this.zCoord) > 0;
        } else {
            for (BlockCoord bc : this.multiblock) {
                if (this.worldObj.getStrongestIndirectPower(bc.x, bc.y, bc.z) <= 0) continue;
                this.isRecievingRedstoneSignal = true;
                break;
            }
        }
        return this.isRecievingRedstoneSignal;
    }

    public RedstoneControlMode getInputControlMode() {
        return this.inputControlMode;
    }

    public void setInputControlMode(RedstoneControlMode inputControlMode) {
        if (!this.isMultiblock()) {
            this.inputControlMode = inputControlMode;
        } else {
            for (BlockCoord bc : this.multiblock) {
                TileCapacitorBank cp = this.getCapBank(bc);
                if (cp == null) continue;
                cp.inputControlMode = inputControlMode;
            }
        }
    }

    public RedstoneControlMode getOutputControlMode() {
        return this.outputControlMode;
    }

    public void setOutputControlMode(RedstoneControlMode outputControlMode) {
        if (!this.isMultiblock()) {
            this.outputControlMode = outputControlMode;
        } else {
            for (BlockCoord bc : this.multiblock) {
                TileCapacitorBank cp = this.getCapBank(bc);
                if (cp == null) continue;
                cp.outputControlMode = outputControlMode;
            }
        }
    }

    int doGetMaxIO() {
        return this.maxIO;
    }

    int doGetMaxEnergyStored() {
        return this.maxStoredEnergy;
    }

    int doGetEnergyStoredScaled(int scale) {
        return (int)VecmathUtil.clamp((double)Math.round((double)scale * this.doGetEnergyStoredRatio()), (double)0.0, (double)scale);
    }

    int doGetEnergyStored() {
        return this.storedEnergyRF;
    }

    void doSetEnergyStored(int stored) {
        this.storedEnergyRF = MathHelper.clamp_int((int)stored, (int)0, (int)this.getMaxEnergyStored());
    }

    double doGetEnergyStoredRatio() {
        return (double)this.doGetEnergyStored() / (double)this.maxStoredEnergy;
    }

    void doAddEnergy(int add) {
        this.doSetEnergyStored(this.doGetEnergyStored() + add);
    }

    void doSetMaxInput(int in) {
        this.maxInput = Math.min(in, this.maxIO);
        this.maxInput = Math.max(0, this.maxInput);
        if (this.isMultiblock()) {
            for (BlockCoord bc : this.multiblock) {
                TileCapacitorBank cp = this.getCapBank(bc);
                if (cp == null) continue;
                cp.maxInput = this.maxInput;
            }
        }
    }

    void doSetMaxOutput(int out) {
        this.maxOutput = Math.min(out, this.maxIO);
        this.maxOutput = Math.max(0, this.maxOutput);
        if (this.isMultiblock()) {
            for (BlockCoord bc : this.multiblock) {
                TileCapacitorBank cp = this.getCapBank(bc);
                if (cp == null) continue;
                cp.maxOutput = this.maxOutput;
            }
        }
    }

    public void onBlockAdded() {
        this.multiblockDirty = true;
    }

    public void onNeighborBlockChange(Block block) {
        if (block != EnderIO.blockCapacitorBank) {
            this.receptorsDirty = true;
            this.getController().masterReceptorsDirty = true;
            this.getController().redstoneStateDirty = true;
        }
        this.redstoneStateDirty = true;
    }

    public void onBreakBlock() {
        TileCapacitorBank controller = this.getController();
        controller.clearCurrentMultiblock();
    }

    private void clearCurrentMultiblock() {
        if (this.multiblock == null) {
            return;
        }
        for (BlockCoord bc : this.multiblock) {
            TileCapacitorBank res = this.getCapBank(bc);
            if (res == null) continue;
            res.setMultiblock(null);
        }
        this.multiblock = null;
        this.redstoneStateDirty = true;
    }

    private void formMultiblock() {
        if (this.isCreative || this.isMaxSize()) {
            return;
        }
        ArrayList<TileCapacitorBank> blocks = new ArrayList<TileCapacitorBank>();
        blocks.add(this);
        this.findNighbouringBanks(this, blocks);
        if (blocks.size() < 2) {
            return;
        }
        for (TileCapacitorBank cb : blocks) {
            cb.clearCurrentMultiblock();
        }
        BlockCoord[] mb = new BlockCoord[blocks.size()];
        for (int i = 0; i < blocks.size(); ++i) {
            mb[i] = new BlockCoord((TileEntity)blocks.get(i));
        }
        TileCapacitorBank secondary = (TileCapacitorBank)blocks.get(1);
        this.maxOutput = -1;
        this.maxInput = -1;
        if (secondary.maxInput != secondary.maxIO) {
            this.maxInput = secondary.maxInput;
        }
        if (secondary.maxOutput != secondary.maxIO) {
            this.maxOutput = secondary.maxOutput;
        }
        for (TileCapacitorBank cb : blocks) {
            cb.setMultiblock(mb);
        }
    }

    private void findNighbouringBanks(TileCapacitorBank tileCapacitorBank, List<TileCapacitorBank> blocks) {
        if (this.isCreative || blocks.size() >= MAX_SIZE) {
            return;
        }
        BlockCoord bc = new BlockCoord((TileEntity)tileCapacitorBank);
        for (ForgeDirection dir : ForgeDirection.VALID_DIRECTIONS) {
            TileCapacitorBank cb = this.getCapBank(bc.getLocation(dir));
            if (cb == null || blocks.contains(cb) || cb.isCreative || cb.isMaxSize()) continue;
            if (blocks.size() >= MAX_SIZE) {
                return;
            }
            blocks.add(cb);
            this.findNighbouringBanks(cb, blocks);
        }
    }

    private void setMultiblock(BlockCoord[] mb) {
        if (this.multiblock != null && this.isMaster()) {
            int powerPerBlock = this.storedEnergyRF / this.multiblock.length;
            int remaining = this.storedEnergyRF % this.multiblock.length;
            for (BlockCoord bc : this.multiblock) {
                TileCapacitorBank cb = this.getCapBank(bc);
                if (cb == null) continue;
                cb.maxStoredEnergy = BASE_CAP.getMaxEnergyStored();
                cb.maxIO = BASE_CAP.getMaxEnergyExtracted();
                cb.maxInput = Math.min(cb.maxInput, cb.maxIO);
                cb.maxOutput = Math.min(cb.maxOutput, cb.maxIO);
                cb.doSetEnergyStored(powerPerBlock);
                cb.multiblockDirty = true;
            }
            this.doAddEnergy(remaining);
        }
        this.multiblock = mb;
        if (this.isMaster()) {
            TileCapacitorBank cb;
            ArrayList<ItemStack> invItems = new ArrayList<ItemStack>();
            int totalStored = 0;
            int totalCap = this.multiblock.length * BASE_CAP.getMaxEnergyStored();
            int totalIO = this.multiblock.length * BASE_CAP.getMaxEnergyExtracted();
            for (BlockCoord bc : this.multiblock) {
                cb = this.getCapBank(bc);
                if (cb != null) {
                    totalStored += cb.doGetEnergyStored();
                }
                ItemStack[] inv = cb.inventory;
                for (int i = 0; i < inv.length; ++i) {
                    if (inv[i] == null) continue;
                    invItems.add(inv[i]);
                    inv[i] = null;
                }
                cb.multiblockDirty = false;
            }
            this.maxStoredEnergy = totalCap;
            this.doSetEnergyStored(totalStored);
            this.maxIO = totalIO;
            this.maxInput = this.maxInput < 0 ? this.maxIO : Math.min(this.maxInput, this.maxIO);
            this.maxOutput = this.maxOutput < 0 ? this.maxIO : Math.min(this.maxOutput, this.maxIO);
            for (BlockCoord bc : this.multiblock) {
                cb = this.getCapBank(bc);
                if (cb == null || cb == this) continue;
                cb.maxIO = totalIO;
                cb.maxInput = this.maxInput;
                cb.maxOutput = this.maxOutput;
            }
            if (invItems.size() > this.inventory.length) {
                for (int i = this.inventory.length; i < invItems.size(); ++i) {
                    Util.dropItems((World)this.worldObj, (ItemStack)((ItemStack)invItems.get(i)), (int)this.xCoord, (int)this.yCoord, (int)this.zCoord, (boolean)true);
                }
            }
            for (int i = 0; i < this.inventory.length && i < invItems.size(); ++i) {
                this.inventory[i] = (ItemStack)invItems.get(i);
            }
        }
        this.receptorsDirty = true;
        this.getController().masterReceptorsDirty = true;
        this.redstoneStateDirty = true;
        this.worldObj.markBlockForUpdate(this.xCoord, this.yCoord, this.zCoord);
        this.render = true;
    }

    @Override
    public TileCapacitorBank getController() {
        if (this.isMaster() || !this.isMultiblock()) {
            return this;
        }
        TileCapacitorBank res = this.getCapBank(this.multiblock[0]);
        return res != null ? res : this;
    }

    boolean isContoller() {
        return this.multiblock == null ? true : this.isMaster();
    }

    boolean isMaster() {
        if (this.multiblock != null) {
            return this.multiblock[0].equals(this.xCoord, this.yCoord, this.zCoord);
        }
        return false;
    }

    public boolean isMultiblock() {
        return this.multiblock != null;
    }

    private boolean isCurrentMultiblockValid() {
        if (this.multiblock == null) {
            return false;
        }
        for (BlockCoord bc : this.multiblock) {
            TileCapacitorBank res = this.getCapBank(bc);
            if (res != null && res.isMultiblock()) continue;
            return false;
        }
        return true;
    }

    private TileCapacitorBank getCapBank(BlockCoord bc) {
        return this.getCapBank(bc.x, bc.y, bc.z);
    }

    private TileCapacitorBank getCapBank(int x, int y, int z) {
        if (this.worldObj == null) {
            return null;
        }
        TileEntity te = this.worldObj.getTileEntity(x, y, z);
        if (te instanceof TileCapacitorBank) {
            return (TileCapacitorBank)te;
        }
        return null;
    }

    public int getSizeInventory() {
        return this.getController().doGetSizeInventory();
    }

    public ItemStack getStackInSlot(int i) {
        return this.getController().doGetStackInSlot(i);
    }

    public ItemStack decrStackSize(int i, int j) {
        return this.getController().doDecrStackSize(i, j);
    }

    public void setInventorySlotContents(int i, ItemStack itemstack) {
        this.getController().doSetInventorySlotContents(i, itemstack);
    }

    public ItemStack doGetStackInSlot(int i) {
        if (i < 0 || i >= this.inventory.length) {
            return null;
        }
        return this.inventory[i];
    }

    public int doGetSizeInventory() {
        return this.inventory.length;
    }

    public ItemStack doDecrStackSize(int fromSlot, int amount) {
        if (fromSlot < 0 || fromSlot >= this.inventory.length) {
            return null;
        }
        ItemStack item = this.inventory[fromSlot];
        if (item == null) {
            return null;
        }
        if (item.stackSize <= amount) {
            ItemStack result = item.copy();
            this.inventory[fromSlot] = null;
            return result;
        }
        item.stackSize -= amount;
        return item.copy();
    }

    public void doSetInventorySlotContents(int i, ItemStack itemstack) {
        if (i < 0 || i >= this.inventory.length) {
            return;
        }
        this.inventory[i] = itemstack;
    }

    public ItemStack getStackInSlotOnClosing(int i) {
        return null;
    }

    public String getInventoryName() {
        return EnderIO.blockCapacitorBank.getUnlocalizedName() + ".name";
    }

    public int getInventoryStackLimit() {
        return 1;
    }

    public boolean isUseableByPlayer(EntityPlayer entityplayer) {
        return true;
    }

    public void openInventory() {
    }

    public void closeInventory() {
    }

    public boolean isItemValidForSlot(int i, ItemStack itemstack) {
        if (itemstack == null) {
            return false;
        }
        return itemstack.getItem() instanceof IEnergyContainerItem;
    }

    public void readCustomNBT(NBTTagCompound nbtRoot) {
        double change;
        if (nbtRoot.hasKey("maxStoredEnergy")) {
            nbtRoot.setInteger("maxStoredEnergyRF", nbtRoot.getInteger("maxStoredEnergy") * 10);
        }
        this.maxStoredEnergy = nbtRoot.getInteger("maxStoredEnergyRF");
        double oldEnergy = this.storedEnergyRF;
        if (nbtRoot.hasKey("storedEnergyD")) {
            nbtRoot.setInteger("storedEnergyRF", (int)(nbtRoot.getDouble("storedEnergyD") * 10.0));
        }
        this.doSetEnergyStored(nbtRoot.getInteger("storedEnergyRF"));
        double newEnergy = this.storedEnergyRF;
        if (this.maxStoredEnergy != 0 && Math.abs(oldEnergy - newEnergy) / (double)this.maxStoredEnergy > 0.05 || nbtRoot.hasKey("render")) {
            this.render = true;
        }
        if (this.energyAtLastRender != -1 && this.maxStoredEnergy != 0 && (change = (double)Math.abs(this.energyAtLastRender - this.storedEnergyRF) / (double)this.maxStoredEnergy) > 0.05) {
            this.render = true;
        }
        if (nbtRoot.hasKey("maxIO")) {
            nbtRoot.setInteger("maxIoRF", nbtRoot.getInteger("maxIO") * 10);
        }
        this.maxIO = nbtRoot.getInteger("maxIoRF");
        if (nbtRoot.hasKey("maxInput")) {
            nbtRoot.setInteger("maxInputRF", nbtRoot.getInteger("maxInput") * 10);
        }
        if (nbtRoot.hasKey("maxInputRF")) {
            this.maxInput = nbtRoot.getInteger("maxInputRF");
        } else {
            this.maxOutput = this.maxIO;
        }
        if (nbtRoot.hasKey("maxOutput")) {
            nbtRoot.setInteger("maxOuputRF", nbtRoot.getInteger("maxOuput") * 10);
        }
        if (nbtRoot.hasKey("maxOutputRF")) {
            this.maxOutput = nbtRoot.getInteger("maxOutputRF");
        } else {
            this.maxInput = this.maxIO;
        }
        this.inputControlMode = RedstoneControlMode.values()[nbtRoot.getShort("inputControlMode")];
        this.outputControlMode = RedstoneControlMode.values()[nbtRoot.getShort("outputControlMode")];
        boolean wasMulti = this.isMultiblock();
        if (nbtRoot.getBoolean("isMultiblock")) {
            int[] coords = nbtRoot.getIntArray("multiblock");
            this.multiblock = new BlockCoord[coords.length / 3];
            int c = 0;
            for (int i = 0; i < this.multiblock.length; ++i) {
                this.multiblock[i] = new BlockCoord(coords[c++], coords[c++], coords[c++]);
            }
        } else {
            this.multiblock = null;
        }
        for (int i = 0; i < this.inventory.length; ++i) {
            this.inventory[i] = null;
        }
        NBTTagList itemList = (NBTTagList)nbtRoot.getTag("Items");
        if (itemList != null) {
            for (int i = 0; i < itemList.tagCount(); ++i) {
                NBTTagCompound itemStack = itemList.getCompoundTagAt(i);
                byte slot = itemStack.getByte("Slot");
                if (slot < 0 || slot >= this.inventory.length) continue;
                this.inventory[slot] = ItemStack.loadItemStackFromNBT((NBTTagCompound)itemStack);
            }
        }
        if (nbtRoot.hasKey("hasFaces")) {
            for (ForgeDirection dir : ForgeDirection.VALID_DIRECTIONS) {
                if (!nbtRoot.hasKey("face" + dir.ordinal())) continue;
                this.setIoMode(dir, IoMode.values()[nbtRoot.getShort("face" + dir.ordinal())], false);
            }
        }
        this.gaugeBounds = null;
    }

    public void writeCustomNBT(NBTTagCompound nbtRoot) {
        int i;
        nbtRoot.setDouble("storedEnergyRF", (double)this.storedEnergyRF);
        nbtRoot.setInteger("maxStoredEnergyRF", this.maxStoredEnergy);
        nbtRoot.setInteger("maxIoRF", this.maxIO);
        nbtRoot.setInteger("maxInputRF", this.maxInput);
        nbtRoot.setInteger("maxOutputRF", this.maxOutput);
        nbtRoot.setShort("inputControlMode", (short)this.inputControlMode.ordinal());
        nbtRoot.setShort("outputControlMode", (short)this.outputControlMode.ordinal());
        nbtRoot.setBoolean("isMultiblock", this.isMultiblock());
        if (this.isMultiblock()) {
            int[] vals = new int[this.multiblock.length * 3];
            i = 0;
            for (BlockCoord bc : this.multiblock) {
                vals[i++] = bc.x;
                vals[i++] = bc.y;
                vals[i++] = bc.z;
            }
            nbtRoot.setIntArray("multiblock", vals);
        }
        NBTTagList itemList = new NBTTagList();
        for (i = 0; i < this.inventory.length; ++i) {
            if (this.inventory[i] == null) continue;
            NBTTagCompound itemStackNBT = new NBTTagCompound();
            itemStackNBT.setByte("Slot", (byte)i);
            this.inventory[i].writeToNBT(itemStackNBT);
            itemList.appendTag((NBTBase)itemStackNBT);
        }
        nbtRoot.setTag("Items", (NBTBase)itemList);
        if (this.faceModes != null) {
            nbtRoot.setByte("hasFaces", (byte)1);
            for (Map.Entry<ForgeDirection, IoMode> e : this.faceModes.entrySet()) {
                nbtRoot.setShort("face" + e.getKey().ordinal(), (short)e.getValue().ordinal());
            }
        }
        if (this.render) {
            nbtRoot.setBoolean("render", true);
            this.render = false;
        }
    }

    public boolean hasCustomInventoryName() {
        return false;
    }

    public void setCreativeMode() {
        this.isCreative = true;
        this.maxIO *= 1000;
        this.maxInput = this.maxIO;
        this.maxOutput = this.maxIO;
    }

    @Override
    public boolean isCreative() {
        return this.isCreative;
    }

    public boolean isMaxSize() {
        return this.isMultiblock() && this.multiblock.length >= MAX_SIZE;
    }

    @Override
    public boolean displayPower() {
        return true;
    }

    static class Receptor {
        IPowerInterface receptor;
        ForgeDirection fromDir;
        IoMode mode;

        private Receptor(IPowerInterface rec, ForgeDirection fromDir, IoMode mode) {
            this.receptor = rec;
            this.fromDir = fromDir;
            this.mode = mode;
        }

        public String toString() {
            return "Receptor [receptor=" + this.receptor + ", fromDir=" + this.fromDir + ", mode=" + (Object)((Object)this.mode) + "]";
        }
    }
}

