/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.machine.painter;

import com.google.common.base.Strings;
import crazypants.enderio.EnderIO;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRotatedPillar;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.util.ForgeDirection;

public final class PainterUtil {
    private PainterUtil() {
    }

    public static boolean isMetadataEquivelent(ItemStack one, ItemStack two) {
        if (one == null || two == null) {
            return false;
        }
        return PainterUtil.getSourceBlock(one) == PainterUtil.getSourceBlock(two) && PainterUtil.getSourceBlockMetadata(one) == PainterUtil.getSourceBlockMetadata(two);
    }

    public static Block getSourceBlock(ItemStack item) {
        NBTTagCompound tag = item.getTagCompound();
        return PainterUtil.getSourceBlock(tag);
    }

    public static Block getSourceBlock(NBTTagCompound tag) {
        String blockId;
        if (tag != null && !Strings.isNullOrEmpty((String)(blockId = tag.getString("sourceBlockId")))) {
            Block res = (Block)Block.blockRegistry.getObject(blockId);
            return res;
        }
        return null;
    }

    public static int getSourceBlockMetadata(ItemStack item) {
        NBTTagCompound tag = item.getTagCompound();
        return PainterUtil.getSourceBlockMetadata(tag);
    }

    public static int getSourceBlockMetadata(NBTTagCompound tag) {
        if (tag != null) {
            return tag.getInteger("sourceBlockMeta");
        }
        return 0;
    }

    public static String getTooltTipText(ItemStack item) {
        Item itemFromBlock;
        String sourceName = "";
        Block sourceId = PainterUtil.getSourceBlock(item);
        int meta = PainterUtil.getSourceBlockMetadata(item);
        if (sourceId != null && (itemFromBlock = Item.getItemFromBlock((Block)sourceId)) != null) {
            ItemStack is = new ItemStack(itemFromBlock, 1, meta);
            sourceName = is.getDisplayName();
        }
        return EnderIO.lang.localize("blockPainter.paintedWith") + " " + sourceName;
    }

    public static void setSourceBlock(ItemStack item, Block source, int meta) {
        NBTTagCompound tag = item.getTagCompound();
        if (tag == null) {
            tag = new NBTTagCompound();
            item.setTagCompound(tag);
        }
        PainterUtil.setSourceBlock(item.getTagCompound(), source, meta);
        if (item.getTagCompound().hasNoTags()) {
            item.setTagCompound(null);
        }
    }

    public static void setSourceBlock(NBTTagCompound tag, Block source, int meta) {
        if (tag == null) {
            return;
        }
        String name = Block.blockRegistry.getNameForObject((Object)source);
        if (name != null && !name.trim().isEmpty()) {
            meta = PainterUtil.normalizeFacadeMetadata(source, meta);
            tag.setString("sourceBlockId", name);
            tag.setInteger("sourceBlockMeta", meta);
        }
    }

    public static ItemStack applyDefaultPaintedState(ItemStack stack) {
        PainterUtil.setSourceBlock(stack, Blocks.stone, 0);
        return stack;
    }

    public static int normalizeFacadeMetadata(Block facadeID, int facadeMeta) {
        if (facadeID instanceof BlockRotatedPillar) {
            return facadeMeta & 3;
        }
        return facadeMeta;
    }

    public static int adjustFacadeMetadata(Block facadeID, int facadeMeta, int side) {
        if (facadeID instanceof BlockRotatedPillar) {
            int dir = facadeMeta & 0xC;
            switch (side) {
                case 0: 
                case 1: {
                    dir = 0;
                    break;
                }
                case 4: 
                case 5: {
                    dir = 4;
                    break;
                }
                case 2: 
                case 3: {
                    dir = 8;
                }
            }
            facadeMeta = facadeMeta & 3 | dir;
        }
        return facadeMeta;
    }

    public static int rotateFacadeMetadata(Block facadeID, int facadeMeta, ForgeDirection axis) {
        if (facadeID instanceof BlockRotatedPillar) {
            ForgeDirection orientation;
            int dir = facadeMeta & 0xC;
            switch (dir) {
                case 0: {
                    orientation = ForgeDirection.UP;
                    break;
                }
                case 4: {
                    orientation = ForgeDirection.EAST;
                    break;
                }
                case 8: {
                    orientation = ForgeDirection.SOUTH;
                    break;
                }
                default: {
                    return facadeMeta;
                }
            }
            orientation = orientation.getRotation(axis);
            switch (orientation) {
                case UP: 
                case DOWN: {
                    dir = 0;
                    break;
                }
                case WEST: 
                case EAST: {
                    dir = 4;
                    break;
                }
                case NORTH: 
                case SOUTH: {
                    dir = 8;
                    break;
                }
                default: {
                    return facadeMeta;
                }
            }
            return facadeMeta & 3 | dir;
        }
        return facadeMeta;
    }
}

