/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.machine.painter;

import com.enderio.core.client.render.RenderUtil;
import crazypants.enderio.EnderIO;
import crazypants.enderio.machine.painter.PainterUtil;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraftforge.client.IItemRenderer;
import org.lwjgl.opengl.GL11;

public class PaintedItemRenderer
implements IItemRenderer {
    public boolean handleRenderType(ItemStack item, IItemRenderer.ItemRenderType type) {
        return true;
    }

    public boolean shouldUseRenderHelper(IItemRenderer.ItemRenderType type, ItemStack item, IItemRenderer.ItemRendererHelper helper) {
        return true;
    }

    public void renderItem(IItemRenderer.ItemRenderType type, ItemStack item, Object ... data) {
        if (data != null && data.length > 0) {
            if (type == IItemRenderer.ItemRenderType.EQUIPPED_FIRST_PERSON || type == IItemRenderer.ItemRenderType.EQUIPPED) {
                this.renderEquipped(item, (RenderBlocks)data[0]);
            } else {
                this.renderToInventory(item, (RenderBlocks)data[0]);
            }
        }
    }

    public void renderEquipped(ItemStack item, RenderBlocks renderBlocks) {
        GL11.glPushMatrix();
        GL11.glTranslatef((float)0.5f, (float)0.5f, (float)0.5f);
        this.renderToInventory(item, renderBlocks);
        GL11.glPopMatrix();
    }

    public void renderToInventory(ItemStack item, RenderBlocks renderBlocks) {
        Item i;
        if (item.getItem() == Item.getItemFromBlock((Block)EnderIO.blockPaintedGlowstone) || item.getItem() == Item.getItemFromBlock((Block)EnderIO.blockTravelPlatform)) {
            int meta;
            Block block = PainterUtil.getSourceBlock(item);
            RenderUtil.bindBlockTexture();
            boolean renderOverlay = true;
            if (block != null) {
                meta = PainterUtil.getSourceBlockMetadata(item);
            } else {
                block = Block.getBlockFromItem((Item)item.getItem());
                meta = item.getItemDamage();
                renderOverlay = false;
            }
            renderBlocks.renderBlockAsItem(block, meta, 1.0f);
            if (renderOverlay) {
                this.renderOverlay(block, meta, renderBlocks);
            }
            renderBlocks.clearOverrideBlockTexture();
            return;
        }
        Block block = PainterUtil.getSourceBlock(item);
        if (block != null) {
            int meta = PainterUtil.getSourceBlockMetadata(item);
            if (block == EnderIO.blockFusedQuartz && meta == 1) {
                renderBlocks.setOverrideBlockTexture(EnderIO.blockPainter.getInvisibleIcon());
            } else {
                renderBlocks.setOverrideBlockTexture(renderBlocks.getBlockIconFromSideAndMetadata(block, 2, meta));
            }
        }
        if ((i = item.getItem()) instanceof ItemBlock) {
            Block blk = ((ItemBlock)i).field_150939_a;
            int meta = item.getItemDamage();
            renderBlocks.renderBlockAsItem(blk, meta, 1.0f);
            this.renderOverlay(blk, meta, renderBlocks);
        }
        renderBlocks.clearOverrideBlockTexture();
    }

    protected void renderOverlay(Block block, int meta, RenderBlocks renderBlocks) {
        GL11.glPushAttrib((int)8192);
        GL11.glDisable((int)2896);
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glEnable((int)32823);
        GL11.glPolygonOffset((float)-1.0f, (float)-1.0f);
        RenderUtil.bindItemTexture();
        renderBlocks.setOverrideBlockTexture(EnderIO.itemConduitFacade.getOverlayIcon());
        renderBlocks.renderBlockAsItem(block, meta, 1.0f);
        GL11.glPopAttrib();
    }
}

