/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.machine.painter;

import com.enderio.core.client.render.CubeRenderer;
import com.enderio.core.client.render.IconUtil;
import com.enderio.core.common.util.BlockCoord;
import cpw.mods.fml.client.registry.ISimpleBlockRenderingHandler;
import crazypants.enderio.machine.painter.IPaintableTileEntity;
import crazypants.enderio.machine.painter.PaintedBlockAccessWrapper;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.init.Blocks;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.util.ForgeDirection;

public class PaintedBlockRenderer
implements ISimpleBlockRenderingHandler {
    private int renderId;
    private Block defaultBlock;

    public PaintedBlockRenderer(int renderId, Block defaultBlock) {
        this.renderId = renderId;
        this.defaultBlock = defaultBlock;
    }

    public int getRenderId() {
        return this.renderId;
    }

    public void renderInventoryBlock(Block blk, int meta, int modelId, RenderBlocks arg3) {
        Tessellator.instance.startDrawingQuads();
        CubeRenderer.render((Block)blk, (int)meta);
        Tessellator.instance.draw();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean renderWorldBlock(IBlockAccess ba, int x, int y, int z, Block block, int arg5, RenderBlocks rb) {
        TileEntity tile = ba.getTileEntity(x, y, z);
        if (!(tile instanceof IPaintableTileEntity)) {
            return false;
        }
        IPaintableTileEntity te = (IPaintableTileEntity)tile;
        Block srcBlk = te.getSourceBlock();
        if (srcBlk == null) {
            srcBlk = this.defaultBlock;
        }
        IBlockAccess origBa = rb.blockAccess;
        try {
            rb.blockAccess = new PaintedBlockAccessWrapper(origBa);
            if (block.isOpaqueCube() && this.nonSolidPaintedBlockAround(new BlockCoord(x, y, z), origBa, rb.blockAccess)) {
                if (srcBlk == block) {
                    rb.setRenderAllFaces(true);
                    rb.renderStandardBlock(srcBlk, x, y, z);
                    rb.setRenderAllFaces(false);
                } else {
                    rb.renderBlockAllFaces(srcBlk, x, y, z);
                }
            } else if (srcBlk == block) {
                rb.renderStandardBlock(srcBlk, x, y, z);
            } else {
                rb.renderBlockByRenderType(srcBlk, x, y, z);
            }
        }
        catch (Exception e) {
            rb.setOverrideBlockTexture(IconUtil.errorTexture);
            rb.renderStandardBlock(Blocks.stone, x, y, z);
            rb.setOverrideBlockTexture(null);
        }
        finally {
            rb.blockAccess = origBa;
        }
        return true;
    }

    private boolean nonSolidPaintedBlockAround(BlockCoord bc, IBlockAccess reality, IBlockAccess fake) {
        for (ForgeDirection dir : ForgeDirection.VALID_DIRECTIONS) {
            BlockCoord toTest = bc.getLocation(dir);
            if (toTest.y < 0 || toTest.y > 255 || toTest.getBlock(reality).isOpaqueCube() == toTest.getBlock(fake).isOpaqueCube()) continue;
            return true;
        }
        return false;
    }

    public boolean shouldRender3DInInventory(int arg0) {
        return false;
    }
}

