/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.machine.painter;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import crazypants.enderio.ModObject;
import crazypants.enderio.machine.AbstractMachineBlock;
import crazypants.enderio.machine.painter.GuiPainter;
import crazypants.enderio.machine.painter.PainterContainer;
import crazypants.enderio.machine.painter.TileEntityPainter;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.world.World;

public class BlockPainter
extends AbstractMachineBlock<TileEntityPainter> {
    public static final String KEY_SOURCE_BLOCK_ID = "sourceBlockId";
    public static final String KEY_SOURCE_BLOCK_META = "sourceBlockMeta";
    private IIcon invisibleIcon;

    public static BlockPainter create() {
        BlockPainter ppainter = new BlockPainter();
        ppainter.init();
        return ppainter;
    }

    private BlockPainter() {
        super(ModObject.blockPainter, TileEntityPainter.class);
    }

    public Object getServerGuiElement(int ID, EntityPlayer player, World world, int x, int y, int z) {
        TileEntity te = world.getTileEntity(x, y, z);
        if (te instanceof TileEntityPainter) {
            return new PainterContainer(player.inventory, (TileEntityPainter)te);
        }
        return null;
    }

    @SideOnly(value=Side.CLIENT)
    public Object getClientGuiElement(int ID, EntityPlayer player, World world, int x, int y, int z) {
        TileEntity te = world.getTileEntity(x, y, z);
        return new GuiPainter(player.inventory, (TileEntityPainter)te);
    }

    @Override
    protected int getGuiId() {
        return 2;
    }

    public IIcon getInvisibleIcon() {
        return this.invisibleIcon;
    }

    public void setInvisibleIcon(IIcon invisibleIcon) {
        this.invisibleIcon = invisibleIcon;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void registerBlockIcons(IIconRegister iIconRegister) {
        super.registerBlockIcons(iIconRegister);
        this.invisibleIcon = iIconRegister.registerIcon("enderio:invisblePaint");
    }

    @Override
    protected String getMachineFrontIconKey(boolean active) {
        if (active) {
            return "enderio:painterFrontOn";
        }
        return "enderio:painterFrontOff";
    }
}

