/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.machine.painter;

import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import crazypants.enderio.EnderIO;
import crazypants.enderio.ModObject;
import crazypants.enderio.machine.IMachineRecipe;
import crazypants.enderio.machine.MachineRecipeInput;
import crazypants.enderio.machine.MachineRecipeRegistry;
import crazypants.enderio.machine.painter.BasicPainterTemplate;
import crazypants.enderio.machine.painter.BlockItemPaintedWall;
import crazypants.enderio.machine.painter.IPaintedBlock;
import crazypants.enderio.machine.painter.PainterUtil;
import crazypants.enderio.machine.painter.TileEntityPaintedBlock;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockWall;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.client.particle.EffectRenderer;
import net.minecraft.client.particle.EntityDiggingFX;
import net.minecraft.client.particle.EntityFX;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class BlockPaintedWall
extends BlockWall
implements ITileEntityProvider,
IPaintedBlock {
    private IIcon lastRemovedComponetIcon = null;
    private Random rand = new Random();

    public static BlockPaintedWall create() {
        BlockPaintedWall result = new BlockPaintedWall();
        result.init();
        return result;
    }

    public BlockPaintedWall() {
        super(Blocks.cobblestone);
        this.setCreativeTab(null);
        this.setBlockName(ModObject.blockPaintedWall.unlocalisedName);
    }

    private void init() {
        GameRegistry.registerBlock((Block)this, BlockItemPaintedWall.class, (String)ModObject.blockPaintedWall.unlocalisedName);
        GameRegistry.registerTileEntity(TileEntityPaintedBlock.class, (String)(ModObject.blockPaintedWall.unlocalisedName + "TileEntity"));
        MachineRecipeRegistry.instance.registerRecipe(ModObject.blockPainter.unlocalisedName, new PainterTemplate());
    }

    public static ItemStack createItemStackForSourceBlock(Block id, int damage) {
        ItemStack result = new ItemStack((Block)EnderIO.blockPaintedWall, 1, damage);
        PainterUtil.setSourceBlock(result, id, damage);
        return result;
    }

    @SideOnly(value=Side.CLIENT)
    public void getSubBlocks(Item item, CreativeTabs tab, List list) {
        list.add(PainterUtil.applyDefaultPaintedState(new ItemStack(item)));
    }

    @SideOnly(value=Side.CLIENT)
    public boolean addHitEffects(World world, MovingObjectPosition target, EffectRenderer effectRenderer) {
        IIcon tex = null;
        TileEntityPaintedBlock cb = (TileEntityPaintedBlock)world.getTileEntity(target.blockX, target.blockY, target.blockZ);
        Block b = cb.getSourceBlock();
        if (b != null) {
            tex = b.getIcon(ForgeDirection.NORTH.ordinal(), cb.getSourceBlockMetadata());
        }
        if (tex == null) {
            tex = this.blockIcon;
        }
        this.lastRemovedComponetIcon = tex;
        this.addBlockHitEffects(world, effectRenderer, target.blockX, target.blockY, target.blockZ, target.sideHit, tex);
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean addDestroyEffects(World world, int x, int y, int z, int meta, EffectRenderer effectRenderer) {
        IIcon tex = this.lastRemovedComponetIcon;
        int b0 = 4;
        for (int j1 = 0; j1 < b0; ++j1) {
            for (int k1 = 0; k1 < b0; ++k1) {
                for (int l1 = 0; l1 < b0; ++l1) {
                    double d0 = (double)x + ((double)j1 + 0.5) / (double)b0;
                    double d1 = (double)y + ((double)k1 + 0.5) / (double)b0;
                    double d2 = (double)z + ((double)l1 + 0.5) / (double)b0;
                    int i2 = this.rand.nextInt(6);
                    EntityDiggingFX fx = new EntityDiggingFX(world, d0, d1, d2, d0 - (double)x - 0.5, d1 - (double)y - 0.5, d2 - (double)z - 0.5, (Block)this, i2, 0).applyColourMultiplier(x, y, z);
                    fx.setParticleIcon(tex);
                    effectRenderer.addEffect((EntityFX)fx);
                }
            }
        }
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    private void addBlockHitEffects(World world, EffectRenderer effectRenderer, int x, int y, int z, int side, IIcon tex) {
        float f = 0.1f;
        double d0 = (double)x + this.rand.nextDouble() * (this.getBlockBoundsMaxX() - this.getBlockBoundsMinX() - (double)(f * 2.0f)) + (double)f + this.getBlockBoundsMinX();
        double d1 = (double)y + this.rand.nextDouble() * (this.getBlockBoundsMaxY() - this.getBlockBoundsMinY() - (double)(f * 2.0f)) + (double)f + this.getBlockBoundsMinY();
        double d2 = (double)z + this.rand.nextDouble() * (this.getBlockBoundsMaxZ() - this.getBlockBoundsMinZ() - (double)(f * 2.0f)) + (double)f + this.getBlockBoundsMinZ();
        if (side == 0) {
            d1 = (double)y + this.getBlockBoundsMinY() - (double)f;
        } else if (side == 1) {
            d1 = (double)y + this.getBlockBoundsMaxY() + (double)f;
        } else if (side == 2) {
            d2 = (double)z + this.getBlockBoundsMinZ() - (double)f;
        } else if (side == 3) {
            d2 = (double)z + this.getBlockBoundsMaxZ() + (double)f;
        } else if (side == 4) {
            d0 = (double)x + this.getBlockBoundsMinX() - (double)f;
        } else if (side == 5) {
            d0 = (double)x + this.getBlockBoundsMaxX() + (double)f;
        }
        EntityDiggingFX digFX = new EntityDiggingFX(world, d0, d1, d2, 0.0, 0.0, 0.0, (Block)this, side, 0);
        digFX.applyColourMultiplier(x, y, z).multiplyVelocity(0.2f).multipleParticleScaleBy(0.6f);
        digFX.setParticleIcon(tex);
        effectRenderer.addEffect((EntityFX)digFX);
    }

    public int getLightOpacity(IBlockAccess world, int x, int y, int z) {
        TileEntityPaintedBlock tef;
        TileEntity te = world.getTileEntity(x, y, z);
        if (te instanceof TileEntityPaintedBlock && (tef = (TileEntityPaintedBlock)te).getSourceBlock() != null) {
            return Math.min(super.getLightOpacity(world, x, y, z), tef.getSourceBlock().getLightOpacity(world, x, y, z));
        }
        return super.getLightOpacity(world, x, y, z);
    }

    public boolean canPlaceTorchOnTop(World world, int x, int y, int z) {
        Block id = world.getBlock(x, y, z);
        if (id == this) {
            return true;
        }
        return super.canPlaceTorchOnTop(world, x, y, z);
    }

    public boolean canConnectWallTo(IBlockAccess par1IBlockAccess, int par2, int par3, int par4) {
        Block l = par1IBlockAccess.getBlock(par2, par3, par4);
        if (l == EnderIO.blockPaintedFenceGate) {
            return true;
        }
        return super.canConnectWallTo(par1IBlockAccess, par2, par3, par4);
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon getIcon(IBlockAccess world, int x, int y, int z, int blockSide) {
        TileEntityPaintedBlock tef;
        TileEntity te = world.getTileEntity(x, y, z);
        if (te instanceof TileEntityPaintedBlock && (tef = (TileEntityPaintedBlock)te).getSourceBlock() != null) {
            return tef.getSourceBlock().getIcon(blockSide, tef.getSourceBlockMetadata());
        }
        return Blocks.anvil.getIcon(world, x, y, z, blockSide);
    }

    public TileEntity createNewTileEntity(World world, int metadata) {
        return new TileEntityPaintedBlock();
    }

    public void onBlockPlacedBy(World world, int x, int y, int z, EntityLivingBase player, ItemStack stack) {
        int id = -1;
        Block b = PainterUtil.getSourceBlock(stack);
        TileEntity te = world.getTileEntity(x, y, z);
        if (te instanceof TileEntityPaintedBlock) {
            TileEntityPaintedBlock tef = (TileEntityPaintedBlock)te;
            tef.setSourceBlock(b);
            tef.setSourceBlockMetadata(PainterUtil.getSourceBlockMetadata(stack));
        }
        world.markBlockForUpdate(x, y, z);
    }

    public void breakBlock(World world, int x, int y, int z, Block par5, int par6) {
        if (!world.isRemote && world.getGameRules().getGameRuleBooleanValue("doTileDrops")) {
            TileEntity te = world.getTileEntity(x, y, z);
            if (te instanceof TileEntityPaintedBlock) {
                TileEntityPaintedBlock tef = (TileEntityPaintedBlock)te;
                ItemStack itemStack = BlockPaintedWall.createItemStackForSourceBlock(tef.getSourceBlock(), tef.getSourceBlockMetadata());
                float f = 0.7f;
                double d0 = (double)(world.rand.nextFloat() * f) + (double)(1.0f - f) * 0.5;
                double d1 = (double)(world.rand.nextFloat() * f) + (double)(1.0f - f) * 0.5;
                double d2 = (double)(world.rand.nextFloat() * f) + (double)(1.0f - f) * 0.5;
                EntityItem entityitem = new EntityItem(world, (double)x + d0, (double)y + d1, (double)z + d2, itemStack);
                entityitem.delayBeforeCanPickup = 10;
                world.spawnEntityInWorld((Entity)entityitem);
            } else {
                System.out.println("dropBlockAsItem_do: No tile entity.");
            }
        }
        world.removeTileEntity(x, y, z);
    }

    public int quantityDropped(Random par1Random) {
        return 0;
    }

    @SideOnly(value=Side.CLIENT)
    public int colorMultiplier(IBlockAccess world, int x, int y, int z) {
        TileEntityPaintedBlock tef;
        TileEntity te = world.getTileEntity(x, y, z);
        if (te instanceof TileEntityPaintedBlock && (tef = (TileEntityPaintedBlock)te).getSourceBlock() != null) {
            return tef.getSourceBlock().colorMultiplier(world, x, y, z);
        }
        return super.colorMultiplier(world, x, y, z);
    }

    public final class PainterTemplate
    extends BasicPainterTemplate {
        public PainterTemplate() {
            super(new Block[]{Blocks.cobblestone_wall, BlockPaintedWall.this});
        }

        @Override
        public IMachineRecipe.ResultStack[] getCompletedResult(float chance, MachineRecipeInput ... inputs) {
            ItemStack paintSource = MachineRecipeInput.getInputForSlot(1, inputs);
            return new IMachineRecipe.ResultStack[]{new IMachineRecipe.ResultStack(BlockPaintedWall.createItemStackForSourceBlock(Block.getBlockFromItem((Item)paintSource.getItem()), paintSource.getItemDamage()))};
        }
    }
}

