/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.machine.painter;

import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import crazypants.enderio.EnderIO;
import crazypants.enderio.ModObject;
import crazypants.enderio.machine.IMachineRecipe;
import crazypants.enderio.machine.MachineRecipeInput;
import crazypants.enderio.machine.MachineRecipeRegistry;
import crazypants.enderio.machine.painter.BasicPainterTemplate;
import crazypants.enderio.machine.painter.BlockItemPaintedSlab;
import crazypants.enderio.machine.painter.IPaintedBlock;
import crazypants.enderio.machine.painter.PaintedBlockAccessWrapper;
import crazypants.enderio.machine.painter.PainterUtil;
import crazypants.enderio.machine.painter.TileEntityPaintedBlock;
import crazypants.enderio.machine.painter.TileEntityPaintedSlab;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockSlab;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.material.Material;
import net.minecraft.client.particle.EffectRenderer;
import net.minecraft.client.particle.EntityDiggingFX;
import net.minecraft.client.particle.EntityFX;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class BlockPaintedSlab
extends BlockSlab
implements ITileEntityProvider,
IPaintedBlock {
    private IIcon lastRemovedComponetIcon = null;
    private Random rand = new Random();
    private final boolean isDouble;

    public BlockPaintedSlab(boolean isDouble) {
        super(isDouble, Material.rock);
        this.isDouble = isDouble;
        this.setCreativeTab(null);
        this.setBlockName(ModObject.blockPaintedSlab.unlocalisedName + (isDouble ? "Double" : ""));
        this.setHardness(0.5f);
        this.setResistance(5.0f);
        if (!isDouble) {
            this.useNeighborBrightness = true;
        }
    }

    public void init() {
        if (this.isDouble) {
            GameRegistry.registerBlock((Block)this, BlockItemPaintedSlab.class, (String)ModObject.blockPaintedDoubleSlab.unlocalisedName);
            GameRegistry.registerTileEntity(TileEntityPaintedSlab.class, (String)(ModObject.blockPaintedDoubleSlab.unlocalisedName + "TileEntity"));
        } else {
            GameRegistry.registerBlock((Block)this, BlockItemPaintedSlab.class, (String)ModObject.blockPaintedSlab.unlocalisedName);
            GameRegistry.registerTileEntity(TileEntityPaintedBlock.class, (String)(ModObject.blockPaintedSlab.unlocalisedName + "TileEntity"));
            MachineRecipeRegistry.instance.registerRecipe(ModObject.blockPainter.unlocalisedName, new PainterTemplate());
        }
    }

    public static ItemStack createItemStackForSourceBlock(Block source, int damage) {
        ItemStack result = new ItemStack((Block)EnderIO.blockPaintedSlab, 1, 0);
        PainterUtil.setSourceBlock(result, source, damage);
        return result;
    }

    @SideOnly(value=Side.CLIENT)
    public void getSubBlocks(Item item, CreativeTabs tab, List list) {
        list.add(PainterUtil.applyDefaultPaintedState(new ItemStack(item)));
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon getIcon(IBlockAccess world, int x, int y, int z, int blockSide) {
        TileEntityPaintedBlock tef;
        TileEntity te = world.getTileEntity(x, y, z);
        if (te instanceof TileEntityPaintedBlock && (tef = (TileEntityPaintedBlock)te).getSourceBlock() != null) {
            return tef.getSourceBlock().getIcon(blockSide, tef.getSourceBlockMetadata());
        }
        return Blocks.anvil.getIcon(world, x, y, z, blockSide);
    }

    @SideOnly(value=Side.CLIENT)
    public void registerBlockIcons(IIconRegister IIconRegister2) {
        this.blockIcon = IIconRegister2.registerIcon("enderio:conduitConnector");
    }

    @SideOnly(value=Side.CLIENT)
    public boolean addHitEffects(World world, MovingObjectPosition target, EffectRenderer effectRenderer) {
        IIcon tex = null;
        TileEntityPaintedBlock cb = (TileEntityPaintedBlock)world.getTileEntity(target.blockX, target.blockY, target.blockZ);
        Block b = cb.getSourceBlock();
        if (b != null) {
            tex = b.getIcon(ForgeDirection.NORTH.ordinal(), cb.getSourceBlockMetadata());
        }
        if (tex == null) {
            tex = this.blockIcon;
        }
        this.lastRemovedComponetIcon = tex;
        this.addBlockHitEffects(world, effectRenderer, target.blockX, target.blockY, target.blockZ, target.sideHit, tex);
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean addDestroyEffects(World world, int x, int y, int z, int meta, EffectRenderer effectRenderer) {
        IIcon tex = this.lastRemovedComponetIcon;
        int b0 = 4;
        for (int j1 = 0; j1 < b0; ++j1) {
            for (int k1 = 0; k1 < b0; ++k1) {
                for (int l1 = 0; l1 < b0; ++l1) {
                    double d0 = (double)x + ((double)j1 + 0.5) / (double)b0;
                    double d1 = (double)y + ((double)k1 + 0.5) / (double)b0;
                    double d2 = (double)z + ((double)l1 + 0.5) / (double)b0;
                    int i2 = this.rand.nextInt(6);
                    EntityDiggingFX fx = new EntityDiggingFX(world, d0, d1, d2, d0 - (double)x - 0.5, d1 - (double)y - 0.5, d2 - (double)z - 0.5, (Block)this, i2, 0).applyColourMultiplier(x, y, z);
                    fx.setParticleIcon(tex);
                    effectRenderer.addEffect((EntityFX)fx);
                }
            }
        }
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    private void addBlockHitEffects(World world, EffectRenderer effectRenderer, int x, int y, int z, int side, IIcon tex) {
        float f = 0.1f;
        double d0 = (double)x + this.rand.nextDouble() * (this.getBlockBoundsMaxX() - this.getBlockBoundsMinX() - (double)(f * 2.0f)) + (double)f + this.getBlockBoundsMinX();
        double d1 = (double)y + this.rand.nextDouble() * (this.getBlockBoundsMaxY() - this.getBlockBoundsMinY() - (double)(f * 2.0f)) + (double)f + this.getBlockBoundsMinY();
        double d2 = (double)z + this.rand.nextDouble() * (this.getBlockBoundsMaxZ() - this.getBlockBoundsMinZ() - (double)(f * 2.0f)) + (double)f + this.getBlockBoundsMinZ();
        if (side == 0) {
            d1 = (double)y + this.getBlockBoundsMinY() - (double)f;
        } else if (side == 1) {
            d1 = (double)y + this.getBlockBoundsMaxY() + (double)f;
        } else if (side == 2) {
            d2 = (double)z + this.getBlockBoundsMinZ() - (double)f;
        } else if (side == 3) {
            d2 = (double)z + this.getBlockBoundsMaxZ() + (double)f;
        } else if (side == 4) {
            d0 = (double)x + this.getBlockBoundsMinX() - (double)f;
        } else if (side == 5) {
            d0 = (double)x + this.getBlockBoundsMaxX() + (double)f;
        }
        EntityDiggingFX digFX = new EntityDiggingFX(world, d0, d1, d2, 0.0, 0.0, 0.0, (Block)this, side, 0);
        digFX.applyColourMultiplier(x, y, z).multiplyVelocity(0.2f).multipleParticleScaleBy(0.6f);
        digFX.setParticleIcon(tex);
        effectRenderer.addEffect((EntityFX)digFX);
    }

    public TileEntity createNewTileEntity(World world, int metadata) {
        return new TileEntityPaintedSlab();
    }

    public int getLightOpacity(IBlockAccess world, int x, int y, int z) {
        TileEntityPaintedBlock tef;
        TileEntity te = world.getTileEntity(x, y, z);
        if (te instanceof TileEntityPaintedBlock && (tef = (TileEntityPaintedBlock)te).getSourceBlock() != null) {
            return Math.min(super.getLightOpacity(world, x, y, z), tef.getSourceBlock().getLightOpacity(world, x, y, z));
        }
        return super.getLightOpacity(world, x, y, z);
    }

    public void onBlockPlacedBy(World world, int x, int y, int z, EntityLivingBase player, ItemStack stack) {
        TileEntity te = world.getTileEntity(x, y, z);
        if (te instanceof TileEntityPaintedBlock) {
            TileEntityPaintedBlock tef = (TileEntityPaintedBlock)te;
            Block b = PainterUtil.getSourceBlock(stack);
            tef.setSourceBlock(b);
            tef.setSourceBlockMetadata(PainterUtil.getSourceBlockMetadata(stack));
        }
        world.markBlockForUpdate(x, y, z);
        super.onBlockPlacedBy(world, x, y, z, player, stack);
    }

    public boolean removedByPlayer(World world, EntityPlayer player, int x, int y, int z, boolean doHarvest) {
        TileEntity te;
        if (!world.isRemote && !player.capabilities.isCreativeMode && (te = world.getTileEntity(x, y, z)) instanceof TileEntityPaintedSlab && !((TileEntityPaintedSlab)te).isConvertingToFullBlock) {
            TileEntityPaintedBlock tef = (TileEntityPaintedBlock)te;
            for (int i = 0; i < super.quantityDropped(null); ++i) {
                ItemStack itemStack = BlockPaintedSlab.createItemStackForSourceBlock(tef.getSourceBlock(), tef.getSourceBlockMetadata());
                this.dropBlockAsItem(world, x, y, z, itemStack);
            }
        }
        return super.removedByPlayer(world, player, x, y, z, false);
    }

    public String func_150002_b(int var1) {
        return this.getUnlocalizedName();
    }

    public int quantityDropped(Random par1Random) {
        return 0;
    }

    @SideOnly(value=Side.CLIENT)
    public int colorMultiplier(IBlockAccess world, int x, int y, int z) {
        TileEntityPaintedBlock tef;
        TileEntity te = world.getTileEntity(x, y, z);
        if (te instanceof TileEntityPaintedBlock && (tef = (TileEntityPaintedBlock)te).getSourceBlock() != null) {
            PaintedBlockAccessWrapper ba = new PaintedBlockAccessWrapper(world);
            return tef.getSourceBlock().colorMultiplier((IBlockAccess)ba, x, y, z);
        }
        return super.colorMultiplier(world, x, y, z);
    }

    public final class PainterTemplate
    extends BasicPainterTemplate {
        public PainterTemplate() {
            super(new Block[]{Blocks.wooden_slab, Blocks.stone_slab, EnderIO.blockPaintedDoubleSlab, BlockPaintedSlab.this});
        }

        @Override
        public IMachineRecipe.ResultStack[] getCompletedResult(float chance, MachineRecipeInput ... inputs) {
            ItemStack paintSource = MachineRecipeInput.getInputForSlot(1, inputs);
            if (paintSource == null) {
                return new IMachineRecipe.ResultStack[0];
            }
            return new IMachineRecipe.ResultStack[]{new IMachineRecipe.ResultStack(BlockPaintedSlab.createItemStackForSourceBlock(Block.getBlockFromItem((Item)paintSource.getItem()), paintSource.getItemDamage()))};
        }

        @Override
        public boolean isValidTarget(ItemStack target) {
            if (target == null) {
                return false;
            }
            Block blk = Block.getBlockFromItem((Item)target.getItem());
            return blk instanceof BlockSlab;
        }
    }
}

