/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.machine.painter;

import com.enderio.core.common.TileEntityEnder;
import com.enderio.core.common.util.Util;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import crazypants.enderio.BlockEio;
import crazypants.enderio.EnderIO;
import crazypants.enderio.ModObject;
import crazypants.enderio.item.IRotatableFacade;
import crazypants.enderio.machine.IMachineRecipe;
import crazypants.enderio.machine.MachineRecipeInput;
import crazypants.enderio.machine.MachineRecipeRegistry;
import crazypants.enderio.machine.painter.BasicPainterTemplate;
import crazypants.enderio.machine.painter.BlockItemPaintedGlowstone;
import crazypants.enderio.machine.painter.IPaintableTileEntity;
import crazypants.enderio.machine.painter.IPaintedBlock;
import crazypants.enderio.machine.painter.PainterUtil;
import crazypants.enderio.machine.painter.TileEntityPaintedBlock;
import crazypants.util.IFacade;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.material.Material;
import net.minecraft.client.particle.EffectRenderer;
import net.minecraft.client.particle.EntityDiggingFX;
import net.minecraft.client.particle.EntityFX;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;

public class BlockPaintedGlowstone
extends BlockEio
implements ITileEntityProvider,
IPaintedBlock,
IFacade,
IRotatableFacade {
    public static int renderId = -1;
    private IIcon lastRemovedComponetIcon = null;
    private final Random rand = new Random();

    public static BlockPaintedGlowstone create() {
        BlockPaintedGlowstone result = new BlockPaintedGlowstone();
        result.init();
        return result;
    }

    protected BlockPaintedGlowstone() {
        super(ModObject.blockPaintedGlowstone.unlocalisedName, TileEntityPaintedBlock.class, Material.glass);
        this.setCreativeTab(null);
        this.setStepSound(soundTypeGlass);
        this.setHardness(0.7f);
        this.setLightLevel(1.0f);
    }

    protected void init() {
        GameRegistry.registerBlock((Block)this, BlockItemPaintedGlowstone.class, (String)ModObject.blockPaintedGlowstone.unlocalisedName);
        GameRegistry.registerTileEntity(TileEntityPaintedBlock.class, (String)(ModObject.blockPaintedGlowstone.unlocalisedName + "TileEntity"));
        MachineRecipeRegistry.instance.registerRecipe(ModObject.blockPainter.unlocalisedName, new PainterTemplate());
    }

    public static ItemStack createItemStackForSourceBlock(Block block, int damage) {
        ItemStack result = new ItemStack((Block)EnderIO.blockPaintedGlowstone, 1, damage);
        PainterUtil.setSourceBlock(result, block, damage);
        return result;
    }

    @SideOnly(value=Side.CLIENT)
    public void getSubBlocks(Item item, CreativeTabs tab, List list) {
        list.add(PainterUtil.applyDefaultPaintedState(new ItemStack(item)));
    }

    @SideOnly(value=Side.CLIENT)
    public int colorMultiplier(IBlockAccess world, int x, int y, int z) {
        TileEntityPaintedBlock tef;
        TileEntity te = world.getTileEntity(x, y, z);
        if (te instanceof TileEntityPaintedBlock && (tef = (TileEntityPaintedBlock)te).getSourceBlock() != null) {
            return tef.getSourceBlock().colorMultiplier(world, x, y, z);
        }
        return super.colorMultiplier(world, x, y, z);
    }

    @SideOnly(value=Side.CLIENT)
    public boolean addHitEffects(World world, MovingObjectPosition target, EffectRenderer effectRenderer) {
        IIcon tex = null;
        TileEntityPaintedBlock cb = (TileEntityPaintedBlock)world.getTileEntity(target.blockX, target.blockY, target.blockZ);
        Block b = cb.getSourceBlock();
        if (b != null) {
            tex = b.getIcon(ForgeDirection.NORTH.ordinal(), cb.getSourceBlockMetadata());
        }
        if (tex == null) {
            tex = this.blockIcon;
        }
        this.lastRemovedComponetIcon = tex;
        this.addBlockHitEffects(world, effectRenderer, target.blockX, target.blockY, target.blockZ, target.sideHit, tex);
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean addDestroyEffects(World world, int x, int y, int z, int meta, EffectRenderer effectRenderer) {
        IIcon tex = this.lastRemovedComponetIcon;
        int b0 = 4;
        for (int j1 = 0; j1 < b0; ++j1) {
            for (int k1 = 0; k1 < b0; ++k1) {
                for (int l1 = 0; l1 < b0; ++l1) {
                    double d0 = (double)x + ((double)j1 + 0.5) / (double)b0;
                    double d1 = (double)y + ((double)k1 + 0.5) / (double)b0;
                    double d2 = (double)z + ((double)l1 + 0.5) / (double)b0;
                    int i2 = this.rand.nextInt(6);
                    EntityDiggingFX fx = new EntityDiggingFX(world, d0, d1, d2, d0 - (double)x - 0.5, d1 - (double)y - 0.5, d2 - (double)z - 0.5, (Block)this, i2, 0).applyColourMultiplier(x, y, z);
                    fx.setParticleIcon(tex);
                    effectRenderer.addEffect((EntityFX)fx);
                }
            }
        }
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    private void addBlockHitEffects(World world, EffectRenderer effectRenderer, int x, int y, int z, int side, IIcon tex) {
        float f = 0.1f;
        double d0 = (double)x + this.rand.nextDouble() * (this.getBlockBoundsMaxX() - this.getBlockBoundsMinX() - (double)(f * 2.0f)) + (double)f + this.getBlockBoundsMinX();
        double d1 = (double)y + this.rand.nextDouble() * (this.getBlockBoundsMaxY() - this.getBlockBoundsMinY() - (double)(f * 2.0f)) + (double)f + this.getBlockBoundsMinY();
        double d2 = (double)z + this.rand.nextDouble() * (this.getBlockBoundsMaxZ() - this.getBlockBoundsMinZ() - (double)(f * 2.0f)) + (double)f + this.getBlockBoundsMinZ();
        if (side == 0) {
            d1 = (double)y + this.getBlockBoundsMinY() - (double)f;
        } else if (side == 1) {
            d1 = (double)y + this.getBlockBoundsMaxY() + (double)f;
        } else if (side == 2) {
            d2 = (double)z + this.getBlockBoundsMinZ() - (double)f;
        } else if (side == 3) {
            d2 = (double)z + this.getBlockBoundsMaxZ() + (double)f;
        } else if (side == 4) {
            d0 = (double)x + this.getBlockBoundsMinX() - (double)f;
        } else if (side == 5) {
            d0 = (double)x + this.getBlockBoundsMaxX() + (double)f;
        }
        EntityDiggingFX digFX = new EntityDiggingFX(world, d0, d1, d2, 0.0, 0.0, 0.0, (Block)this, side, 0);
        digFX.applyColourMultiplier(x, y, z).multiplyVelocity(0.2f).multipleParticleScaleBy(0.6f);
        digFX.setParticleIcon(tex);
        effectRenderer.addEffect((EntityFX)digFX);
    }

    public boolean isSideSolid(IBlockAccess world, int x, int y, int z, ForgeDirection side) {
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon getIcon(IBlockAccess world, int x, int y, int z, int blockSide) {
        TileEntityPaintedBlock tef;
        TileEntity te = world.getTileEntity(x, y, z);
        if (te instanceof TileEntityPaintedBlock && (tef = (TileEntityPaintedBlock)te).getSourceBlock() != null) {
            return tef.getSourceBlock().getIcon(blockSide, tef.getSourceBlockMetadata());
        }
        return Blocks.anvil.getIcon(world, x, y, z, blockSide);
    }

    @SideOnly(value=Side.CLIENT)
    public void registerBlockIcons(IIconRegister IIconRegister2) {
        this.blockIcon = IIconRegister2.registerIcon("enderio:conduitConnector");
    }

    public TileEntity createNewTileEntity(World world, int metadata) {
        return new TileEntityPaintedBlock();
    }

    @Override
    public boolean tryRotateFacade(World world, int x, int y, int z, ForgeDirection axis) {
        int newMeta;
        TileEntityPaintedBlock tef;
        int oldMeta;
        TileEntity te = world.getTileEntity(x, y, z);
        if (te instanceof TileEntityPaintedBlock && (oldMeta = (tef = (TileEntityPaintedBlock)te).getSourceBlockMetadata()) != (newMeta = PainterUtil.rotateFacadeMetadata(tef.getSourceBlock(), oldMeta, axis))) {
            tef.setSourceBlockMetadata(newMeta);
            world.markBlockForUpdate(x, y, z);
            tef.markDirty();
            return true;
        }
        return false;
    }

    public int damageDropped(int meta) {
        return meta;
    }

    protected void processDrop(World world, int x, int y, int z, TileEntityEnder te, ItemStack drop) {
        TileEntityPaintedBlock tef = (TileEntityPaintedBlock)te;
        if (tef != null) {
            ItemStack itemStack = BlockPaintedGlowstone.createItemStackForSourceBlock(tef.getSourceBlock(), tef.getSourceBlockMetadata());
            drop.stackTagCompound = (NBTTagCompound)itemStack.stackTagCompound.copy();
        }
    }

    public boolean doNormalDrops(World world, int x, int y, int z) {
        return false;
    }

    public int getRenderType() {
        return renderId;
    }

    @Override
    public int getFacadeMetadata(IBlockAccess world, int x, int y, int z, int side) {
        TileEntity te = world.getTileEntity(x, y, z);
        if (te instanceof TileEntityPaintedBlock) {
            TileEntityPaintedBlock tef = (TileEntityPaintedBlock)te;
            return tef.getBlockMetadata();
        }
        return 0;
    }

    @Override
    public Block getFacade(IBlockAccess world, int x, int y, int z, int side) {
        Block sourceBlock;
        TileEntity te = world.getTileEntity(x, y, z);
        if (te instanceof IPaintableTileEntity && (sourceBlock = ((IPaintableTileEntity)te).getSourceBlock()) != null) {
            return sourceBlock;
        }
        return this;
    }

    @Override
    public Block getVisualBlock(IBlockAccess world, int x, int y, int z, ForgeDirection side) {
        return this.getFacade(world, x, y, z, side.ordinal());
    }

    @Override
    public int getVisualMeta(IBlockAccess world, int x, int y, int z, ForgeDirection side) {
        return this.getFacadeMetadata(world, x, y, z, side.ordinal());
    }

    @Override
    public boolean supportsVisualConnections() {
        return true;
    }

    public final class PainterTemplate
    extends BasicPainterTemplate {
        public PainterTemplate() {
            super(new Block[]{Blocks.glowstone, BlockPaintedGlowstone.this});
            MinecraftForge.EVENT_BUS.register((Object)this);
        }

        @Override
        public boolean isValidPaintSource(ItemStack paintSource) {
            return super.isValidPaintSource(paintSource) && Util.getBlockFromItemId((ItemStack)paintSource).isOpaqueCube();
        }

        @Override
        public IMachineRecipe.ResultStack[] getCompletedResult(float chance, MachineRecipeInput ... inputs) {
            ItemStack paintSource = MachineRecipeInput.getInputForSlot(1, inputs);
            if (paintSource == null) {
                return new IMachineRecipe.ResultStack[0];
            }
            if (paintSource.getItem() == Item.getItemFromBlock((Block)Blocks.glowstone)) {
                ItemStack stack = new ItemStack(Blocks.glowstone);
                stack.stackTagCompound = new NBTTagCompound();
                String tagName = "wasPainted";
                stack.stackTagCompound.setBoolean(tagName, true);
                return new IMachineRecipe.ResultStack[]{new IMachineRecipe.ResultStack(stack)};
            }
            return new IMachineRecipe.ResultStack[]{new IMachineRecipe.ResultStack(BlockPaintedGlowstone.createItemStackForSourceBlock(Block.getBlockFromItem((Item)paintSource.getItem()), paintSource.getItemDamage()))};
        }

        @SubscribeEvent
        public void onTooltip(ItemTooltipEvent event) {
            if (event.itemStack != null && Block.getBlockFromItem((Item)event.itemStack.getItem()) == Blocks.glowstone && event.itemStack.stackTagCompound != null && event.itemStack.stackTagCompound.getBoolean("wasPainted")) {
                event.toolTip.add(EnderIO.lang.localize("painter.tooltip.wasPainted"));
            }
        }
    }
}

