/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.machine.painter;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import crazypants.enderio.EnderIO;
import crazypants.enderio.ModObject;
import crazypants.enderio.machine.painter.PainterUtil;
import crazypants.enderio.machine.painter.TileEntityPaintedBlock;
import crazypants.enderio.machine.painter.TileEntityPaintedSlab;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockSlab;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemSlab;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;

public class BlockItemPaintedSlab
extends ItemSlab {
    private boolean isFullBlock;

    public BlockItemPaintedSlab(Block blk) {
        super(blk, (BlockSlab)EnderIO.blockPaintedSlab, (BlockSlab)EnderIO.blockPaintedDoubleSlab, blk == EnderIO.blockPaintedDoubleSlab);
        this.setHasSubtypes(true);
        this.isFullBlock = blk == EnderIO.blockPaintedDoubleSlab;
        this.setUnlocalizedName(ModObject.blockPaintedSlab.unlocalisedName);
    }

    public int getMetadata(int par1) {
        return par1;
    }

    @SideOnly(value=Side.CLIENT)
    public void addInformation(ItemStack item, EntityPlayer par2EntityPlayer, List list, boolean par4) {
        super.addInformation(item, par2EntityPlayer, list, par4);
        list.add(PainterUtil.getTooltTipText(item));
    }

    public boolean onItemUse(ItemStack par1ItemStack, EntityPlayer player, World world, int x, int y, int z, int side, float par8, float par9, float par10) {
        boolean flag;
        if (this.isFullBlock) {
            return super.onItemUse(par1ItemStack, player, world, x, y, z, side, par8, par9, par10);
        }
        if (par1ItemStack.stackSize == 0) {
            return false;
        }
        if (!player.canPlayerEdit(x, y, z, side, par1ItemStack)) {
            return false;
        }
        Block i1 = world.getBlock(x, y, z);
        int j1 = world.getBlockMetadata(x, y, z);
        int k1 = j1 & 7;
        boolean bl = flag = (j1 & 8) != 0;
        if ((side == 1 && !flag || side == 0 && flag) && i1 == EnderIO.blockPaintedSlab && k1 == par1ItemStack.getItemDamage()) {
            if (world.checkNoEntityCollision(EnderIO.blockPaintedDoubleSlab.getCollisionBoundingBoxFromPool(world, x, y, z))) {
                TileEntity te = world.getTileEntity(x, y, z);
                if (te instanceof TileEntityPaintedSlab) {
                    ((TileEntityPaintedSlab)te).isConvertingToFullBlock = true;
                }
                if (world.setBlock(x, y, z, (Block)EnderIO.blockPaintedDoubleSlab, k1, 3)) {
                    te = world.getTileEntity(x, y, z);
                    if (te instanceof TileEntityPaintedBlock) {
                        Block b = PainterUtil.getSourceBlock(par1ItemStack);
                        TileEntityPaintedBlock tef = (TileEntityPaintedBlock)te;
                        tef.setSourceBlock(b);
                        tef.setSourceBlockMetadata(PainterUtil.getSourceBlockMetadata(par1ItemStack));
                        world.markBlockForUpdate(x, y, z);
                    }
                    world.playSoundEffect((double)((float)x + 0.5f), (double)((float)y + 0.5f), (double)((float)z + 0.5f), EnderIO.blockPaintedDoubleSlab.stepSound.getStepResourcePath(), (EnderIO.blockPaintedDoubleSlab.stepSound.getVolume() + 1.0f) / 2.0f, EnderIO.blockPaintedDoubleSlab.stepSound.getPitch() * 0.8f);
                    --par1ItemStack.stackSize;
                } else if (te instanceof TileEntityPaintedSlab) {
                    ((TileEntityPaintedSlab)te).isConvertingToFullBlock = false;
                }
            }
            return true;
        }
        if (this.mergeWithTopSlab(par1ItemStack, player, world, x, y, z, side)) {
            return true;
        }
        return super.onItemUse(par1ItemStack, player, world, x, y, z, side, par8, par9, par10);
    }

    private boolean mergeWithTopSlab(ItemStack par1ItemStack, EntityPlayer par2EntityPlayer, World world, int x, int y, int z, int side) {
        if (side == 0) {
            --y;
        } else if (side == 1) {
            ++y;
        } else if (side == 2) {
            --z;
        } else if (side == 3) {
            ++z;
        } else if (side == 4) {
            --x;
        } else if (side == 5) {
            ++x;
        }
        Block i1 = world.getBlock(x, y, z);
        int j1 = world.getBlockMetadata(x, y, z);
        int k1 = j1 & 7;
        if (i1 == EnderIO.blockPaintedSlab && k1 == par1ItemStack.getItemDamage()) {
            TileEntity te = world.getTileEntity(x, y, z);
            if (te instanceof TileEntityPaintedSlab) {
                ((TileEntityPaintedSlab)te).isConvertingToFullBlock = true;
            }
            if (world.checkNoEntityCollision(EnderIO.blockPaintedDoubleSlab.getCollisionBoundingBoxFromPool(world, x, y, z)) && world.setBlock(x, y, z, (Block)EnderIO.blockPaintedDoubleSlab, k1, 3)) {
                te = world.getTileEntity(x, y, z);
                if (te instanceof TileEntityPaintedBlock) {
                    Block b = PainterUtil.getSourceBlock(par1ItemStack);
                    TileEntityPaintedBlock tef = (TileEntityPaintedBlock)te;
                    tef.setSourceBlock(b);
                    tef.setSourceBlockMetadata(PainterUtil.getSourceBlockMetadata(par1ItemStack));
                    world.markBlockForUpdate(x, y, z);
                }
                world.playSoundEffect((double)((float)x + 0.5f), (double)((float)y + 0.5f), (double)((float)z + 0.5f), EnderIO.blockPaintedDoubleSlab.stepSound.getStepResourcePath(), (EnderIO.blockPaintedDoubleSlab.stepSound.getVolume() + 1.0f) / 2.0f, EnderIO.blockPaintedDoubleSlab.stepSound.getPitch() * 0.8f);
                --par1ItemStack.stackSize;
            } else if (te instanceof TileEntityPaintedSlab) {
                ((TileEntityPaintedSlab)te).isConvertingToFullBlock = false;
            }
            return true;
        }
        return false;
    }
}

