/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.machine.obelisk.xp;

import com.enderio.core.api.client.gui.IResourceTooltipProvider;
import com.enderio.core.common.util.Util;
import com.enderio.core.common.vecmath.Vector3d;
import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import crazypants.enderio.EnderIO;
import crazypants.enderio.EnderIOTab;
import crazypants.enderio.ModObject;
import crazypants.enderio.machine.obelisk.xp.PacketXpTransferEffects;
import crazypants.enderio.network.PacketHandler;
import crazypants.enderio.xp.XpUtil;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidHandler;

public class ItemXpTransfer
extends Item
implements IResourceTooltipProvider {
    public static ItemXpTransfer create() {
        PacketHandler.INSTANCE.registerMessage(PacketXpTransferEffects.class, PacketXpTransferEffects.class, PacketHandler.nextID(), Side.CLIENT);
        ItemXpTransfer result = new ItemXpTransfer();
        result.init();
        return result;
    }

    protected ItemXpTransfer() {
        this.setCreativeTab(EnderIOTab.tabEnderIO);
        this.setUnlocalizedName(ModObject.itemXpTransfer.unlocalisedName);
        this.setMaxStackSize(1);
        this.setHasSubtypes(true);
    }

    public boolean onItemUseFirst(ItemStack stack, EntityPlayer player, World world, int x, int y, int z, int side, float hitX, float hitY, float hitZ) {
        return ItemXpTransfer.onActivated(player, world, x, y, z, side);
    }

    public static boolean onActivated(EntityPlayer player, World world, int x, int y, int z, int side) {
        boolean res;
        if (world.isRemote) {
            return false;
        }
        boolean swing = false;
        if (player.isSneaking()) {
            swing = res = ItemXpTransfer.tranferFromPlayerToBlock(player, world, x, y, z, side);
        } else {
            res = ItemXpTransfer.tranferFromBlockToPlayer(player, world, x, y, z, side);
        }
        if (res) {
            ItemXpTransfer.sendXPUpdate(player, world, x, y, z, swing);
        }
        return res;
    }

    public static void sendXPUpdate(EntityPlayer player, World world, int x, int y, int z, boolean swing) {
        Vector3d look = Util.getLookVecEio((EntityPlayer)player);
        double xP = player.posX + look.x;
        double yP = player.posY + 1.5;
        double zP = player.posZ + look.z;
        NetworkRegistry.TargetPoint tp = new NetworkRegistry.TargetPoint(player.dimension, (double)x, (double)y, (double)z, 32.0);
        PacketHandler.INSTANCE.sendTo((IMessage)new PacketXpTransferEffects(swing, xP, yP, zP), (EntityPlayerMP)player);
        world.playSoundEffect((double)x + 0.5, (double)y + 0.5, (double)z + 0.5, "random.orb", 0.1f, 0.5f * ((world.rand.nextFloat() - world.rand.nextFloat()) * 0.7f + 1.8f));
    }

    public static boolean tranferFromBlockToPlayer(EntityPlayer player, World world, int x, int y, int z, int side) {
        TileEntity te = world.getTileEntity(x, y, z);
        if (!(te instanceof IFluidHandler)) {
            return false;
        }
        IFluidHandler fh = (IFluidHandler)te;
        ForgeDirection dir = ForgeDirection.getOrientation((int)side);
        if (!fh.canDrain(dir, EnderIO.fluidXpJuice)) {
            return false;
        }
        int currentXP = XpUtil.getPlayerXP(player);
        int nextLevelXP = XpUtil.getExperienceForLevel(player.experienceLevel + 1) + 1;
        int requiredXP = nextLevelXP - currentXP;
        int fluidVolume = XpUtil.experienceToLiquid(requiredXP);
        FluidStack fs = new FluidStack(EnderIO.fluidXpJuice, fluidVolume);
        FluidStack res = fh.drain(dir, fs, true);
        if (res == null || res.amount <= 0) {
            return false;
        }
        int xpToGive = XpUtil.liquidToExperience(res.amount);
        player.addExperience(xpToGive);
        return true;
    }

    public static boolean tranferFromPlayerToBlock(EntityPlayer player, World world, int x, int y, int z, int side) {
        if (player.experienceTotal <= 0) {
            return false;
        }
        TileEntity te = world.getTileEntity(x, y, z);
        if (!(te instanceof IFluidHandler)) {
            return false;
        }
        IFluidHandler fh = (IFluidHandler)te;
        ForgeDirection dir = ForgeDirection.getOrientation((int)side);
        if (!fh.canFill(dir, EnderIO.fluidXpJuice)) {
            return false;
        }
        int fluidVolume = XpUtil.experienceToLiquid(XpUtil.getPlayerXP(player));
        FluidStack fs = new FluidStack(EnderIO.fluidXpJuice, fluidVolume);
        int takenVolume = fh.fill(dir, fs, true);
        if (takenVolume <= 0) {
            return false;
        }
        int xpToTake = XpUtil.liquidToExperience(takenVolume);
        XpUtil.addPlayerXP(player, -xpToTake);
        return true;
    }

    protected void init() {
        GameRegistry.registerItem((Item)this, (String)ModObject.itemXpTransfer.unlocalisedName);
    }

    @SideOnly(value=Side.CLIENT)
    public void registerIcons(IIconRegister IIconRegister2) {
        this.itemIcon = IIconRegister2.registerIcon("enderio:xpTransfer");
    }

    public String getUnlocalizedNameForTooltip(ItemStack stack) {
        return this.getUnlocalizedName();
    }

    public boolean doesSneakBypassUse(World world, int x, int y, int z, EntityPlayer player) {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean isFull3D() {
        return true;
    }
}

