/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.machine.obelisk.weather;

import com.enderio.core.api.common.util.IProgressTile;
import com.enderio.core.api.common.util.ITankAccess;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import crazypants.enderio.EnderIO;
import crazypants.enderio.ModObject;
import crazypants.enderio.machine.AbstractPowerConsumerEntity;
import crazypants.enderio.machine.SlotDefinition;
import crazypants.enderio.machine.obelisk.weather.EntityFluidLoadingFX;
import crazypants.enderio.machine.obelisk.weather.EntityWeatherRocket;
import crazypants.enderio.machine.obelisk.weather.PacketActivateWeather;
import crazypants.enderio.machine.obelisk.weather.PacketWeatherTank;
import crazypants.enderio.network.PacketHandler;
import crazypants.enderio.power.Capacitors;
import crazypants.enderio.power.ICapacitor;
import java.awt.Color;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.EntityFX;
import net.minecraft.entity.Entity;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidHandler;

public class TileWeatherObelisk
extends AbstractPowerConsumerEntity
implements IProgressTile,
IFluidHandler,
ITankAccess {
    private int fluidUsed = 0;
    private WeatherTask activeTask = null;
    private boolean canBeActive = true;
    private boolean tanksDirty;
    private static final ICapacitor cap = Capacitors.BASIC_CAPACITOR.capacitor;
    private FluidTank inputTank = new FluidTank(8000);
    private float progress = 0.0f;
    private boolean playedFuse = false;

    public TileWeatherObelisk() {
        super(new SlotDefinition(1, 0, 0));
    }

    @Override
    public void init() {
        this.setCapacitor(Capacitors.ACTIVATED_CAPACITOR);
    }

    @Override
    public String getMachineName() {
        return ModObject.blockWeatherObelisk.unlocalisedName;
    }

    @Override
    protected boolean isMachineItemValidForSlot(int i, ItemStack itemstack) {
        return i == 0 && itemstack != null && itemstack.getItem() == Items.fireworks;
    }

    @Override
    public boolean isActive() {
        return this.canBeActive && this.getActiveTask() != null;
    }

    public float getProgress() {
        return this.isActive() ? (this.worldObj.isRemote ? this.progress : (float)this.fluidUsed / 1000.0f) : 0.0f;
    }

    public void setProgress(float progress) {
        this.progress = progress;
    }

    protected int getProgressUpdateFreq() {
        return 3;
    }

    public TileEntity getTileEntity() {
        return this;
    }

    @Override
    public ICapacitor getCapacitor() {
        return cap;
    }

    public WeatherTask getActiveTask() {
        return this.activeTask;
    }

    @Override
    public void doUpdate() {
        super.doUpdate();
        if (this.worldObj.isRemote && this.isActive() && this.worldObj.getTotalWorldTime() % 2L == 0L) {
            this.doLoadingParticles();
        }
    }

    @SideOnly(value=Side.CLIENT)
    private void doLoadingParticles() {
        if (this.progress < 0.9f) {
            Color c = this.getActiveTask().color;
            double correction = 0.1;
            double xf = (double)this.xCoord + 0.5 + correction;
            double yf = (double)this.yCoord + 0.8;
            double zf = (double)this.zCoord + 0.5 + correction;
            Block b = this.getBlockType();
            double yi = (double)this.yCoord + b.getBlockBoundsMaxY() - 0.1;
            double offset = 0.3;
            Minecraft.getMinecraft().effectRenderer.addEffect((EntityFX)new EntityFluidLoadingFX(this.worldObj, (double)this.xCoord + offset + correction, yi, (double)this.zCoord + offset + correction, xf, yf, zf, c));
            Minecraft.getMinecraft().effectRenderer.addEffect((EntityFX)new EntityFluidLoadingFX(this.worldObj, (double)this.xCoord + (1.0 - offset) + correction, yi, (double)this.zCoord + offset + correction, xf, yf, zf, c));
            Minecraft.getMinecraft().effectRenderer.addEffect((EntityFX)new EntityFluidLoadingFX(this.worldObj, (double)this.xCoord + (1.0 - offset) + correction, yi, (double)this.zCoord + (1.0 - offset) + correction, xf, yf, zf, c));
            Minecraft.getMinecraft().effectRenderer.addEffect((EntityFX)new EntityFluidLoadingFX(this.worldObj, (double)this.xCoord + offset + correction, yi, (double)this.zCoord + (1.0 - offset) + correction, xf, yf, zf, c));
        } else if (!this.playedFuse) {
            this.worldObj.playSound((double)this.xCoord, (double)this.yCoord, (double)this.zCoord, "game.tnt.primed", 1.0f, 1.0f, true);
            this.playedFuse = true;
        }
    }

    @Override
    protected boolean processTasks(boolean redstoneCheckPassed) {
        boolean res = false;
        if (!redstoneCheckPassed) {
            if (this.canBeActive) {
                this.canBeActive = false;
                res = true;
            }
            return res;
        }
        this.canBeActive = true;
        if (this.isActive()) {
            if (this.getEnergyStored() > this.getPowerUsePerTick() && this.inputTank.getFluidAmount() > 3) {
                this.setEnergyStored(this.getEnergyStored() - this.getPowerUsePerTick());
                int toUse = 4;
                this.inputTank.drain(toUse, true);
                this.fluidUsed += toUse;
                this.tanksDirty = true;
                res = true;
            }
            if (this.fluidUsed >= 1000) {
                EntityWeatherRocket e = new EntityWeatherRocket(this.worldObj, this.activeTask);
                e.setPosition((double)this.xCoord + 0.5, (double)this.yCoord + 0.5, (double)this.zCoord + 0.5);
                this.worldObj.spawnEntityInWorld((Entity)e);
                this.stopTask();
                res = true;
            }
        }
        if (this.tanksDirty) {
            PacketHandler.sendToAllAround((IMessage)new PacketWeatherTank(this), (TileEntity)this);
            this.tanksDirty = false;
        }
        return res;
    }

    public boolean canStartTask(WeatherTask task) {
        return this.getActiveTask() == null && !WeatherTask.worldIsState(task, this.worldObj) && this.getStackInSlot(0) != null && this.inputTank.getFluidAmount() >= 1000;
    }

    public boolean startTask() {
        if (this.getActiveTask() == null && this.inputTank.getFluidAmount() > 0) {
            this.fluidUsed = 0;
            WeatherTask task = WeatherTask.fromFluid(this.inputTank.getFluid().getFluid());
            if (this.canStartTask(task)) {
                this.decrStackSize(0, 1);
                this.activeTask = task;
                return true;
            }
        }
        return false;
    }

    public void stopTask() {
        if (this.getActiveTask() != null) {
            this.activeTask = null;
            this.fluidUsed = 0;
            if (!this.worldObj.isRemote) {
                PacketHandler.INSTANCE.sendToDimension((IMessage)new PacketActivateWeather(this), this.worldObj.provider.dimensionId);
            } else {
                this.playedFuse = false;
            }
        }
    }

    @Override
    public void writeCommon(NBTTagCompound nbtRoot) {
        super.writeCommon(nbtRoot);
        nbtRoot.setTag("tank", (NBTBase)this.inputTank.writeToNBT(new NBTTagCompound()));
    }

    @Override
    public void readCommon(NBTTagCompound nbtRoot) {
        super.readCommon(nbtRoot);
        this.inputTank.readFromNBT(nbtRoot.getCompoundTag("tank"));
    }

    private boolean isValidFluid(Fluid f) {
        return f == EnderIO.fluidLiquidSunshine || f == EnderIO.fluidCloudSeed || f == EnderIO.fluidCloudSeedConcentrated;
    }

    public FluidTank getInputTank(FluidStack forFluidType) {
        return forFluidType != null && forFluidType.getFluid() != null && this.isValidFluid(forFluidType.getFluid()) ? this.inputTank : null;
    }

    FluidTank getInputTank() {
        return this.inputTank;
    }

    public FluidTank[] getOutputTanks() {
        return new FluidTank[0];
    }

    public void setTanksDirty() {
        this.tanksDirty = true;
    }

    public int fill(ForgeDirection from, FluidStack resource, boolean doFill) {
        if (resource != null && this.canFill(from, resource.getFluid())) {
            int res = this.inputTank.fill(resource, doFill);
            if (res > 0 && doFill) {
                this.tanksDirty = true;
            }
            return res;
        }
        return 0;
    }

    public FluidStack drain(ForgeDirection from, FluidStack resource, boolean doDrain) {
        return null;
    }

    public FluidStack drain(ForgeDirection from, int maxDrain, boolean doDrain) {
        return null;
    }

    public boolean canFill(ForgeDirection from, Fluid fluid) {
        return this.isValidFluid(fluid);
    }

    public boolean canDrain(ForgeDirection from, Fluid fluid) {
        return false;
    }

    public FluidTankInfo[] getTankInfo(ForgeDirection from) {
        return new FluidTankInfo[]{this.inputTank.getInfo()};
    }

    public static enum WeatherTask {
        CLEAR(Color.YELLOW){

            @Override
            void complete(World world) {
                this.rain(world, false);
                this.thunder(world, false);
            }
        }
        ,
        RAIN(new Color(120, 120, 255)){

            @Override
            void complete(World world) {
                this.rain(world, true);
                this.thunder(world, false);
            }
        }
        ,
        STORM(Color.DARK_GRAY){

            @Override
            void complete(World world) {
                this.rain(world, true);
                this.thunder(world, true);
            }
        };

        final Color color;

        private WeatherTask(Color color) {
            this.color = color;
        }

        abstract void complete(World var1);

        protected void rain(World world, boolean state) {
            world.getWorldInfo().setRaining(state);
        }

        protected void thunder(World world, boolean state) {
            world.getWorldInfo().setThundering(state);
        }

        public static boolean worldIsState(WeatherTask task, World world) {
            if (world.isRaining()) {
                return world.isThundering() ? task == STORM : task == RAIN;
            }
            return task == CLEAR;
        }

        public static WeatherTask fromFluid(Fluid f) {
            if (f == EnderIO.fluidLiquidSunshine) {
                return CLEAR;
            }
            if (f == EnderIO.fluidCloudSeed) {
                return RAIN;
            }
            if (f == EnderIO.fluidCloudSeedConcentrated) {
                return STORM;
            }
            return null;
        }
    }
}

