/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.machine.obelisk.weather;

import com.enderio.core.api.client.gui.IGuiScreen;
import com.enderio.core.api.client.render.IWidgetIcon;
import com.enderio.core.client.gui.button.IconButton;
import com.enderio.core.client.gui.widget.GuiToolTip;
import com.enderio.core.client.render.RenderUtil;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import crazypants.enderio.EnderIO;
import crazypants.enderio.fluid.Fluids;
import crazypants.enderio.gui.IconEIO;
import crazypants.enderio.machine.gui.GuiPoweredMachineBase;
import crazypants.enderio.machine.obelisk.weather.ContainerWeatherObelisk;
import crazypants.enderio.machine.obelisk.weather.PacketActivateWeather;
import crazypants.enderio.machine.obelisk.weather.TileWeatherObelisk;
import crazypants.enderio.network.PacketHandler;
import java.awt.Color;
import java.awt.Rectangle;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.IFluidTank;
import org.lwjgl.opengl.GL11;

public class GuiWeatherObelisk
extends GuiPoweredMachineBase<TileWeatherObelisk> {
    private IconButton buttonStart;

    public GuiWeatherObelisk(InventoryPlayer inventory, TileWeatherObelisk tileEntity) {
        super(tileEntity, (Container)new ContainerWeatherObelisk(inventory, tileEntity), "weatherObelisk");
        this.addProgressTooltip(79, 29, 18, 31);
        this.addToolTip(new GuiToolTip(new Rectangle(22, 11, 16, 63), new String[]{""}){

            protected void updateText() {
                this.text.clear();
                FluidTank tank = ((TileWeatherObelisk)GuiWeatherObelisk.this.getTileEntity()).getInputTank();
                String heading = EnderIO.lang.localize("tank.tank");
                if (tank.getFluid() != null) {
                    heading = heading + ": " + tank.getFluid().getLocalizedName();
                }
                this.text.add(heading);
                this.text.add(Fluids.toCapactityString((IFluidTank)((TileWeatherObelisk)GuiWeatherObelisk.this.getTileEntity()).getInputTank()));
            }
        });
    }

    @Override
    public void initGui() {
        super.initGui();
        int x = this.xSize / 2 - 8;
        int y = 58;
        this.buttonStart = new IconButton((IGuiScreen)this, 0, x, y, (IWidgetIcon)IconEIO.TICK);
        this.addButton((GuiButton)this.buttonStart);
        this.buttonStart.onGuiInit();
        this.refreshButtons();
    }

    public void updateScreen() {
        super.updateScreen();
        if (((TileWeatherObelisk)this.getTileEntity()).getWorldObj().getTotalWorldTime() % 20L == 0L) {
            this.refreshButtons();
        }
    }

    private void refreshButtons() {
        FluidStack fs = ((TileWeatherObelisk)this.getTileEntity()).getInputTank().getFluid();
        if (fs == null) {
            this.buttonStart.enabled = false;
            return;
        }
        TileWeatherObelisk.WeatherTask task = TileWeatherObelisk.WeatherTask.fromFluid(fs.getFluid());
        this.buttonStart.enabled = ((TileWeatherObelisk)this.getTileEntity()).canStartTask(task);
    }

    @Override
    protected boolean showRecipeButton() {
        return false;
    }

    @Override
    protected void drawGuiContainerBackgroundLayer(float par1, int par2, int par3) {
        this.bindGuiTexture();
        this.drawTexturedModalRect(this.getGuiLeft(), this.getGuiTop(), 0, 0, this.getXSize(), this.getYSize());
        int x = this.getGuiLeft() + 22;
        int y = this.getGuiTop() + 11;
        RenderUtil.renderGuiTank((FluidTank)((TileWeatherObelisk)this.getTileEntity()).getInputTank(), (double)x, (double)y, (double)0.0, (double)16.0, (double)63.0);
        this.bindGuiTexture();
        this.drawTexturedModalRect(x, y, 186, 33, 16, 63);
        if (this.shouldRenderProgress() && ((TileWeatherObelisk)this.getTileEntity()).getActiveTask() != null) {
            int barHeight = this.getProgressScaled(31);
            Color color = ((TileWeatherObelisk)this.getTileEntity()).getActiveTask().color;
            GL11.glColor3f((float)((float)color.getRed() / 255.0f), (float)((float)color.getGreen() / 255.0f), (float)((float)color.getBlue() / 255.0f));
            this.drawTexturedModalRect(this.getGuiLeft() + 81, this.getGuiTop() + 58 - barHeight, this.getXSize(), 32 - barHeight, 12, barHeight);
        }
        super.drawGuiContainerBackgroundLayer(par1, par2, par3);
    }

    @Override
    protected int getPowerHeight() {
        return 63;
    }

    @Override
    protected int getPowerU() {
        return super.getPowerU();
    }

    @Override
    protected int getPowerV() {
        return 33;
    }

    @Override
    protected int getPowerX() {
        return super.getPowerX() - 7;
    }

    @Override
    protected int getPowerY() {
        return super.getPowerY() - 3;
    }

    protected void actionPerformed(GuiButton b) {
        super.actionPerformed(b);
        if (b.id >= 0 && b.id <= 2) {
            ((TileWeatherObelisk)this.getTileEntity()).startTask();
            PacketHandler.INSTANCE.sendToServer((IMessage)new PacketActivateWeather((TileWeatherObelisk)this.getTileEntity()));
        }
    }
}

