/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.machine.obelisk.weather;

import cpw.mods.fml.relauncher.ReflectionHelper;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import crazypants.enderio.machine.obelisk.weather.TileWeatherObelisk;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.EntityFX;
import net.minecraft.client.particle.EntityFireworkSparkFX;
import net.minecraft.entity.item.EntityFireworkRocket;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;

public class EntityWeatherRocket
extends EntityFireworkRocket {
    private static final int DATA_ID = 24;
    private static final int MAX_AGE = 70;

    public EntityWeatherRocket(World world) {
        super(world);
        ReflectionHelper.setPrivateValue(EntityFireworkRocket.class, (Object)((Object)this), (Object)70, (String[])new String[]{"field_92055_b", "lifetime"});
    }

    public EntityWeatherRocket(World world, TileWeatherObelisk.WeatherTask task) {
        this(world);
        this.getDataWatcher().updateObject(24, (Object)task.ordinal());
    }

    protected void entityInit() {
        super.entityInit();
        this.getDataWatcher().addObject(24, (Object)0);
        this.getDataWatcher().setObjectWatched(24);
    }

    public void onEntityUpdate() {
        super.onEntityUpdate();
        if (this.worldObj.isRemote && this.ticksExisted % 7 == 0 && this.ticksExisted > 30) {
            this.doEffect();
        }
    }

    public void moveEntity(double p_70091_1_, double p_70091_3_, double p_70091_5_) {
        super.moveEntity(p_70091_1_, p_70091_3_, p_70091_5_);
    }

    public void setDead() {
        super.setDead();
        TileWeatherObelisk.WeatherTask task = TileWeatherObelisk.WeatherTask.values()[this.getDataWatcher().getWatchableObjectInt(24)];
        task.complete(this.worldObj);
    }

    public void handleHealthUpdate(byte p_70103_1_) {
    }

    @SideOnly(value=Side.CLIENT)
    private void doEffect() {
        String s1 = "fireworks.largeBlast";
        if (this.ticksExisted > 40) {
            s1 = s1 + "_far";
        }
        this.worldObj.playSound(this.posX, this.posY, this.posZ, s1, 20.0f, 0.95f + this.rand.nextFloat() * 0.1f, true);
        double d1 = this.posX;
        double d2 = this.posY;
        double d3 = this.posZ;
        int size = 5;
        double speed = 1.0;
        for (int j = -size; j <= size; ++j) {
            for (int k = -size; k <= size; ++k) {
                for (int l = -size; l <= size; ++l) {
                    double d4 = (double)k + (this.rand.nextDouble() - this.rand.nextDouble()) * 0.5;
                    double d5 = (double)j + (this.rand.nextDouble() - this.rand.nextDouble()) * 0.5;
                    double d6 = (double)l + (this.rand.nextDouble() - this.rand.nextDouble()) * 0.5;
                    double d7 = (double)MathHelper.sqrt_double((double)(d4 * d4 + d5 * d5 + d6 * d6)) / speed + this.rand.nextGaussian() * 0.05;
                    EntityFireworkSparkFX entityfireworksparkfx = new EntityFireworkSparkFX(this.worldObj, d1, d2, d3, d4 / d7, d5 / d7, d6 / d7, Minecraft.getMinecraft().effectRenderer);
                    entityfireworksparkfx.setTrail(true);
                    entityfireworksparkfx.setTwinkle(false);
                    entityfireworksparkfx.setColour(TileWeatherObelisk.WeatherTask.values()[this.getDataWatcher().getWatchableObjectInt((int)24)].color.getRGB());
                    Minecraft.getMinecraft().effectRenderer.addEffect((EntityFX)entityfireworksparkfx);
                    if (j == -size || j == size || k == -size || k == size) continue;
                    l += size * 2 - 1;
                }
            }
        }
    }
}

