/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.machine.obelisk.aversion;

import com.enderio.core.client.render.BoundingBox;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import crazypants.enderio.EnderIO;
import crazypants.enderio.ModObject;
import crazypants.enderio.config.Config;
import crazypants.enderio.machine.AbstractPowerConsumerEntity;
import crazypants.enderio.machine.SlotDefinition;
import crazypants.enderio.machine.obelisk.aversion.AversionObeliskController;
import crazypants.enderio.machine.ranged.IRanged;
import crazypants.enderio.machine.ranged.RangeEntity;
import crazypants.enderio.power.BasicCapacitor;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;

public class TileAversionObelisk
extends AbstractPowerConsumerEntity
implements IRanged {
    private int powerPerTick;
    private int range;
    private boolean registered = false;
    private AxisAlignedBB bounds;
    private boolean showingRange;

    public TileAversionObelisk() {
        super(new SlotDefinition(12, 0));
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean isShowingRange() {
        return this.showingRange;
    }

    @SideOnly(value=Side.CLIENT)
    public void setShowRange(boolean showRange) {
        if (this.showingRange == showRange) {
            return;
        }
        this.showingRange = showRange;
        if (this.showingRange) {
            this.worldObj.spawnEntityInWorld((Entity)new RangeEntity(this));
        }
    }

    @Override
    public World getWorld() {
        return this.getWorldObj();
    }

    @Override
    public void invalidate() {
        super.invalidate();
        AversionObeliskController.instance.deregisterGuard(this);
        this.registered = false;
    }

    @Override
    public float getRange() {
        return this.range;
    }

    @Override
    public void onCapacitorTypeChange() {
        switch (this.getCapacitorType()) {
            case BASIC_CAPACITOR: {
                this.range = Config.spawnGuardRangeLevelOne;
                this.powerPerTick = Config.spawnGuardPowerPerTickLevelOne;
                break;
            }
            case ACTIVATED_CAPACITOR: {
                this.range = Config.spawnGuardRangeLevelTwo;
                this.powerPerTick = Config.spawnGuardPowerPerTickLevelTwo;
                break;
            }
            case ENDER_CAPACITOR: {
                this.range = Config.spawnGuardRangeLevelThree;
                this.powerPerTick = Config.spawnGuardPowerPerTickLevelThree;
            }
        }
        this.setCapacitor(new BasicCapacitor(this.powerPerTick * 8, this.getCapacitor().getMaxEnergyStored(), this.powerPerTick));
        BoundingBox bb = new BoundingBox(this.getLocation());
        bb = bb.scale((float)this.range + 0.5f, (float)this.range + 0.5f, (float)this.range + 0.5f).translate(0.5f, 0.5f, 0.5f);
        this.bounds = AxisAlignedBB.getBoundingBox((double)bb.minX, (double)bb.minY, (double)bb.minZ, (double)bb.maxX, (double)bb.maxY, (double)bb.maxZ);
    }

    @Override
    public String getMachineName() {
        return ModObject.blockSpawnGuard.unlocalisedName;
    }

    @Override
    protected boolean isMachineItemValidForSlot(int i, ItemStack itemstack) {
        if (!this.slotDefinition.isInputSlot(i)) {
            return false;
        }
        String mob = EnderIO.itemSoulVessel.getMobTypeFromStack(itemstack);
        if (mob == null) {
            return false;
        }
        Class cl = (Class)EntityList.stringToClassMapping.get(mob);
        if (cl == null) {
            return false;
        }
        return EntityLiving.class.isAssignableFrom(cl);
    }

    @Override
    public boolean isActive() {
        return this.hasPower();
    }

    @Override
    protected boolean processTasks(boolean redstoneCheckPassed) {
        if (redstoneCheckPassed && this.hasPower()) {
            if (!this.registered) {
                AversionObeliskController.instance.registerGuard(this);
                this.registered = true;
            }
            this.usePower();
        }
        return false;
    }

    protected double usePower() {
        return this.usePower(this.getPowerUsePerTick());
    }

    protected int usePower(int wantToUse) {
        int used = Math.min(this.getEnergyStored(), wantToUse);
        this.setEnergyStored(Math.max(0, this.getEnergyStored() - used));
        return used;
    }

    @Override
    public int getPowerUsePerTick() {
        return this.powerPerTick;
    }

    public boolean isSpawnPrevented(EntityLivingBase mob) {
        return this.redstoneCheckPassed && this.hasPower() && this.isMobInRange(mob) && this.isMobInFilter(mob);
    }

    private boolean isMobInRange(EntityLivingBase mob) {
        if (mob == null) {
            return false;
        }
        return this.bounds.isVecInside(Vec3.createVectorHelper((double)mob.posX, (double)mob.posY, (double)mob.posZ));
    }

    private boolean isMobInFilter(EntityLivingBase ent) {
        return this.isMobInFilter(EntityList.getEntityString((Entity)ent));
    }

    private boolean isMobInFilter(String entityId) {
        for (int i = this.slotDefinition.minInputSlot; i <= this.slotDefinition.maxInputSlot; ++i) {
            String mob;
            if (this.inventory[i] == null || (mob = EnderIO.itemSoulVessel.getMobTypeFromStack(this.inventory[i])) == null || !mob.equals(entityId)) continue;
            return true;
        }
        return false;
    }
}

