/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.machine.obelisk.attractor;

import com.enderio.core.client.render.BoundingBox;
import com.enderio.core.common.util.BlockCoord;
import com.enderio.core.common.vecmath.Vector3d;
import com.mojang.authlib.GameProfile;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import crazypants.enderio.EnderIO;
import crazypants.enderio.ModObject;
import crazypants.enderio.config.Config;
import crazypants.enderio.machine.AbstractPowerConsumerEntity;
import crazypants.enderio.machine.FakePlayerEIO;
import crazypants.enderio.machine.SlotDefinition;
import crazypants.enderio.machine.ranged.IRanged;
import crazypants.enderio.machine.ranged.RangeEntity;
import crazypants.enderio.power.BasicCapacitor;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAITasks;
import net.minecraft.entity.monster.EntityBlaze;
import net.minecraft.entity.monster.EntityEnderman;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.monster.EntityPigZombie;
import net.minecraft.entity.monster.EntitySilverfish;
import net.minecraft.entity.monster.EntitySlime;
import net.minecraft.entity.monster.EntitySpider;
import net.minecraft.item.ItemStack;
import net.minecraft.pathfinding.PathEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.World;
import net.minecraftforge.common.util.FakePlayer;

public class TileAttractor
extends AbstractPowerConsumerEntity
implements IRanged {
    private AxisAlignedBB attractorBounds;
    private FakePlayer target;
    private int rangeSqu;
    private int range;
    private int powerPerTick;
    private Set<EntityLiving> tracking = new HashSet<EntityLiving>();
    private int tickCounter = 0;
    private int maxMobsAttracted = 20;
    private boolean showingRange;

    public TileAttractor() {
        super(new SlotDefinition(12, 0));
    }

    @Override
    public float getRange() {
        return this.range;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean isShowingRange() {
        return this.showingRange;
    }

    @SideOnly(value=Side.CLIENT)
    public void setShowRange(boolean showRange) {
        if (this.showingRange == showRange) {
            return;
        }
        this.showingRange = showRange;
        if (this.showingRange) {
            this.worldObj.spawnEntityInWorld((Entity)new RangeEntity(this));
        }
    }

    @Override
    public World getWorld() {
        return this.worldObj;
    }

    @Override
    public void onCapacitorTypeChange() {
        switch (this.getCapacitorType()) {
            case ACTIVATED_CAPACITOR: {
                this.range = Config.attractorRangeLevelTwo;
                this.powerPerTick = Config.attractorPowerPerTickLevelTwo;
                break;
            }
            case ENDER_CAPACITOR: {
                this.range = Config.attractorRangeLevelThree;
                this.powerPerTick = Config.attractorPowerPerTickLevelThree;
                break;
            }
            default: {
                this.range = Config.attractorRangeLevelOne;
                this.powerPerTick = Config.attractorPowerPerTickLevelOne;
            }
        }
        this.rangeSqu = this.range * this.range;
        BoundingBox bb = new BoundingBox(new BlockCoord((TileEntity)this));
        bb = bb.scale((float)this.range, (float)this.range, (float)this.range);
        this.attractorBounds = AxisAlignedBB.getBoundingBox((double)bb.minX, (double)bb.minY, (double)bb.minZ, (double)bb.maxX, (double)bb.maxY, (double)bb.maxZ);
        this.setCapacitor(new BasicCapacitor(this.powerPerTick * 8, this.getCapacitor().getMaxEnergyStored(), this.powerPerTick));
    }

    @Override
    public String getMachineName() {
        return ModObject.blockAttractor.unlocalisedName;
    }

    @Override
    protected boolean isMachineItemValidForSlot(int i, ItemStack itemstack) {
        if (!this.slotDefinition.isInputSlot(i)) {
            return false;
        }
        String mob = EnderIO.itemSoulVessel.getMobTypeFromStack(itemstack);
        if (mob == null) {
            return false;
        }
        Class cl = (Class)EntityList.stringToClassMapping.get(mob);
        if (cl == null) {
            return false;
        }
        return EntityLiving.class.isAssignableFrom(cl);
    }

    @Override
    public boolean isActive() {
        return this.hasPower();
    }

    @Override
    protected boolean processTasks(boolean redstoneCheckPassed) {
        if (!redstoneCheckPassed || !this.hasPower()) {
            return false;
        }
        this.usePower();
        ++this.tickCounter;
        if (this.tickCounter < 10) {
            for (EntityLiving ent : this.tracking) {
                this.onEntityTick(ent);
            }
            return false;
        }
        this.tickCounter = 0;
        HashSet<EntityLiving> trackingThisTick = new HashSet<EntityLiving>();
        List entsInBounds = this.worldObj.getEntitiesWithinAABB(EntityLiving.class, this.attractorBounds);
        int candidates = 0;
        for (EntityLiving ent : entsInBounds) {
            if (ent.isDead || !this.isMobInFilter(ent)) continue;
            ++candidates;
            if (this.tracking.contains(ent)) {
                trackingThisTick.add(ent);
                this.onEntityTick(ent);
                continue;
            }
            if (this.tracking.size() >= this.maxMobsAttracted || !this.trackMob(ent)) continue;
            trackingThisTick.add(ent);
            this.onTracked(ent);
        }
        for (EntityLiving e : this.tracking) {
            if (trackingThisTick.contains(e)) continue;
            this.onUntracked(e);
        }
        this.tracking.clear();
        this.tracking = trackingThisTick;
        return false;
    }

    private void onUntracked(EntityLiving e) {
        if (e instanceof EntityEnderman) {
            e.getEntityData().setBoolean("EIO:tracked", false);
        }
    }

    private void onTracked(EntityLiving e) {
        if (e instanceof EntityEnderman) {
            e.getEntityData().setBoolean("EIO:tracked", true);
        }
    }

    @Override
    public void invalidate() {
        super.invalidate();
        for (EntityLiving e : this.tracking) {
            this.onUntracked(e);
        }
        this.tracking.clear();
    }

    protected double usePower() {
        return this.usePower(this.getPowerUsePerTick());
    }

    protected int usePower(int wantToUse) {
        int used = Math.min(this.getEnergyStored(), wantToUse);
        this.setEnergyStored(Math.max(0, this.getEnergyStored() - used));
        return used;
    }

    @Override
    public int getPowerUsePerTick() {
        return this.powerPerTick;
    }

    FakePlayer getTarget() {
        if (this.target == null) {
            this.target = new Target();
        }
        return this.target;
    }

    public boolean canAttract(String entityId, EntityLiving mob) {
        return this.redstoneCheckPassed && this.hasPower() && this.isMobInFilter(entityId) && this.isMobInRange(mob);
    }

    private boolean isMobInRange(EntityLiving mob) {
        return this.isMobInRange(mob, this.rangeSqu);
    }

    private boolean isMobInRange(EntityLiving mob, int range) {
        if (mob == null) {
            return false;
        }
        return new Vector3d(mob.posX, mob.posY, mob.posZ).distanceSquared(new Vector3d((double)this.xCoord, (double)this.yCoord, (double)this.zCoord)) <= (double)range;
    }

    private boolean isMobInFilter(EntityLiving ent) {
        return this.isMobInFilter(EntityList.getEntityString((Entity)ent));
    }

    private boolean isMobInFilter(String entityId) {
        for (int i = this.slotDefinition.minInputSlot; i <= this.slotDefinition.maxInputSlot; ++i) {
            String mob;
            if (this.inventory[i] == null || (mob = EnderIO.itemSoulVessel.getMobTypeFromStack(this.inventory[i])) == null || !mob.equals(entityId)) continue;
            return true;
        }
        return false;
    }

    private boolean trackMob(EntityLiving ent) {
        if (this.useSetTarget(ent)) {
            ((EntityMob)ent).setTarget((Entity)this.getTarget());
            return true;
        }
        if (this.useSpecialCase(ent)) {
            return this.applySpecialCase(ent);
        }
        return this.attractyUsingAITask(ent);
    }

    private boolean attractyUsingAITask(EntityLiving ent) {
        this.tracking.add(ent);
        List entries = ent.tasks.taskEntries;
        boolean hasTask = false;
        EntityAIBase remove = null;
        for (EntityAITasks.EntityAITaskEntry entry : entries) {
            if (!(entry.action instanceof AttractTask)) continue;
            AttractTask at = (AttractTask)entry.action;
            if (at.coord.equals((Object)new BlockCoord((TileEntity)this)) || !at.continueExecuting()) {
                remove = entry.action;
                continue;
            }
            return false;
        }
        if (remove != null) {
            ent.tasks.removeTask(remove);
        }
        this.cancelCurrentTasks(ent);
        ent.tasks.addTask(0, (EntityAIBase)new AttractTask(ent, this.getTarget(), new BlockCoord((TileEntity)this)));
        return true;
    }

    private void cancelCurrentTasks(EntityLiving ent) {
        Iterator iterator = ent.tasks.taskEntries.iterator();
        ArrayList<EntityAITasks.EntityAITaskEntry> currentTasks = new ArrayList<EntityAITasks.EntityAITaskEntry>();
        while (iterator.hasNext()) {
            EntityAITasks.EntityAITaskEntry entityaitaskentry = (EntityAITasks.EntityAITaskEntry)iterator.next();
            if (entityaitaskentry == null) continue;
            currentTasks.add(entityaitaskentry);
        }
        for (EntityAITasks.EntityAITaskEntry task : currentTasks) {
            ent.tasks.removeTask(task.action);
            ent.tasks.addTask(task.priority, task.action);
        }
    }

    private boolean applySpecialCase(EntityLiving ent) {
        if (ent instanceof EntitySlime) {
            ent.faceEntity((Entity)this.getTarget(), 10.0f, 20.0f);
            return true;
        }
        if (ent instanceof EntitySilverfish) {
            PathEntity pathentity = this.worldObj.getPathEntityToEntity((Entity)ent, (Entity)this.getTarget(), this.getRange(), true, false, false, true);
            ((EntityCreature)ent).setPathToEntity(pathentity);
            return true;
        }
        return ent instanceof EntityBlaze;
    }

    private boolean useSpecialCase(EntityLiving ent) {
        return ent instanceof EntitySlime || ent instanceof EntitySilverfish || ent instanceof EntityBlaze;
    }

    private void onEntityTick(EntityLiving ent) {
        if (ent instanceof EntitySlime) {
            ent.faceEntity((Entity)this.getTarget(), 10.0f, 20.0f);
        } else if (ent instanceof EntitySilverfish) {
            if (this.tickCounter < 10) {
                return;
            }
            EntitySilverfish sf = (EntitySilverfish)ent;
            PathEntity pathentity = this.worldObj.getPathEntityToEntity((Entity)ent, (Entity)this.getTarget(), this.getRange(), true, false, false, true);
            sf.setPathToEntity(pathentity);
        } else if (ent instanceof EntityBlaze) {
            EntityBlaze mob = (EntityBlaze)ent;
            double x = (double)this.xCoord + 0.5 - ent.posX;
            double y = (double)this.yCoord + 1.0 - ent.posY;
            double z = (double)this.zCoord + 0.5 - ent.posZ;
            double distance = Math.sqrt(x * x + y * y + z * z);
            if (distance > 1.25) {
                double speed = 0.01;
                ent.motionX += x / distance * speed;
                if (y > 0.0) {
                    ent.motionY += ((double)0.3f - ent.motionY) * (double)0.3f;
                }
                ent.motionZ += z / distance * speed;
            }
        } else if (ent instanceof EntityPigZombie || ent instanceof EntitySpider) {
            this.forceMove(ent);
        } else if (ent instanceof EntityEnderman) {
            ((EntityEnderman)ent).setTarget((Entity)this.getTarget());
        }
    }

    private void forceMove(EntityLiving ent) {
        double x = (double)this.xCoord + 0.5 - ent.posX;
        double y = (double)this.yCoord + 1.0 - ent.posY;
        double z = (double)this.zCoord + 0.5 - ent.posZ;
        double distance = Math.sqrt(x * x + y * y + z * z);
        if (distance > 2.0) {
            EntityMob mod = (EntityMob)ent;
            mod.faceEntity((Entity)this.getTarget(), 180.0f, 0.0f);
            mod.moveEntityWithHeading(0.0f, 1.0f);
            if (mod.posY < (double)this.yCoord) {
                mod.setJumping(true);
            } else {
                mod.setJumping(false);
            }
        }
    }

    private boolean useSetTarget(EntityLiving ent) {
        return ent instanceof EntityPigZombie || ent instanceof EntitySpider || ent instanceof EntitySilverfish;
    }

    private static class AttractTask
    extends EntityAIBase {
        private EntityLiving mob;
        private BlockCoord coord;
        private FakePlayer target;
        private String entityId;
        private int updatesSincePathing;
        private boolean started = false;

        private AttractTask(EntityLiving mob, FakePlayer target, BlockCoord coord) {
            this.mob = mob;
            this.coord = coord;
            this.target = target;
            this.entityId = EntityList.getEntityString((Entity)mob);
        }

        public boolean shouldExecute() {
            return this.continueExecuting();
        }

        public void resetTask() {
            this.started = false;
            this.updatesSincePathing = 0;
        }

        public boolean continueExecuting() {
            boolean res = false;
            TileEntity te = this.mob.worldObj.getTileEntity(this.coord.x, this.coord.y, this.coord.z);
            if (te instanceof TileAttractor) {
                TileAttractor attractor = (TileAttractor)te;
                res = attractor.canAttract(this.entityId, this.mob);
            }
            return res;
        }

        public boolean isInterruptible() {
            return true;
        }

        public void updateTask() {
            if (!this.started || this.updatesSincePathing > 20) {
                this.started = true;
                boolean speed = true;
                this.mob.getNavigator().setAvoidsWater(false);
                boolean res = this.mob.getNavigator().tryMoveToEntityLiving((Entity)this.target, (double)speed);
                if (!res) {
                    this.mob.getNavigator().tryMoveToXYZ(this.target.posX, this.target.posY + 1.0, this.target.posZ, (double)speed);
                }
                this.updatesSincePathing = 0;
            } else {
                ++this.updatesSincePathing;
            }
        }
    }

    private class Target
    extends FakePlayerEIO {
        public Target() {
            super(TileAttractor.this.getWorldObj(), TileAttractor.this.getLocation(), new GameProfile(null, ModObject.blockAttractor.unlocalisedName + ":" + TileAttractor.this.getLocation()));
            this.posY += 1.0;
        }
    }
}

