/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.machine.monitor;

import com.enderio.core.common.util.DyeColor;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import crazypants.enderio.EnderIO;
import crazypants.enderio.ModObject;
import crazypants.enderio.conduit.AbstractConduitNetwork;
import crazypants.enderio.conduit.ConduitUtil;
import crazypants.enderio.conduit.power.IPowerConduit;
import crazypants.enderio.conduit.power.NetworkPowerManager;
import crazypants.enderio.conduit.power.PowerConduitNetwork;
import crazypants.enderio.conduit.power.PowerTracker;
import crazypants.enderio.conduit.redstone.Signal;
import crazypants.enderio.machine.AbstractPowerConsumerEntity;
import crazypants.enderio.machine.IoMode;
import crazypants.enderio.machine.SlotDefinition;
import crazypants.enderio.machine.monitor.PacketPowerInfo;
import crazypants.enderio.network.PacketHandler;
import crazypants.enderio.power.IInternalPoweredTile;
import net.minecraft.block.Block;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.ForgeDirection;

public class TilePowerMonitor
extends AbstractPowerConsumerEntity
implements IInternalPoweredTile {
    int energyPerTick = 1;
    int powerInConduits;
    int maxPowerInConduits;
    long powerInCapBanks;
    long maxPowerInCapBanks;
    long powerInMachines;
    long maxPowerInMachines;
    float aveRfSent;
    float aveRfReceived;
    boolean engineControlEnabled = false;
    float startLevel = 0.75f;
    float stopLevel = 0.99f;
    private Signal currentlyEmmittedSignal;

    public TilePowerMonitor() {
        super(new SlotDefinition(0, 0));
    }

    @Override
    public boolean supportsMode(ForgeDirection faceHit, IoMode mode) {
        return mode == IoMode.NONE;
    }

    public int[] getRednetOutputValues(ForgeDirection side) {
        if (this.currentlyEmmittedSignal == null) {
            return new int[16];
        }
        int[] res = new int[DyeColor.values().length];
        for (DyeColor col : DyeColor.values()) {
            res[col.ordinal()] = this.currentlyEmmittedSignal.color == col ? 15 : 0;
        }
        return res;
    }

    public int getRednetOutputValue(ForgeDirection side, int subnet) {
        if (this.currentlyEmmittedSignal != null) {
            return 15;
        }
        return 0;
    }

    public boolean isEngineControlEnabled() {
        return this.engineControlEnabled;
    }

    public void setEngineControlEnabled(boolean control) {
        this.engineControlEnabled = control;
    }

    public float getStartLevel() {
        return this.startLevel;
    }

    public void setStartLevel(float start) {
        this.startLevel = start;
    }

    public float getStopLevel() {
        return this.stopLevel;
    }

    public void setStopLevel(float stop) {
        this.stopLevel = stop;
    }

    int asPercentInt(float val) {
        return Math.round(val * 100.0f);
    }

    float asPercentFloat(int val) {
        return (float)val / 100.0f;
    }

    @Override
    public String getInventoryName() {
        return EnderIO.blockPowerMonitor.getUnlocalizedName();
    }

    @Override
    public String getMachineName() {
        return ModObject.blockPowerMonitor.unlocalisedName;
    }

    @Override
    protected boolean isMachineItemValidForSlot(int i, ItemStack itemstack) {
        return false;
    }

    @Override
    public boolean isActive() {
        return false;
    }

    public float getEnergyPerTick() {
        return this.energyPerTick;
    }

    public float getPowerInConduits() {
        return this.powerInConduits;
    }

    public float getMaxPowerInConduits() {
        return this.maxPowerInConduits;
    }

    public float getPowerInCapBanks() {
        return this.powerInCapBanks;
    }

    public float getMaxPowerInCapBanks() {
        return this.maxPowerInCapBanks;
    }

    public float getPowerInMachines() {
        return this.powerInMachines;
    }

    public float getMaxPowerInMachines() {
        return this.maxPowerInMachines;
    }

    public float getAveRfSent() {
        return this.aveRfSent;
    }

    public float getAveRfReceived() {
        return this.aveRfReceived;
    }

    @Override
    protected boolean processTasks(boolean redstoneCheckPassed) {
        this.setEnergyStored(this.getEnergyStored() - this.energyPerTick);
        boolean update = this.worldObj.getWorldInfo().getWorldTotalTime() % 10L == 0L;
        NetworkPowerManager pm = this.getPowerManager();
        if (pm != null && update) {
            this.update(pm);
            Signal sig = null;
            if (!this.engineControlEnabled) {
                sig = null;
            } else {
                float percentFull = this.getPercentFull();
                if (this.currentlyEmmittedSignal == null) {
                    if (percentFull <= this.startLevel) {
                        sig = new Signal(this.xCoord, this.yCoord, this.zCoord, ForgeDirection.UNKNOWN, 15, DyeColor.RED);
                    }
                } else {
                    sig = percentFull >= this.stopLevel ? null : this.currentlyEmmittedSignal;
                }
            }
            if (this.currentlyEmmittedSignal != sig) {
                this.currentlyEmmittedSignal = sig;
                this.broadcastSignal();
            }
        }
        if (update) {
            PacketHandler.sendToAllAround((IMessage)new PacketPowerInfo(this), (TileEntity)this);
        }
        return false;
    }

    private void broadcastSignal() {
        this.worldObj.notifyBlocksOfNeighborChange(this.xCoord, this.yCoord, this.zCoord, (Block)EnderIO.blockPowerMonitor);
    }

    private float getPercentFull() {
        return (float)((long)this.powerInConduits + this.powerInCapBanks) / (float)((long)this.maxPowerInConduits + this.maxPowerInCapBanks);
    }

    private void update(NetworkPowerManager pm) {
        this.powerInConduits = pm.getPowerInConduits();
        this.maxPowerInConduits = pm.getMaxPowerInConduits();
        this.powerInCapBanks = pm.getPowerInCapacitorBanks();
        this.maxPowerInCapBanks = pm.getMaxPowerInCapacitorBanks();
        this.powerInMachines = pm.getPowerInReceptors();
        this.maxPowerInMachines = pm.getMaxPowerInReceptors();
        PowerTracker tracker = pm.getNetworkPowerTracker();
        this.aveRfSent = tracker.getAverageRfTickSent();
        this.aveRfReceived = tracker.getAverageRfTickRecieved();
    }

    private NetworkPowerManager getPowerManager() {
        for (ForgeDirection dir : ForgeDirection.VALID_DIRECTIONS) {
            NetworkPowerManager pm;
            AbstractConduitNetwork<?, ?> n;
            IPowerConduit con = ConduitUtil.getConduit(this.worldObj, (TileEntity)this, dir, IPowerConduit.class);
            if (con == null || !((n = con.getNetwork()) instanceof PowerConduitNetwork) || (pm = ((PowerConduitNetwork)n).getPowerManager()) == null) continue;
            return pm;
        }
        return null;
    }

    @Override
    public void readCustomNBT(NBTTagCompound nbtRoot) {
        super.readCustomNBT(nbtRoot);
        this.readPowerInfoFromNBT(nbtRoot);
    }

    public void readPowerInfoFromNBT(NBTTagCompound nbtRoot) {
        this.powerInConduits = nbtRoot.getInteger("powerInConduits");
        this.maxPowerInConduits = nbtRoot.getInteger("maxPowerInConduits");
        if (nbtRoot.hasKey("powerInCapBanks")) {
            this.powerInCapBanks = nbtRoot.getInteger("powerInCapBanks");
            this.maxPowerInCapBanks = nbtRoot.getInteger("maxPowerInCapBanks");
        } else {
            this.powerInCapBanks = nbtRoot.getLong("powerInCapBanksL");
            this.maxPowerInCapBanks = nbtRoot.getLong("maxPowerInCapBanksL");
        }
        this.powerInMachines = nbtRoot.getLong("powerInMachines");
        this.maxPowerInMachines = nbtRoot.getLong("maxPowerInMachines");
        this.aveRfSent = nbtRoot.getFloat("aveRfSent");
        this.aveRfReceived = nbtRoot.getFloat("aveRfReceived");
        this.engineControlEnabled = nbtRoot.getBoolean("engineControlEnabled");
        this.startLevel = nbtRoot.getFloat("startLevel");
        this.stopLevel = nbtRoot.getFloat("stopLevel");
    }

    @Override
    public void writeCustomNBT(NBTTagCompound nbtRoot) {
        super.writeCustomNBT(nbtRoot);
        this.writePowerInfoToNBT(nbtRoot);
    }

    public void writePowerInfoToNBT(NBTTagCompound nbtRoot) {
        nbtRoot.setInteger("powerInConduits", this.powerInConduits);
        nbtRoot.setInteger("maxPowerInConduits", this.maxPowerInConduits);
        nbtRoot.setLong("powerInCapBanksL", this.powerInCapBanks);
        nbtRoot.setLong("maxPowerInCapBanksL", this.maxPowerInCapBanks);
        nbtRoot.setLong("powerInMachines", this.powerInMachines);
        nbtRoot.setLong("maxPowerInMachines", this.maxPowerInMachines);
        nbtRoot.setFloat("aveRfSent", this.aveRfSent);
        nbtRoot.setFloat("aveRfReceived", this.aveRfReceived);
        nbtRoot.setBoolean("engineControlEnabled", this.engineControlEnabled);
        nbtRoot.setFloat("startLevel", this.startLevel);
        nbtRoot.setFloat("stopLevel", this.stopLevel);
    }

    @Override
    public boolean hasCustomInventoryName() {
        return false;
    }
}

