/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.machine.light;

import com.enderio.core.common.util.BlockCoord;
import com.enderio.core.common.util.ForgeDirectionOffsets;
import com.enderio.core.common.vecmath.Vector3d;
import crazypants.enderio.EnderIO;
import crazypants.enderio.TileEntityEio;
import crazypants.enderio.machine.light.TileLightNode;
import crazypants.enderio.machine.wireless.WirelessChargedLocation;
import crazypants.enderio.power.Capacitors;
import crazypants.enderio.power.IInternalPowerReceiver;
import crazypants.enderio.power.PowerHandlerUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.EnumSkyBlock;
import net.minecraftforge.common.util.ForgeDirection;

public class TileElectricLight
extends TileEntityEio
implements IInternalPowerReceiver {
    private ForgeDirection face = ForgeDirection.DOWN;
    public static final int RF_USE_PER_TICK = 1;
    private boolean init = true;
    private List<TileLightNode> lightNodes;
    private int[] lightNodeCoords;
    private boolean updatingLightNodes = false;
    private boolean lastActive = false;
    private boolean isInvereted;
    private boolean requiresPower = true;
    private WirelessChargedLocation chargedLocation;
    private int energyStoredRF;

    public void onNeighborBlockChange(Block blockID) {
        this.init = true;
    }

    public void nodeNeighbourChanged(TileLightNode tileLightNode) {
        this.init = true;
    }

    public void nodeRemoved(TileLightNode tileLightNode) {
        if (!this.updatingLightNodes) {
            this.init = true;
        }
    }

    public ForgeDirection getFace() {
        return this.face;
    }

    public void setFace(ForgeDirection face) {
        this.face = face;
    }

    public void setInverted(boolean inverted) {
        this.isInvereted = inverted;
    }

    public void setRequiresPower(boolean isPowered) {
        this.requiresPower = isPowered;
    }

    public boolean isRequiresPower() {
        return this.requiresPower;
    }

    public void setInvereted(boolean isInvereted) {
        this.isInvereted = isInvereted;
    }

    public boolean isInvereted() {
        return this.isInvereted;
    }

    public void setWireless(boolean wireless) {
        if (!wireless) {
            this.chargedLocation = null;
        } else if (this.chargedLocation == null) {
            this.chargedLocation = new WirelessChargedLocation((TileEntity)this);
        }
    }

    public boolean isWireless() {
        return this.chargedLocation != null;
    }

    public void doUpdate() {
        boolean isActivated;
        if (this.worldObj.isRemote) {
            return;
        }
        boolean bl = isActivated = this.init ? this.isPoweredRedstone() ^ this.isInvereted : this.lastActive;
        if (this.requiresPower) {
            if (isActivated) {
                if (!this.hasPower()) {
                    isActivated = false;
                } else {
                    this.setEnergyStored(this.getEnergyStored() - 1);
                }
            }
            if (this.init) {
                this.updateLightNodes();
            }
        }
        if (isActivated != this.lastActive || this.init) {
            this.worldObj.setBlockMetadataWithNotify(this.xCoord, this.yCoord, this.zCoord, isActivated ? 1 : 0, 2);
            if (this.requiresPower) {
                for (TileLightNode ln : this.lightNodes) {
                    if (ln == null) continue;
                    this.worldObj.setBlockMetadataWithNotify(ln.xCoord, ln.yCoord, ln.zCoord, isActivated ? 1 : 0, 2);
                    this.worldObj.markBlockForUpdate(ln.xCoord, ln.yCoord, ln.zCoord);
                    this.worldObj.updateLightByType(EnumSkyBlock.Block, ln.xCoord, ln.yCoord, ln.zCoord);
                }
            }
            this.worldObj.markBlockForUpdate(this.xCoord, this.yCoord, this.zCoord);
            this.worldObj.updateLightByType(EnumSkyBlock.Block, this.xCoord, this.yCoord, this.zCoord);
            this.init = false;
            this.lastActive = isActivated;
        }
        if (this.chargedLocation != null && this.energyStoredRF < this.getMaxEnergyStored()) {
            boolean needInit = this.energyStoredRF == 0;
            this.energyStoredRF += this.chargedLocation.takeEnergy(Math.min(this.getMaxEnergyStored() - this.energyStoredRF, 10));
            if (needInit && this.energyStoredRF > 0) {
                this.init = true;
            }
        }
    }

    public void onBlockRemoved() {
        if (!this.requiresPower) {
            return;
        }
        this.updatingLightNodes = true;
        try {
            this.clearLightNodes();
        }
        finally {
            this.updatingLightNodes = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateLightNodes() {
        Set before;
        if (this.lightNodes != null && !this.lightNodes.isEmpty()) {
            before = new HashSet(this.lightNodes.size());
            for (TileLightNode node : this.lightNodes) {
                before.add(node.getLocation());
            }
        } else {
            before = Collections.emptySet();
        }
        HashSet<BlockCoord> after = new HashSet<BlockCoord>(17);
        this.updatingLightNodes = true;
        try {
            if (this.lightNodeCoords != null) {
                this.lightNodes = new ArrayList<TileLightNode>();
                for (int i = 0; i < this.lightNodeCoords.length; i += 3) {
                    TileEntity te = this.worldObj.getTileEntity(this.lightNodeCoords[i], this.lightNodeCoords[i + 1], this.lightNodeCoords[i + 2]);
                    if (!(te instanceof TileLightNode)) continue;
                    this.lightNodes.add((TileLightNode)te);
                }
                this.lightNodeCoords = null;
            } else if (this.lightNodes == null) {
                this.lightNodes = new ArrayList<TileLightNode>();
            }
            for (ForgeDirection dir : ForgeDirection.VALID_DIRECTIONS) {
                if (dir == this.face || dir == this.face.getOpposite()) continue;
                Vector3d offset = ForgeDirectionOffsets.forDirCopy((ForgeDirection)dir);
                this.addNodeInDirection(new Vector3d(offset), after);
                this.addNodeInDirection(offset.add(ForgeDirectionOffsets.forDirCopy((ForgeDirection)this.face.getOpposite())), after);
            }
            this.addNodeInDirection(ForgeDirectionOffsets.forDirCopy((ForgeDirection)this.face.getOpposite()), after);
            Vector3d[] diags = new Vector3d[2];
            if (this.face.offsetX != 0) {
                diags[0] = ForgeDirectionOffsets.forDirCopy((ForgeDirection)ForgeDirection.UP);
                diags[1] = ForgeDirectionOffsets.forDirCopy((ForgeDirection)ForgeDirection.SOUTH);
            } else if (this.face.offsetY != 0) {
                diags[0] = ForgeDirectionOffsets.forDirCopy((ForgeDirection)ForgeDirection.EAST);
                diags[1] = ForgeDirectionOffsets.forDirCopy((ForgeDirection)ForgeDirection.SOUTH);
            } else {
                diags[0] = ForgeDirectionOffsets.forDirCopy((ForgeDirection)ForgeDirection.UP);
                diags[1] = ForgeDirectionOffsets.forDirCopy((ForgeDirection)ForgeDirection.EAST);
            }
            this.addDiaganals(diags, new Vector3d(), after);
            this.addDiaganals(diags, ForgeDirectionOffsets.forDirCopy((ForgeDirection)this.face.getOpposite()), after);
            if (!before.equals(after)) {
                this.clearLightNodes();
                for (BlockCoord entry : after) {
                    this.worldObj.setBlock(entry.x, entry.y, entry.z, (Block)EnderIO.blockLightNode);
                    TileEntity te = this.worldObj.getTileEntity(entry.x, entry.y, entry.z);
                    if (!(te instanceof TileLightNode)) continue;
                    TileLightNode ln = (TileLightNode)te;
                    ln.parentX = this.xCoord;
                    ln.parentY = this.yCoord;
                    ln.parentZ = this.zCoord;
                    this.lightNodes.add(ln);
                }
            } else {
                this.init = false;
            }
        }
        finally {
            this.updatingLightNodes = false;
        }
    }

    private void addDiaganals(Vector3d[] diags, Vector3d trans, Set<BlockCoord> result) {
        Vector3d offset = new Vector3d();
        offset.set(diags[0]);
        offset.add(diags[1]);
        this.addNodeInDirection(offset.add(trans), result);
        offset.set(diags[0]);
        offset.sub(diags[1]);
        this.addNodeInDirection(offset.add(trans), result);
        offset.set(diags[0]);
        offset.negate();
        offset.add(diags[1]);
        this.addNodeInDirection(offset.add(trans), result);
        offset.set(diags[0]);
        offset.negate();
        offset.sub(diags[1]);
        this.addNodeInDirection(offset.add(trans), result);
    }

    private void addNodeInDirection(Vector3d offset, Set<BlockCoord> result) {
        boolean isAir = this.isAir(offset);
        boolean isTransp = this.isTranparent(offset);
        if (isAir || isTransp) {
            offset.scale(2.0);
            if (this.isAir(offset)) {
                this.addLightNode(offset, result);
            } else if (isAir) {
                offset.scale(0.5);
                this.addLightNode(offset, result);
            }
        }
    }

    private boolean isLightNode(Vector3d offset) {
        return this.worldObj.getBlock(this.xCoord + (int)offset.x, this.yCoord + (int)offset.y, this.zCoord + (int)offset.z) == EnderIO.blockLightNode;
    }

    private void clearLightNodes() {
        if (this.lightNodes != null) {
            for (TileLightNode ln : this.lightNodes) {
                if (this.worldObj.getBlock(ln.xCoord, ln.yCoord, ln.zCoord) != EnderIO.blockLightNode) continue;
                this.worldObj.setBlockToAir(ln.xCoord, ln.yCoord, ln.zCoord);
            }
            this.lightNodes.clear();
        }
    }

    private void addLightNode(Vector3d offset, Set<BlockCoord> result) {
        int x = this.xCoord + (int)offset.x;
        int y = this.yCoord + (int)offset.y;
        int z = this.zCoord + (int)offset.z;
        if (this.isLightNode(offset)) {
            TileLightNode te = (TileLightNode)this.worldObj.getTileEntity(x, y, z);
            if (te.parentX != this.xCoord || te.parentY != this.yCoord || te.parentZ != this.zCoord) {
                return;
            }
        }
        result.add(new BlockCoord(x, y, z));
    }

    private boolean isRailcraftException(Block id) {
        String className = id.getClass().getName();
        return className.equals("mods.railcraft.common.blocks.machine.BlockMachine");
    }

    private boolean isTranparent(Vector3d offset) {
        Block id = this.worldObj.getBlock(this.xCoord + (int)offset.x, this.yCoord + (int)offset.y, this.zCoord + (int)offset.z);
        if (this.isRailcraftException(id)) {
            return false;
        }
        return this.worldObj.getBlockLightOpacity(this.xCoord + (int)offset.x, this.yCoord + (int)offset.y, this.zCoord + (int)offset.z) == 0;
    }

    private boolean isAir(Vector3d offset) {
        return this.worldObj.isAirBlock(this.xCoord + (int)offset.x, this.yCoord + (int)offset.y, this.zCoord + (int)offset.z) || this.isLightNode(offset);
    }

    public void readCustomNBT(NBTTagCompound root) {
        this.face = ForgeDirection.values()[root.getShort("face")];
        this.isInvereted = root.getBoolean("isInverted");
        this.requiresPower = root.getBoolean("requiresPower");
        this.setWireless(root.getBoolean("isWireless"));
        if (root.hasKey("storedEnergy")) {
            float se = root.getFloat("storedEnergy");
            this.energyStoredRF = (int)(se * 10.0f);
        } else {
            this.energyStoredRF = root.getInteger("storedEnergyRF");
        }
        this.lightNodeCoords = root.getIntArray("lightNodes");
    }

    public void writeCustomNBT(NBTTagCompound root) {
        root.setShort("face", (short)this.face.ordinal());
        root.setInteger("storedEnergyRF", this.energyStoredRF);
        root.setBoolean("isInverted", this.isInvereted);
        root.setBoolean("requiresPower", this.requiresPower);
        root.setBoolean("isWireless", this.isWireless());
        if (this.lightNodes != null) {
            int[] lnLoc = new int[this.lightNodes.size() * 3];
            int index = 0;
            for (TileLightNode ln : this.lightNodes) {
                lnLoc[index++] = ln.xCoord;
                lnLoc[index++] = ln.yCoord;
                lnLoc[index++] = ln.zCoord;
            }
            root.setIntArray("lightNodes", lnLoc);
        }
    }

    public boolean hasPower() {
        return this.energyStoredRF >= 1;
    }

    @Override
    public int receiveEnergy(ForgeDirection from, int maxReceive, boolean simulate) {
        if (!this.requiresPower) {
            return 0;
        }
        if (this.energyStoredRF == 0) {
            this.init = true;
        }
        return PowerHandlerUtil.recieveInternal(this, maxReceive, from, simulate);
    }

    @Override
    public boolean canConnectEnergy(ForgeDirection from) {
        return this.requiresPower;
    }

    @Override
    public int getEnergyStored(ForgeDirection from) {
        return this.getEnergyStored();
    }

    @Override
    public int getMaxEnergyStored(ForgeDirection from) {
        return this.getMaxEnergyStored();
    }

    @Override
    public int getMaxEnergyRecieved(ForgeDirection dir) {
        if (!this.requiresPower) {
            return 0;
        }
        return Capacitors.BASIC_CAPACITOR.capacitor.getMaxEnergyReceived();
    }

    @Override
    public int getEnergyStored() {
        if (!this.requiresPower) {
            return 0;
        }
        return this.energyStoredRF;
    }

    @Override
    public int getMaxEnergyStored() {
        if (!this.requiresPower) {
            return 0;
        }
        return 100;
    }

    @Override
    public void setEnergyStored(int stored) {
        this.energyStoredRF = stored;
    }

    @Override
    public boolean displayPower() {
        return this.isRequiresPower();
    }
}

