/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.machine.light;

import com.enderio.core.client.render.BoundingBox;
import com.enderio.core.client.render.CubeRenderer;
import com.enderio.core.client.render.RenderUtil;
import cpw.mods.fml.client.registry.ISimpleBlockRenderingHandler;
import crazypants.enderio.machine.light.BlockElectricLight;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;

public class ElectricLightRenderer
implements ISimpleBlockRenderingHandler {
    public void renderInventoryBlock(Block block, int metadata, int modelID, RenderBlocks renderer) {
        BoundingBox bb = new BoundingBox(0.0, 0.0, 0.0, 1.0, 0.2, 1.0);
        boolean doDraw = false;
        Tessellator.instance.startDrawingQuads();
        IIcon[] textures = RenderUtil.getBlockTextures((Block)block, (int)metadata);
        CubeRenderer.render((BoundingBox)bb, (IIcon[])textures, null, null);
        Tessellator.instance.draw();
    }

    public boolean renderWorldBlock(IBlockAccess world, int x, int y, int z, Block block, int modelId, RenderBlocks renderer) {
        block.setBlockBoundsBasedOnState(world, x, y, z);
        BoundingBox bb = new BoundingBox(block.getBlockBoundsMinX(), block.getBlockBoundsMinY(), block.getBlockBoundsMinZ(), block.getBlockBoundsMaxX(), block.getBlockBoundsMaxY(), block.getBlockBoundsMaxZ());
        bb = bb.translate((float)x, (float)y, (float)z);
        RenderUtil.setTesselatorBrightness((IBlockAccess)world, (int)x, (int)y, (int)z);
        IIcon[] textures = RenderUtil.getBlockTextures((IBlockAccess)world, (int)x, (int)y, (int)z);
        if (renderer.hasOverrideBlockTexture()) {
            CubeRenderer.render((BoundingBox)bb, (IIcon)renderer.overrideBlockTexture);
        } else {
            CubeRenderer.render((BoundingBox)bb, (IIcon[])textures, null, null);
        }
        return true;
    }

    public int getRenderId() {
        return BlockElectricLight.renderId;
    }

    public boolean shouldRender3DInInventory(int modelId) {
        return true;
    }
}

