/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.machine.light;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import crazypants.enderio.BlockEio;
import crazypants.enderio.ModObject;
import crazypants.enderio.machine.light.TileLightNode;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlockLightNode
extends BlockEio {
    public static BlockLightNode create() {
        BlockLightNode result = new BlockLightNode();
        result.init();
        return result;
    }

    public BlockLightNode() {
        super(ModObject.blockLightNode.unlocalisedName, TileLightNode.class, Material.air);
        this.setCreativeTab(null);
        this.setBlockBounds(0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f);
        this.setTickRandomly(true);
    }

    public boolean renderAsNormalBlock() {
        return false;
    }

    public boolean isOpaqueCube() {
        return false;
    }

    public boolean isBlockSolid(IBlockAccess iblockaccess, int x, int y, int z, int l) {
        return false;
    }

    public AxisAlignedBB getCollisionBoundingBoxFromPool(World world, int x, int y, int z) {
        return null;
    }

    public boolean isReplaceable(IBlockAccess world, int x, int y, int z) {
        return true;
    }

    public void breakBlock(World world, int x, int y, int z, Block par5, int par6) {
        TileLightNode te = (TileLightNode)world.getTileEntity(x, y, z);
        if (te != null) {
            te.onBlockRemoved();
        }
    }

    public int getLightValue(IBlockAccess world, int x, int y, int z) {
        return world.getBlockMetadata(x, y, z) > 0 ? 15 : 0;
    }

    public void onNeighborBlockChange(World world, int x, int y, int z, Block par5) {
        TileLightNode te = (TileLightNode)world.getTileEntity(x, y, z);
        if (te != null) {
            te.onNeighbourChanged();
        }
    }

    public void updateTick(World world, int x, int y, int z, Random r) {
        TileLightNode te = (TileLightNode)world.getTileEntity(x, y, z);
        if (te != null) {
            te.checkParent();
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void registerBlockIcons(IIconRegister iIconRegister) {
        this.blockIcon = iIconRegister.registerIcon("enderio:blockElectricLightFace");
    }

    public int quantityDropped(Random p_149745_1_) {
        return 0;
    }
}

