/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.machine.killera;

import com.enderio.core.api.common.util.ITankAccess;
import com.enderio.core.client.render.BoundingBox;
import com.enderio.core.common.util.BlockCoord;
import com.enderio.core.common.util.FluidUtil;
import com.enderio.core.common.util.ForgeDirectionOffsets;
import com.enderio.core.common.vecmath.Vector3d;
import com.google.common.collect.Sets;
import com.mojang.authlib.GameProfile;
import cpw.mods.fml.common.eventhandler.Event;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import crazypants.enderio.EnderIO;
import crazypants.enderio.ModObject;
import crazypants.enderio.config.Config;
import crazypants.enderio.machine.AbstractMachineEntity;
import crazypants.enderio.machine.FakePlayerEIO;
import crazypants.enderio.machine.SlotDefinition;
import crazypants.enderio.machine.generator.zombie.IHasNutrientTank;
import crazypants.enderio.machine.generator.zombie.PacketNutrientTank;
import crazypants.enderio.machine.killera.PacketSwing;
import crazypants.enderio.machine.wireless.WirelessChargedLocation;
import crazypants.enderio.network.PacketHandler;
import crazypants.enderio.tool.SmartTank;
import crazypants.enderio.xp.ExperienceContainer;
import crazypants.enderio.xp.IHaveExperience;
import crazypants.enderio.xp.PacketExperianceContainer;
import crazypants.enderio.xp.XpUtil;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import net.minecraft.command.IEntitySelector;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityXPOrb;
import net.minecraft.entity.monster.EntityZombie;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemSword;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.Vec3;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.event.entity.living.ZombieEvent;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidHandler;

public class TileKillerJoe
extends AbstractMachineEntity
implements IFluidHandler,
IEntitySelector,
IHaveExperience,
ITankAccess,
IHasNutrientTank {
    public static ZombieCache zCache;
    private static final int IO_MB_TICK = 250;
    protected AxisAlignedBB killBounds;
    private int[] frontFaceAndSides;
    protected AxisAlignedBB hooverBounds;
    protected FakePlayer attackera;
    protected WirelessChargedLocation chargedLocation;
    final SmartTank fuelTank = new SmartTank(EnderIO.fluidNutrientDistillation, 2000);
    int lastFluidLevelUpdate;
    private boolean tanksDirty;
    private boolean isSwingInProgress;
    private int swingProgressInt;
    private float swingProgress;
    private float prevSwingProgress;
    private final ExperienceContainer xpCon = new ExperienceContainer(XpUtil.getExperienceForLevel(Config.killerJoeMaxXpLevel));
    private boolean hadSword;
    private static final int[] slots;
    private static final double[][] faceMidPoints;
    private static final UUID uuid;
    private static final GameProfile DUMMY_PROFILE;

    public TileKillerJoe() {
        super(new SlotDefinition(1, 0, 0));
        if (zCache == null) {
            zCache = new ZombieCache();
            MinecraftForge.EVENT_BUS.register((Object)zCache);
        }
    }

    @Override
    public String getMachineName() {
        return ModObject.blockKillerJoe.unlocalisedName;
    }

    @Override
    protected boolean isMachineItemValidForSlot(int i, ItemStack itemstack) {
        if (itemstack == null) {
            return false;
        }
        return itemstack.getItem() instanceof ItemSword;
    }

    @Override
    public boolean isActive() {
        return false;
    }

    @Override
    public void doUpdate() {
        this.updateArmSwingProgress();
        this.hooverXP();
        if (!this.worldObj.isRemote) {
            this.getAttackera().onUpdate();
            if (this.inventory[0] != null != this.hadSword) {
                this.worldObj.markBlockForUpdate(this.xCoord, this.yCoord, this.zCoord);
                this.hadSword = this.inventory[0] != null;
            }
        }
        super.doUpdate();
    }

    @Override
    public ExperienceContainer getContainer() {
        return this.xpCon;
    }

    @Override
    public int[] getAccessibleSlotsFromSide(int var1) {
        return slots;
    }

    @Override
    public boolean canExtractItem(int slot, ItemStack itemstack, int side) {
        if (this.isSideDisabled(side)) {
            return false;
        }
        if (this.inventory[slot] == null || this.inventory[slot].stackSize < itemstack.stackSize) {
            return false;
        }
        return itemstack.getItem() == this.inventory[slot].getItem();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean processTasks(boolean redstoneCheckPassed) {
        if (!this.shouldDoWorkThisTick(10)) {
            return false;
        }
        if (this.tanksDirty) {
            PacketHandler.sendToAllAround((IMessage)new PacketNutrientTank(this), (TileEntity)this);
            this.tanksDirty = false;
        }
        if (this.xpCon.isDirty()) {
            PacketHandler.sendToAllAround((IMessage)new PacketExperianceContainer((TileEntity)this), (TileEntity)this);
            this.xpCon.setDirty(false);
        }
        if (!redstoneCheckPassed) {
            return false;
        }
        if (this.fuelTank.getFluidAmount() < this.getActivationAmount()) {
            return false;
        }
        if (this.getStackInSlot(0) == null) {
            return false;
        }
        List entsInBounds = this.worldObj.getEntitiesWithinAABB(EntityLivingBase.class, this.getKillBounds());
        if (!entsInBounds.isEmpty()) {
            for (EntityLivingBase ent : entsInBounds) {
                if (ent.isDead || ent.deathTime > 0 || ent.isEntityInvulnerable() || ent.hurtResistantTime != 0 || ent instanceof EntityPlayer && ((EntityPlayer)ent).capabilities.disableDamage) continue;
                boolean togglePvp = false;
                if (ent instanceof EntityPlayer && !MinecraftServer.getServer().isPVPEnabled()) {
                    if (Config.killerPvPoffDisablesSwing) continue;
                    if (Config.killerPvPoffIsIgnored) {
                        togglePvp = true;
                    }
                }
                if (Config.killerJoeMustSee && !this.canJoeSee(ent)) continue;
                if (ent instanceof EntityZombie) {
                    zCache.cache.add((EntityZombie)ent);
                }
                FakePlayer fakee = this.getAttackera();
                fakee.setCurrentItemOrArmor(0, this.getStackInSlot(0));
                try {
                    if (togglePvp) {
                        MinecraftServer.getServer().setAllowPvp(true);
                    }
                    fakee.attackTargetEntityWithCurrentItem((Entity)ent);
                }
                finally {
                    if (togglePvp) {
                        MinecraftServer.getServer().setAllowPvp(false);
                    }
                }
                this.useNutrient();
                this.swingWeapon();
                if (this.getStackInSlot((int)0).stackSize <= 0 || fakee.getCurrentEquippedItem() == null) {
                    this.setInventorySlotContents(0, null);
                }
                return false;
            }
        }
        return false;
    }

    int getActivationAmount() {
        return (int)((float)this.fuelTank.getCapacity() * 0.7f);
    }

    private boolean canJoeSee(EntityLivingBase ent) {
        Vec3 entPos = Vec3.createVectorHelper((double)ent.posX, (double)(ent.posY + (double)ent.getEyeHeight()), (double)ent.posZ);
        for (int facing : this.frontFaceAndSides) {
            if (this.worldObj.rayTraceBlocks(Vec3.createVectorHelper((double)((double)this.xCoord + faceMidPoints[facing][0]), (double)((double)this.yCoord + faceMidPoints[facing][1]), (double)((double)this.zCoord + faceMidPoints[facing][2])), entPos) != null) continue;
            return true;
        }
        return false;
    }

    @Override
    public void setFacing(short facing) {
        super.setFacing(facing);
        this.frontFaceAndSides = new int[]{this.facing, ForgeDirection.ROTATION_MATRIX[0][this.facing], ForgeDirection.ROTATION_MATRIX[1][this.facing]};
    }

    public ExperienceContainer getXpContainer() {
        return this.xpCon;
    }

    private void hooverXP() {
        double maxDist = Config.killerJoeHooverXpLength;
        List xp = this.worldObj.selectEntitiesWithinAABB(EntityXPOrb.class, this.getHooverBounds(), (IEntitySelector)this);
        for (EntityXPOrb entity : xp) {
            double xDist = (double)this.xCoord + 0.5 - entity.posX;
            double yDist = (double)this.yCoord + 0.5 - entity.posY;
            double zDist = (double)this.zCoord + 0.5 - entity.posZ;
            double totalDistance = Math.sqrt(xDist * xDist + yDist * yDist + zDist * zDist);
            if (totalDistance < 1.5) {
                this.hooverXP(entity);
                continue;
            }
            double d = 1.0 - Math.max(0.1, totalDistance) / maxDist;
            double speed = 0.01 + d * 0.02;
            entity.motionX += xDist / totalDistance * speed;
            entity.motionZ += zDist / totalDistance * speed;
            entity.motionY += yDist / totalDistance * speed;
            if (!(yDist > 0.5)) continue;
            entity.motionY = 0.12;
        }
    }

    private void hooverXP(EntityXPOrb entity) {
        if (!this.worldObj.isRemote && !entity.isDead) {
            this.xpCon.addExperience(entity.getXpValue());
            entity.setDead();
        }
    }

    public boolean isEntityApplicable(Entity arg0) {
        return true;
    }

    void swingWeapon() {
        if (this.getStackInSlot(0) == null) {
            return;
        }
        if (!this.isSwingInProgress || this.swingProgressInt >= this.getArmSwingAnimationEnd() / 2 || this.swingProgressInt < 0) {
            this.swingProgressInt = -1;
            this.isSwingInProgress = true;
            if (this.worldObj instanceof WorldServer) {
                PacketHandler.sendToAllAround((IMessage)new PacketSwing(this), (TileEntity)this);
            }
        }
    }

    float getSwingProgress(float p_70678_1_) {
        float f1 = this.swingProgress - this.prevSwingProgress;
        if (f1 < 0.0f) {
            f1 += 1.0f;
        }
        return this.prevSwingProgress + f1 * p_70678_1_;
    }

    private void updateArmSwingProgress() {
        this.prevSwingProgress = this.swingProgress;
        int i = this.getArmSwingAnimationEnd();
        if (this.isSwingInProgress) {
            ++this.swingProgressInt;
            if (this.swingProgressInt >= i) {
                this.swingProgressInt = 0;
                this.isSwingInProgress = false;
            }
        } else {
            this.swingProgressInt = 0;
        }
        this.swingProgress = (float)this.swingProgressInt / (float)i;
    }

    private int getArmSwingAnimationEnd() {
        return 6;
    }

    FakePlayer getAttackera() {
        if (this.attackera == null) {
            this.attackera = new Attackera();
        }
        return this.attackera;
    }

    WirelessChargedLocation getChargedLocation() {
        if (this.chargedLocation == null) {
            this.chargedLocation = new WirelessChargedLocation((TileEntity)this);
        }
        return this.chargedLocation;
    }

    private AxisAlignedBB getKillBounds() {
        if (this.killBounds == null) {
            BoundingBox bb = new BoundingBox(this.getLocation());
            Vector3d min = bb.getMin();
            Vector3d max = bb.getMax();
            max.y += Config.killerJoeAttackHeight;
            min.y -= Config.killerJoeAttackHeight;
            ForgeDirection facingDir = ForgeDirection.getOrientation((int)this.facing);
            if (ForgeDirectionOffsets.isPositiveOffset((ForgeDirection)facingDir)) {
                max.add(ForgeDirectionOffsets.offsetScaled((ForgeDirection)facingDir, (double)Config.killerJoeAttackLength));
                min.add(ForgeDirectionOffsets.forDir((ForgeDirection)facingDir));
            } else {
                min.add(ForgeDirectionOffsets.offsetScaled((ForgeDirection)facingDir, (double)Config.killerJoeAttackLength));
                max.add(ForgeDirectionOffsets.forDir((ForgeDirection)facingDir));
            }
            if (facingDir.offsetX == 0) {
                min.x -= Config.killerJoeAttackWidth;
                max.x += Config.killerJoeAttackWidth;
            } else {
                min.z -= Config.killerJoeAttackWidth;
                max.z += Config.killerJoeAttackWidth;
            }
            this.killBounds = AxisAlignedBB.getBoundingBox((double)min.x, (double)min.y, (double)min.z, (double)max.x, (double)max.y, (double)max.z);
        }
        return this.killBounds;
    }

    private AxisAlignedBB getHooverBounds() {
        if (this.hooverBounds == null) {
            BoundingBox bb = new BoundingBox(this.getLocation());
            Vector3d min = bb.getMin();
            Vector3d max = bb.getMax();
            max.y += Config.killerJoeAttackHeight;
            min.y -= Config.killerJoeAttackHeight;
            ForgeDirection facingDir = ForgeDirection.getOrientation((int)this.facing);
            if (ForgeDirectionOffsets.isPositiveOffset((ForgeDirection)facingDir)) {
                max.add(ForgeDirectionOffsets.offsetScaled((ForgeDirection)facingDir, (double)Config.killerJoeHooverXpLength));
                min.add(ForgeDirectionOffsets.forDir((ForgeDirection)facingDir));
            } else {
                min.add(ForgeDirectionOffsets.offsetScaled((ForgeDirection)facingDir, (double)Config.killerJoeHooverXpLength));
                max.add(ForgeDirectionOffsets.forDir((ForgeDirection)facingDir));
            }
            if (facingDir.offsetX == 0) {
                min.x -= Config.killerJoeHooverXpWidth * 2.0;
                max.x += Config.killerJoeHooverXpWidth * 2.0;
            } else {
                min.z -= Config.killerJoeHooverXpWidth * 2.0;
                max.z += Config.killerJoeHooverXpWidth * 2.0;
            }
            this.hooverBounds = AxisAlignedBB.getBoundingBox((double)min.x, (double)min.y, (double)min.z, (double)max.x, (double)max.y, (double)max.z);
        }
        return this.hooverBounds;
    }

    private void useNutrient() {
        this.fuelTank.drain(Config.killerJoeNutrientUsePerAttackMb, true);
        this.tanksDirty = true;
    }

    @Override
    protected boolean doPull(ForgeDirection dir) {
        boolean res = super.doPull(dir);
        FluidUtil.doPull((IFluidHandler)this, (ForgeDirection)dir, (int)250);
        return res;
    }

    @Override
    protected boolean doPush(ForgeDirection dir) {
        int drained;
        FluidStack canDrain;
        boolean res = super.doPush(dir);
        BlockCoord loc = this.getLocation().getLocation(dir);
        IFluidHandler target = FluidUtil.getFluidHandler((IBlockAccess)this.worldObj, (BlockCoord)loc);
        if (target != null && (canDrain = this.drain(dir, 250, false)) != null && canDrain.amount > 0 && (drained = target.fill(dir.getOpposite(), canDrain, true)) > 0) {
            this.drain(dir, drained, true);
        }
        return res;
    }

    public int fill(ForgeDirection from, FluidStack resource, boolean doFill) {
        int res = this.fuelTank.fill(resource, doFill);
        if (res > 0 && doFill) {
            this.tanksDirty = true;
        }
        return res;
    }

    public boolean canFill(ForgeDirection from, Fluid fluid) {
        return this.fuelTank.canFill(fluid);
    }

    public FluidTankInfo[] getTankInfo(ForgeDirection from) {
        return new FluidTankInfo[]{this.fuelTank.getInfo()};
    }

    public FluidStack drain(ForgeDirection from, FluidStack resource, boolean doDrain) {
        return this.xpCon.drain(from, resource, doDrain);
    }

    public FluidStack drain(ForgeDirection from, int maxDrain, boolean doDrain) {
        return this.xpCon.drain(from, maxDrain, doDrain);
    }

    public boolean canDrain(ForgeDirection from, Fluid fluid) {
        return this.xpCon.canDrain(from, fluid);
    }

    @Override
    public void readCommon(NBTTagCompound nbtRoot) {
        super.readCommon(nbtRoot);
        this.fuelTank.readCommon("fuelTank", nbtRoot);
        this.xpCon.readFromNBT(nbtRoot);
    }

    @Override
    public void writeCommon(NBTTagCompound nbtRoot) {
        super.writeCommon(nbtRoot);
        this.fuelTank.writeCommon("fuelTank", nbtRoot);
        this.xpCon.writeToNBT(nbtRoot);
    }

    public FluidTank getInputTank(FluidStack forFluidType) {
        if (forFluidType != null && forFluidType.getFluid() == EnderIO.fluidNutrientDistillation) {
            return this.fuelTank;
        }
        return null;
    }

    public FluidTank[] getOutputTanks() {
        return new FluidTank[]{this.xpCon};
    }

    public void setTanksDirty() {
        this.tanksDirty = true;
    }

    @Override
    public SmartTank getNutrientTank() {
        return this.fuelTank;
    }

    static {
        slots = new int[1];
        faceMidPoints = new double[][]{{0.5, 0.0, 0.5}, {0.5, 1.0, 0.5}, {0.5, 0.5, 0.0}, {0.5, 0.5, 1.0}, {0.0, 0.5, 0.5}, {1.0, 0.5, 0.5}};
        uuid = UUID.fromString("3baa66fa-a69a-11e4-89d3-123b93f75cba");
        DUMMY_PROFILE = new GameProfile(uuid, "[EioKillera]");
    }

    private class Attackera
    extends FakePlayerEIO {
        ItemStack prevWeapon;

        public Attackera() {
            super(TileKillerJoe.this.getWorldObj(), TileKillerJoe.this.getLocation(), DUMMY_PROFILE);
        }

        public void onUpdate() {
            this.setCurrentItemOrArmor(0, TileKillerJoe.this.getStackInSlot(0));
            ItemStack prev = this.prevWeapon;
            ItemStack cur = this.getCurrentEquippedItem();
            if (!ItemStack.areItemStacksEqual((ItemStack)cur, (ItemStack)prev)) {
                if (prev != null) {
                    this.getAttributeMap().removeAttributeModifiers(prev.getAttributeModifiers());
                }
                if (cur != null) {
                    this.getAttributeMap().applyAttributeModifiers(cur.getAttributeModifiers());
                }
                this.prevWeapon = cur == null ? null : cur.copy();
            }
            TileKillerJoe.this.getChargedLocation().chargeItems(this.inventory.mainInventory);
        }
    }

    public static class ZombieCache {
        private Set<EntityZombie> cache = Sets.newHashSet();

        @SubscribeEvent
        public void onSummonAid(ZombieEvent.SummonAidEvent event) {
            if (!this.cache.isEmpty() && this.cache.remove(event.getSummoner())) {
                event.setResult(Event.Result.DENY);
            }
        }
    }
}

