/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.machine.invpanel.server;

import crazypants.enderio.conduit.item.NetworkedInventory;
import crazypants.enderio.machine.invpanel.server.AbstractInventory;
import crazypants.enderio.machine.invpanel.server.InventoryDatabaseServer;
import crazypants.enderio.machine.invpanel.server.ItemEntry;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;

class NormalInventory
extends AbstractInventory {
    final NetworkedInventory ni;

    NormalInventory(NetworkedInventory ni) {
        this.ni = ni;
    }

    @Override
    int scanInventory(InventoryDatabaseServer db) {
        int side;
        ISidedInventory inv = this.ni.getInventoryRecheck();
        int[] slotIndices = inv.getAccessibleSlotsFromSide(side = this.ni.getInventorySide());
        if (slotIndices == null || slotIndices.length == 0) {
            this.setEmpty(db);
            return 0;
        }
        int count = slotIndices.length;
        if (count != this.slotKeys.length) {
            this.reset(db, count);
        }
        for (int slot = 0; slot < count; ++slot) {
            int invSlot = slotIndices[slot];
            ItemStack stack = inv.getStackInSlot(invSlot);
            if (stack != null && !inv.canExtractItem(invSlot, stack, side)) {
                stack = null;
            }
            this.updateSlot(db, slot, stack);
        }
        return count;
    }

    @Override
    public int extractItem(InventoryDatabaseServer db, ItemEntry entry, int slot, int count) {
        int side;
        ISidedInventory inv = this.ni.getInventoryRecheck();
        int[] slotIndices = inv.getAccessibleSlotsFromSide(side = this.ni.getInventorySide());
        if (slotIndices == null || slot >= slotIndices.length) {
            return 0;
        }
        int invSlot = slotIndices[slot];
        ItemStack stack = inv.getStackInSlot(invSlot);
        if (stack == null || !inv.canExtractItem(invSlot, stack, side)) {
            return 0;
        }
        if (db.lookupItem(stack, entry, false) != entry) {
            return 0;
        }
        int remaining = stack.stackSize;
        if (count > remaining) {
            count = remaining;
        }
        this.ni.itemExtracted(invSlot, count);
        this.updateCount(db, slot, entry, remaining -= count);
        return count;
    }
}

