/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.machine.invpanel.client;

import codechicken.nei.OffsetPositioner;
import codechicken.nei.PositionedStack;
import codechicken.nei.api.DefaultOverlayRenderer;
import codechicken.nei.api.IOverlayHandler;
import codechicken.nei.api.IStackPositioner;
import codechicken.nei.recipe.IRecipeHandler;
import crazypants.enderio.machine.invpanel.GuiInventoryPanel;
import crazypants.enderio.machine.invpanel.InventoryPanelContainer;
import crazypants.enderio.machine.invpanel.client.CraftingHelperNEI;
import java.util.List;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;

public class InventoryPanelNEIOverlayHandler
implements IOverlayHandler {
    public static final int NEI_OFFSET_X = 25;
    public static final int NEI_OFFSET_Y = 6;
    private static final int CRAFTING_GRID_OFFSET_X = 6;
    private static final int CRAFTING_GRID_OFFSET_Y = 10;
    public static final IStackPositioner positioner = new OffsetPositioner(6, 10);

    public void overlayRecipe(GuiContainer gui, IRecipeHandler recipe, int recipeIndex, boolean shift) {
        ItemStack[][] slots;
        GuiInventoryPanel guiInvPanel = (GuiInventoryPanel)gui;
        List ingredients = recipe.getIngredientStacks(recipeIndex);
        if (shift) {
            shift = guiInvPanel.getContainer().clearCraftingGrid();
        }
        if ((slots = this.mapSlots(ingredients, guiInvPanel.getContainer())) != null) {
            CraftingHelperNEI helper = new CraftingHelperNEI(slots);
            helper.overlayRenderer = new DefaultOverlayRenderer(ingredients, positioner);
            guiInvPanel.setCraftingHelper(helper);
            if (shift) {
                helper.refill(guiInvPanel, 64);
            }
        } else {
            guiInvPanel.setCraftingHelper(null);
        }
    }

    private ItemStack[][] mapSlots(List<PositionedStack> ingredients, InventoryPanelContainer c) {
        ItemStack[][] slots = new ItemStack[9][];
        List<Slot> craftingGrid = c.getCraftingGridSlots();
        int found = 0;
        block0: for (PositionedStack pstack : ingredients) {
            for (int idx = 0; idx < 9; ++idx) {
                Slot slot = craftingGrid.get(idx);
                if (slot.xDisplayPosition != pstack.relx + 6 || slot.yDisplayPosition != pstack.rely + 10) continue;
                slots[idx] = pstack.items;
                ++found;
                continue block0;
            }
        }
        if (found != ingredients.size()) {
            return null;
        }
        return slots;
    }
}

