/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.machine.invpanel;

import com.enderio.core.common.network.NetworkUtil;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.network.simpleimpl.IMessageHandler;
import cpw.mods.fml.common.network.simpleimpl.MessageContext;
import crazypants.enderio.machine.invpanel.InventoryPanelContainer;
import crazypants.enderio.machine.invpanel.StoredCraftingRecipe;
import io.netty.buffer.ByteBuf;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTTagCompound;

public class PacketStoredCraftingRecipe
implements IMessage,
IMessageHandler<PacketStoredCraftingRecipe, IMessage> {
    public static final int ACTION_ADD = 0;
    public static final int ACTION_DELETE = 1;
    private int action;
    private int index;
    private StoredCraftingRecipe recipe;

    public PacketStoredCraftingRecipe() {
    }

    public PacketStoredCraftingRecipe(int action, int index, StoredCraftingRecipe recipe) {
        this.action = action;
        this.index = index;
        this.recipe = recipe;
    }

    public void fromBytes(ByteBuf buf) {
        this.action = buf.readUnsignedByte();
        this.index = buf.readUnsignedByte();
        NBTTagCompound nbt = NetworkUtil.readNBTTagCompound((ByteBuf)buf);
        if (nbt != null) {
            this.recipe = new StoredCraftingRecipe();
            if (!this.recipe.readFromNBT(nbt)) {
                this.recipe = null;
            }
        }
    }

    public void toBytes(ByteBuf buf) {
        buf.writeByte(this.action);
        buf.writeByte(this.index);
        NBTTagCompound nbt = null;
        if (this.recipe != null) {
            nbt = new NBTTagCompound();
            this.recipe.writeToNBT(nbt);
        }
        NetworkUtil.writeNBTTagCompound(nbt, (ByteBuf)buf);
    }

    public IMessage onMessage(PacketStoredCraftingRecipe message, MessageContext ctx) {
        EntityPlayerMP player = ctx.getServerHandler().playerEntity;
        if (player.openContainer instanceof InventoryPanelContainer) {
            InventoryPanelContainer ipc = (InventoryPanelContainer)player.openContainer;
            switch (message.action) {
                case 0: {
                    if (message.recipe == null) break;
                    ipc.getInventoryPanel().addStoredCraftingRecipe(message.recipe);
                    break;
                }
                case 1: {
                    ipc.getInventoryPanel().removeStoredCraftingRecipe(message.index);
                }
            }
        }
        return null;
    }
}

