/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.machine.invpanel;

import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.network.simpleimpl.IMessageHandler;
import cpw.mods.fml.common.network.simpleimpl.MessageContext;
import crazypants.enderio.machine.invpanel.InventoryPanelContainer;
import io.netty.buffer.ByteBuf;
import net.minecraft.entity.player.EntityPlayerMP;

public class PacketMoveItems
implements IMessage,
IMessageHandler<PacketMoveItems, IMessage> {
    private int fromSlot;
    private int toSlotStart;
    private int toSlotEnd;
    private int amount;

    public PacketMoveItems(int fromSlot, int toSlotStart, int toSlotEnd, int amount) {
        this.fromSlot = fromSlot;
        this.toSlotStart = toSlotStart;
        this.toSlotEnd = toSlotEnd;
        this.amount = amount;
    }

    public PacketMoveItems() {
    }

    public void fromBytes(ByteBuf bb) {
        this.fromSlot = bb.readShort();
        this.toSlotStart = bb.readShort();
        this.toSlotEnd = bb.readShort();
        this.amount = bb.readShort();
    }

    public void toBytes(ByteBuf bb) {
        bb.writeShort(this.fromSlot);
        bb.writeShort(this.toSlotStart);
        bb.writeShort(this.toSlotEnd);
        bb.writeShort(this.amount);
    }

    public IMessage onMessage(PacketMoveItems message, MessageContext ctx) {
        EntityPlayerMP player = ctx.getServerHandler().playerEntity;
        if (player.openContainer instanceof InventoryPanelContainer) {
            InventoryPanelContainer ipc = (InventoryPanelContainer)player.openContainer;
            ipc.executeMoveItems(message.fromSlot, message.toSlotStart, message.toSlotEnd, message.amount);
        }
        return null;
    }
}

