/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.machine.invpanel;

import codechicken.nei.LayoutManager;
import com.enderio.core.api.client.gui.IGuiScreen;
import com.enderio.core.api.client.render.IWidgetIcon;
import com.enderio.core.client.gui.button.IconButton;
import com.enderio.core.client.gui.button.MultiIconButton;
import com.enderio.core.client.gui.button.ToggleButton;
import com.enderio.core.client.gui.widget.GhostSlot;
import com.enderio.core.client.gui.widget.GuiToolTip;
import com.enderio.core.client.gui.widget.TextFieldEnder;
import com.enderio.core.client.gui.widget.VScrollbar;
import com.enderio.core.client.handlers.SpecialTooltipHandler;
import com.enderio.core.client.render.EnderWidget;
import com.enderio.core.client.render.RenderUtil;
import com.enderio.core.common.util.ItemUtil;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import crazypants.enderio.EnderIO;
import crazypants.enderio.config.Config;
import crazypants.enderio.fluid.Fluids;
import crazypants.enderio.gui.IconEIO;
import crazypants.enderio.machine.gui.GuiMachineBase;
import crazypants.enderio.machine.invpanel.InventoryPanelContainer;
import crazypants.enderio.machine.invpanel.PacketFetchItem;
import crazypants.enderio.machine.invpanel.StoredCraftingRecipe;
import crazypants.enderio.machine.invpanel.TileInventoryPanel;
import crazypants.enderio.machine.invpanel.client.CraftingHelper;
import crazypants.enderio.machine.invpanel.client.DatabaseView;
import crazypants.enderio.machine.invpanel.client.InventoryDatabaseClient;
import crazypants.enderio.machine.invpanel.client.ItemEntry;
import crazypants.enderio.machine.invpanel.client.SortOrder;
import crazypants.enderio.network.PacketHandler;
import crazypants.enderio.tool.SmartTank;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.PositionedSoundRecord;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidTank;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class GuiInventoryPanel
extends GuiMachineBase<TileInventoryPanel> {
    private static final Rectangle inventoryArea = new Rectangle(131, 27, 108, 90);
    private static final Rectangle btnRefill = new Rectangle(109, 32, 20, 20);
    private static final Rectangle btnReturnArea = new Rectangle(30, 72, 90, 8);
    private static final int ID_SORT = 9876;
    private static final int ID_CLEAR = 9877;
    private static final int ID_SYNC = 9878;
    private static final int GHOST_COLUMNS = 6;
    private static final int GHOST_ROWS = 5;
    private final DatabaseView view;
    private final TextFieldEnder tfFilter;
    private final IconButton btnSort;
    private final ToggleButton btnSync;
    private final GuiToolTip ttRefill;
    private final VScrollbar scrollbar;
    private final MultiIconButton btnClear;
    private final GuiToolTip ttSetReceipe;
    private int scrollPos;
    private int ghostSlotTooltipStacksize;
    private final String headerCrafting;
    private final String headerReturn;
    private final String headerStorage;
    private final String headerInventory;
    private final String infoTextFilter;
    private final String infoTextOffline;
    private CraftingHelper craftingHelper;
    private final Rectangle btnAddStoredRecipe = new Rectangle();

    public GuiInventoryPanel(TileInventoryPanel te, Container container) {
        super(te, container, "inventorypanel");
        this.redstoneButton.visible = false;
        this.configB.visible = false;
        for (int y = 0; y < 5; ++y) {
            for (int x = 0; x < 6; ++x) {
                this.ghostSlots.add(new InvSlot(132 + x * 18, 28 + y * 18));
            }
        }
        for (int i = 0; i < 6; ++i) {
            this.ghostSlots.add(new RecipeSlot(i, 7, 7 + i * 20));
        }
        this.view = new DatabaseView();
        int sortMode = te.getGuiSortMode();
        int sortOrderIdx = sortMode >> 1;
        SortOrder[] orders = SortOrder.values();
        if (sortOrderIdx >= 0 && te.getGuiSortMode() < orders.length) {
            this.view.setSortOrder(orders[sortOrderIdx], (sortMode & 1) != 0);
        }
        FontRenderer fr = Minecraft.getMinecraft().fontRenderer;
        this.btnSync = new ToggleButton((IGuiScreen)this, 9878, 257, 46, (IWidgetIcon)IconEIO.CROSS, (IWidgetIcon)IconEIO.TICK);
        this.btnSync.setToolTip(new String[]{EnderIO.lang.localize("gui.inventorypanel.tooltip.sync")});
        this.btnSync.setSelectedToolTip(new String[]{EnderIO.lang.localize("gui.enabled")});
        this.btnSync.setUnselectedToolTip(new String[]{EnderIO.lang.localize("gui.disabled")});
        this.btnSync.setSelected(((TileInventoryPanel)this.getTileEntity()).getGuiSync());
        if (!Loader.isModLoaded((String)"NotEnoughItems")) {
            this.btnSync.enabled = false;
        }
        this.tfFilter = new TextFieldEnder(fr, 132, 11, 106, 10);
        this.tfFilter.setEnableBackgroundDrawing(false);
        this.setText(this.tfFilter, te.getGuiFilterString());
        this.btnSort = new IconButton((IGuiScreen)this, 9876, 257, 27, this.getSortOrderIcon()){

            public boolean mousePressed(Minecraft mc, int x, int y) {
                return this.mousePressedButton(mc, x, y, 0);
            }

            public boolean mousePressedButton(Minecraft mc, int x, int y, int button) {
                if (button <= 1 && super.checkMousePress(mc, x, y)) {
                    GuiInventoryPanel.this.toggleSortOrder(button == 0);
                    return true;
                }
                return false;
            }
        };
        this.scrollbar = new VScrollbar((IGuiScreen)this, 239, 27, 90);
        this.btnClear = new MultiIconButton((IGuiScreen)this, 9877, 89, 60, (IWidgetIcon)EnderWidget.X_BUT, (IWidgetIcon)EnderWidget.X_BUT_PRESSED, (IWidgetIcon)EnderWidget.X_BUT_HOVER);
        this.textFields.add(this.tfFilter);
        this.headerCrafting = EnderIO.lang.localize("gui.inventorypanel.header.crafting");
        this.headerReturn = EnderIO.lang.localize("gui.inventorypanel.header.return");
        this.headerStorage = EnderIO.lang.localize("gui.inventorypanel.header.storage");
        this.headerInventory = EnderIO.lang.localizeExact("container.inventory");
        this.infoTextFilter = EnderIO.lang.localize("gui.inventorypanel.info.filter");
        this.infoTextOffline = EnderIO.lang.localize("gui.inventorypanel.info.offline");
        ArrayList list = new ArrayList();
        SpecialTooltipHandler.addTooltipFromResources(list, (String)"enderio.gui.inventorypanel.tooltip.return.line");
        this.addToolTip(new GuiToolTip(btnReturnArea, list){

            public boolean shouldDraw() {
                return super.shouldDraw() && !((TileInventoryPanel)GuiInventoryPanel.this.getTileEntity()).isExtractionDisabled();
            }
        });
        list.clear();
        SpecialTooltipHandler.addTooltipFromResources(list, (String)"enderio.gui.inventorypanel.tooltip.storage.line");
        this.addToolTip(new GuiToolTip(btnReturnArea, list){

            public boolean shouldDraw() {
                return super.shouldDraw() && ((TileInventoryPanel)GuiInventoryPanel.this.getTileEntity()).isExtractionDisabled();
            }
        });
        list.clear();
        SpecialTooltipHandler.addTooltipFromResources(list, (String)"enderio.gui.inventorypanel.tooltip.filterslot.line");
        this.addToolTip(new GuiToolTip(new Rectangle(257, 7, 16, 16), list){

            public boolean shouldDraw() {
                return !GuiInventoryPanel.this.getContainer().getSlotFilter().getHasStack() && super.shouldDraw();
            }
        });
        list.clear();
        SpecialTooltipHandler.addTooltipFromResources(list, (String)"enderio.gui.inventorypanel.tooltip.refill.line");
        this.ttRefill = new GuiToolTip(btnRefill, list);
        this.ttRefill.setVisible(false);
        this.addToolTip(this.ttRefill);
        list.clear();
        SpecialTooltipHandler.addTooltipFromResources(list, (String)"enderio.gui.inventorypanel.tooltip.setrecipe.line");
        this.ttSetReceipe = new GuiToolTip(btnRefill, list){

            public boolean shouldDraw() {
                return super.shouldDraw() && GuiInventoryPanel.this.getContainer().hasCraftingRecipe();
            }
        };
        this.addToolTip(this.ttSetReceipe);
        list.clear();
        SpecialTooltipHandler.addTooltipFromResources(list, (String)"enderio.gui.inventorypanel.tooltip.clear.line");
        this.btnClear.setToolTip(list.toArray(new String[list.size()]));
        if (!Config.inventoryPanelFree) {
            this.addToolTip(new GuiToolTip(new Rectangle(36, 133, 16, 47), new String[]{""}){

                protected void updateText() {
                    this.text.clear();
                    this.text.add(EnderIO.lang.localize("gui.inventorypanel.tooltip.fuelTank"));
                    this.text.add(Fluids.toCapactityString((IFluidTank)((TileInventoryPanel)((GuiInventoryPanel)GuiInventoryPanel.this).getTileEntity()).fuelTank));
                }
            });
        }
        list.clear();
        SpecialTooltipHandler.addTooltipFromResources(list, (String)"enderio.gui.inventorypanel.tooltip.addrecipe.line");
        this.addToolTip(new GuiToolTip(this.btnAddStoredRecipe, list));
    }

    public void onGuiClosed() {
        int sortMode = this.view.getSortOrder().ordinal() << 1;
        if (this.view.isSortOrderInverted()) {
            sortMode |= 1;
        }
        ((TileInventoryPanel)this.getTileEntity()).setGuiParameter(sortMode, this.tfFilter.getText(), this.btnSync.isSelected());
        super.onGuiClosed();
    }

    public void setCraftingHelper(CraftingHelper craftingHelper) {
        if (this.craftingHelper != null) {
            this.craftingHelper.remove();
        }
        this.craftingHelper = craftingHelper;
        this.ttRefill.setVisible(craftingHelper != null);
        this.ttSetReceipe.setVisible(craftingHelper == null);
        if (craftingHelper != null) {
            craftingHelper.install();
        }
    }

    public void fillFromStoredRecipe(int index, boolean shift) {
        StoredCraftingRecipe recipe = ((TileInventoryPanel)this.getTileEntity()).getStoredCraftingRecipe(index);
        if (recipe == null) {
            return;
        }
        if (this.getContainer().clearCraftingGrid()) {
            CraftingHelper helper = CraftingHelper.createFromRecipe(recipe);
            this.setCraftingHelper(helper);
            helper.refill(this, shift ? 64 : 1);
        }
    }

    @Override
    public void initGui() {
        super.initGui();
        this.updateSortButton();
        this.btnSort.onGuiInit();
        this.btnClear.onGuiInit();
        this.btnSync.onGuiInit();
        this.addScrollbar(this.scrollbar);
        ((InventoryPanelContainer)this.inventorySlots).createGhostSlots(this.getGhostSlots());
    }

    public void actionPerformed(GuiButton b) {
        super.actionPerformed(b);
        if (b.id == 9877) {
            if (this.getContainer().clearCraftingGrid()) {
                this.setCraftingHelper(null);
            }
        } else if (b.id == 9878 && Loader.isModLoaded((String)"NotEnoughItems")) {
            this.updateNEI(((ToggleButton)b).isSelected() ? this.tfFilter.getText() : "");
        }
    }

    @Override
    protected void drawGuiContainerBackgroundLayer(float par1, int mouseX, int mouseY) {
        int iconX;
        boolean hover;
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.bindGuiTexture();
        int sx = this.guiLeft;
        int sy = this.guiTop;
        this.drawTexturedModalRect(sx + 24, sy, 0, 0, 232, this.ySize);
        this.drawTexturedModalRect(sx + 24 + 232, sy, 232, 0, 24, 68);
        if (this.craftingHelper != null) {
            hover = btnRefill.contains(mouseX - sx, mouseY - sy);
            iconX = hover ? (GuiInventoryPanel.isShiftKeyDown() ? 48 : 24) : 0;
            this.drawTexturedModalRect(sx + GuiInventoryPanel.btnRefill.x - 2, sy + GuiInventoryPanel.btnRefill.y - 2, iconX, 232, 24, 24);
        } else if (this.getContainer().hasCraftingRecipe()) {
            hover = btnRefill.contains(mouseX - sx, mouseY - sy);
            iconX = hover ? 96 : 72;
            this.drawTexturedModalRect(sx + GuiInventoryPanel.btnRefill.x - 2, sy + GuiInventoryPanel.btnRefill.y - 2, iconX, 232, 24, 24);
        }
        TileInventoryPanel te = (TileInventoryPanel)this.getTileEntity();
        int y = sy;
        int numStoredRecipes = te.getStoredCraftingRecipes();
        if (numStoredRecipes == 1) {
            this.drawTexturedModalRect(sx, y, 227, 225, 28, 30);
            y += 30;
        } else if (numStoredRecipes > 1) {
            this.drawTexturedModalRect(sx, y, 227, 225, 28, 24);
            y += 24;
            for (int i = 1; i < numStoredRecipes - 1; ++i) {
                this.drawTexturedModalRect(sx, y, 198, 229, 28, 20);
                y += 20;
            }
            this.drawTexturedModalRect(sx, y, 198, 229, 28, 26);
            y += 26;
        }
        if (numStoredRecipes < 6 && this.getContainer().hasNewCraftingRecipe()) {
            this.btnAddStoredRecipe.x = 13;
            this.btnAddStoredRecipe.y = (y += 2) - sy;
            this.btnAddStoredRecipe.width = 12;
            this.btnAddStoredRecipe.height = 14;
            boolean hover2 = this.btnAddStoredRecipe.contains(mouseX - sx, mouseY - sy);
            this.drawTexturedModalRect(sx + 13, y, 182, hover2 ? 241 : 225, 15, 14);
        } else {
            this.btnAddStoredRecipe.width = 0;
            this.btnAddStoredRecipe.height = 0;
        }
        SmartTank fuelTank = te.fuelTank;
        if (!Config.inventoryPanelFree) {
            this.drawTexturedModalRect(sx + 35, sy + 132, 232, 163, 18, 49);
            if (fuelTank.getFluidAmount() > 0) {
                RenderUtil.renderGuiTank((FluidStack)fuelTank.getFluid(), (int)fuelTank.getCapacity(), (int)fuelTank.getFluidAmount(), (double)(sx + 24 + 12), (double)(sy + 132), (double)this.zLevel, (double)16.0, (double)47.0);
            }
        }
        int headerColor = 0x404040;
        int focusedColor = 6587540;
        FontRenderer fr = this.getFontRenderer();
        fr.drawString(this.headerCrafting, sx + 24 + 7, sy + 6, headerColor);
        fr.drawString(te.isExtractionDisabled() ? this.headerStorage : this.headerReturn, sx + 24 + 7, sy + 72, btnReturnArea.contains(mouseX - sx, mouseY - sy) ? focusedColor : headerColor);
        fr.drawString(this.headerInventory, sx + 24 + 38, sy + 120, headerColor);
        super.drawGuiContainerBackgroundLayer(par1, mouseX, mouseY);
        this.view.setDatabase(this.getDatabase());
        this.view.setItemFilter(te.getItemFilter());
        this.view.updateFilter(this.tfFilter.getText());
        boolean update = this.view.sortItems();
        this.scrollbar.setScrollMax(Math.max(0, (this.view.getNumEntries() + 6 - 1) / 6 - 5));
        if (update || this.scrollPos != this.scrollbar.getScrollPos()) {
            this.updateGhostSlots();
        }
        if (te.isActive()) {
            this.tfFilter.setEnabled(true);
            if (!this.tfFilter.isFocused() && this.tfFilter.getText().isEmpty()) {
                fr.drawString(this.infoTextFilter, this.tfFilter.xPosition, this.tfFilter.yPosition, 0x707070);
            }
        } else {
            this.tfFilter.setEnabled(false);
            this.setText(this.tfFilter, "");
            fr.drawString(this.infoTextOffline, this.tfFilter.xPosition, this.tfFilter.yPosition, 0x707070);
        }
    }

    protected void onTextFieldChanged(TextFieldEnder tf, String old) {
        if (tf == this.tfFilter && this.btnSync.isSelected() && this.tfFilter.isFocused() && Loader.isModLoaded((String)"NotEnoughItems")) {
            this.updateNEI(this.tfFilter.getText());
        }
    }

    private void updateNEI(String text) {
        LayoutManager.searchField.setText(text);
    }

    protected void drawFakeItemStack(int x, int y, ItemStack stack) {
        FontRenderer font = stack.getItem().getFontRenderer(stack);
        if (font == null) {
            font = this.fontRendererObj;
        }
        String str = null;
        if (stack.stackSize >= 1000) {
            int value = stack.stackSize / 1000;
            String unit = "k";
            if (value >= 1000) {
                value /= 1000;
                unit = "m";
            }
            str = value + unit;
        } else if (stack.stackSize > 1) {
            str = Integer.toString(stack.stackSize);
        }
        itemRender.renderItemAndEffectIntoGUI(font, this.mc.renderEngine, stack, x, y);
        if (str != null) {
            GL11.glDisable((int)2896);
            GL11.glDisable((int)2929);
            GL11.glDisable((int)3042);
            GL11.glPushMatrix();
            GL11.glTranslatef((float)(x + 16), (float)(y + 16), (float)0.0f);
            font.drawStringWithShadow(str, 1 - font.getStringWidth(str), -8, 0xFFFFFF);
            GL11.glPopMatrix();
            GL11.glEnable((int)2896);
            GL11.glEnable((int)2929);
        }
        itemRender.renderItemOverlayIntoGUI(font, this.mc.renderEngine, stack, x, y, "");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void drawGhostSlotTooltip(GhostSlot slot, int mouseX, int mouseY) {
        ItemStack stack = slot.getStack();
        if (stack != null) {
            this.ghostSlotTooltipStacksize = stack.stackSize;
            try {
                this.renderToolTip(stack, mouseX, mouseY);
            }
            finally {
                this.ghostSlotTooltipStacksize = 0;
            }
        }
    }

    public void drawHoveringText(List list, int mouseX, int mouseY, FontRenderer font) {
        if (this.ghostSlotTooltipStacksize >= 1000) {
            list.add(EnumChatFormatting.WHITE + EnderIO.lang.localize("gui.inventorypanel.tooltip.itemsstored", new Object[]{Integer.toString(this.ghostSlotTooltipStacksize)}));
        }
        super.drawHoveringText(list, mouseX, mouseY, font);
    }

    public InventoryPanelContainer getContainer() {
        return (InventoryPanelContainer)this.inventorySlots;
    }

    public InventoryDatabaseClient getDatabase() {
        return ((TileInventoryPanel)this.getTileEntity()).getDatabaseClient();
    }

    private IconEIO getSortOrderIcon() {
        SortOrder order = this.view.getSortOrder();
        boolean invert = this.view.isSortOrderInverted();
        switch (order) {
            case NAME: {
                return invert ? IconEIO.SORT_NAME_UP : IconEIO.SORT_NAME_DOWN;
            }
            case COUNT: {
                return invert ? IconEIO.SORT_SIZE_UP : IconEIO.SORT_SIZE_DOWN;
            }
            case MOD: {
                return invert ? IconEIO.SORT_MOD_UP : IconEIO.SORT_MOD_DOWN;
            }
        }
        return null;
    }

    void toggleSortOrder(boolean next) {
        SortOrder order = this.view.getSortOrder();
        SortOrder[] values = SortOrder.values();
        int idx = order.ordinal();
        if (next && this.view.isSortOrderInverted()) {
            order = values[(idx + 1) % values.length];
        } else if (!next && !this.view.isSortOrderInverted()) {
            if (idx == 0) {
                idx = values.length;
            }
            order = values[idx - 1];
        }
        this.view.setSortOrder(order, !this.view.isSortOrderInverted());
        this.updateSortButton();
    }

    private void updateSortButton() {
        SortOrder order = this.view.getSortOrder();
        ArrayList list = new ArrayList();
        SpecialTooltipHandler.addTooltipFromResources(list, (String)("enderio.gui.inventorypanel.tooltip.sort." + order.name().toLowerCase(Locale.US) + (this.view.isSortOrderInverted() ? "_up" : "_down") + ".line"));
        this.btnSort.setIcon((IWidgetIcon)this.getSortOrderIcon());
        this.btnSort.setToolTip(list.toArray(new String[list.size()]));
    }

    private void updateGhostSlots() {
        this.scrollPos = this.scrollbar.getScrollPos();
        int index = this.scrollPos * 6;
        int count = this.view.getNumEntries();
        int i = 0;
        while (i < 30) {
            InvSlot slot = (InvSlot)((Object)this.ghostSlots.get(i));
            if (index < count) {
                slot.entry = this.view.getItemEntry(index);
                slot.stack = slot.entry.makeItemStack();
            } else {
                slot.entry = null;
                slot.stack = null;
            }
            ++i;
            ++index;
        }
    }

    @Override
    protected boolean showRecipeButton() {
        return false;
    }

    public int getXSize() {
        return 280;
    }

    public int getYSize() {
        return 212;
    }

    protected void mouseClicked(int x, int y, int button) {
        StoredCraftingRecipe recipe;
        TileInventoryPanel te;
        super.mouseClicked(x, y, button);
        if (btnRefill.contains(x -= this.guiLeft, y -= this.guiTop)) {
            if (this.craftingHelper != null) {
                this.playClickSound();
                this.craftingHelper.refill(this, GuiInventoryPanel.isShiftKeyDown() ? 64 : 1);
            } else if (this.getContainer().hasCraftingRecipe()) {
                this.playClickSound();
                this.setCraftingHelper(CraftingHelper.createFromSlots(this.getContainer().getCraftingGridSlots()));
            }
        }
        if (this.btnAddStoredRecipe.contains(x, y) && (te = (TileInventoryPanel)this.getTileEntity()).getStoredCraftingRecipes() < 6 && this.getContainer().hasNewCraftingRecipe() && (recipe = new StoredCraftingRecipe()).loadFromCraftingGrid(this.getContainer().getCraftingGridSlots())) {
            this.playClickSound();
            te.addStoredCraftingRecipe(recipe);
        }
        if (btnReturnArea.contains(x, y)) {
            te = (TileInventoryPanel)this.getTileEntity();
            this.playClickSound();
            te.setExtractionDisabled(!te.isExtractionDisabled());
        }
    }

    private void playClickSound() {
        this.mc.getSoundHandler().playSound((ISound)PositionedSoundRecord.func_147674_a((ResourceLocation)new ResourceLocation("gui.button.press"), (float)1.0f));
    }

    protected void mouseWheel(int x, int y, int delta) {
        super.mouseWheel(x, y, delta);
        if (this.draggingScrollbar == null) {
            boolean shift = GuiInventoryPanel.isShiftKeyDown();
            if (inventoryArea.contains(x -= this.guiLeft, y -= this.guiTop)) {
                if (!shift) {
                    this.scrollbar.scrollBy(-Integer.signum(delta));
                } else if (this.hoverGhostSlot instanceof InvSlot) {
                    ItemStack itemStack;
                    InvSlot invSlot = (InvSlot)this.hoverGhostSlot;
                    InventoryDatabaseClient db = this.getDatabase();
                    if (invSlot.stack != null && invSlot.entry != null && db != null && ((itemStack = this.mc.thePlayer.inventory.getItemStack()) == null || ItemUtil.areStackMergable((ItemStack)itemStack, (ItemStack)invSlot.stack))) {
                        PacketHandler.INSTANCE.sendToServer((IMessage)new PacketFetchItem(db.getGeneration(), invSlot.entry, -1, 1));
                    }
                }
            }
        }
    }

    protected void ghostSlotClicked(GhostSlot slot, int x, int y, int button) {
        RecipeSlot recipeSlot;
        if (slot instanceof InvSlot) {
            InvSlot invSlot = (InvSlot)slot;
            InventoryDatabaseClient db = this.getDatabase();
            if (invSlot.entry != null && invSlot.stack != null && db != null) {
                int targetSlot;
                int count = Math.min(invSlot.stack.stackSize, invSlot.stack.getMaxStackSize());
                if (button == 0) {
                    if (GuiInventoryPanel.isShiftKeyDown()) {
                        InventoryPlayer playerInv = this.mc.thePlayer.inventory;
                        targetSlot = playerInv.getFirstEmptyStack();
                        if (targetSlot >= 0) {
                            targetSlot = this.getContainer().getSlotIndex((IInventory)playerInv, targetSlot);
                        }
                        if (targetSlot < 0) {
                            return;
                        }
                    } else {
                        targetSlot = -1;
                    }
                } else if (button == 1) {
                    targetSlot = -1;
                    count = GuiInventoryPanel.isCtrlKeyDown() ? 1 : (count + 1) / 2;
                } else {
                    return;
                }
                PacketHandler.INSTANCE.sendToServer((IMessage)new PacketFetchItem(db.getGeneration(), invSlot.entry, targetSlot, count));
            }
        } else if (slot instanceof RecipeSlot && (recipeSlot = (RecipeSlot)slot).isVisible()) {
            if (button == 0) {
                this.fillFromStoredRecipe(recipeSlot.index, GuiInventoryPanel.isShiftKeyDown());
            } else if (button == 1) {
                ((TileInventoryPanel)this.getTileEntity()).removeStoredCraftingRecipe(recipeSlot.index);
            }
        }
    }

    class RecipeSlot
    extends GhostSlot {
        final int index;

        RecipeSlot(int index, int x, int y) {
            this.index = index;
            this.x = x;
            this.y = y;
        }

        public ItemStack getStack() {
            TileInventoryPanel te = (TileInventoryPanel)GuiInventoryPanel.this.getTileEntity();
            StoredCraftingRecipe recipe = te.getStoredCraftingRecipe(this.index);
            return recipe != null ? recipe.getResult(te) : null;
        }

        public boolean isVisible() {
            return this.index < ((TileInventoryPanel)GuiInventoryPanel.this.getTileEntity()).getStoredCraftingRecipes();
        }
    }

    class InvSlot
    extends GhostSlot {
        ItemEntry entry;
        ItemStack stack;

        InvSlot(int x, int y) {
            this.x = x;
            this.y = y;
            this.grayOut = false;
            this.stackSizeLimit = Integer.MAX_VALUE;
        }

        public ItemStack getStack() {
            return this.stack;
        }
    }
}

