/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.machine.hypercube;

import com.enderio.core.common.util.ArrayInventory;
import crazypants.enderio.machine.hypercube.TileHyperCube;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;

public class ItemRecieveBuffer
extends ArrayInventory
implements ISidedInventory {
    private static final int[] ALL_SLOTS = new int[]{0, 1, 2, 3, 4, 5};
    private boolean recieveEnabled;
    TileHyperCube hc;

    public ItemRecieveBuffer(TileHyperCube hc) {
        super(6);
        this.hc = hc;
    }

    public boolean isEmpty() {
        for (ItemStack stack : this.items) {
            if (stack == null) continue;
            return false;
        }
        return true;
    }

    public ItemStack[] getItems() {
        return this.items;
    }

    public void setRecieveEnabled(boolean canRecieveItems) {
        this.recieveEnabled = canRecieveItems;
    }

    public int[] getAccessibleSlotsFromSide(int side) {
        return ALL_SLOTS;
    }

    public boolean canInsertItem(int slot, ItemStack itemStack, int side) {
        if (!this.recieveEnabled || side < 0 || side >= this.items.length || slot != side || itemStack == null) {
            return false;
        }
        ItemStack item = this.items[slot];
        return item == null;
    }

    public void setInventorySlotContents(int slot, ItemStack stack) {
        super.setInventorySlotContents(slot, stack);
        this.hc.pushRecieveBuffer();
    }

    public boolean canExtractItem(int slot, ItemStack itemStack, int side) {
        return true;
    }

    public void readFromNBT(NBTTagCompound nbtRoot) {
        this.items = new ItemStack[6];
        for (int i = 0; i < this.items.length; ++i) {
            String key = "recieveBuffer" + i;
            if (nbtRoot.hasKey(key)) {
                NBTTagCompound stackRoot = nbtRoot.getCompoundTag(key);
                this.items[i] = ItemStack.loadItemStackFromNBT((NBTTagCompound)stackRoot);
                continue;
            }
            this.items[i] = null;
        }
    }

    public void writeToNBT(NBTTagCompound nbtRoot) {
        for (int i = 0; i < this.items.length; ++i) {
            ItemStack stack = this.items[i];
            if (stack == null) continue;
            NBTTagCompound stackRoot = new NBTTagCompound();
            stack.writeToNBT(stackRoot);
            nbtRoot.setTag("recieveBuffer" + i, (NBTBase)stackRoot);
        }
    }
}

