/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.machine.generator.zombie;

import com.enderio.core.client.render.BoundingBox;
import com.enderio.core.client.render.CubeRenderer;
import com.enderio.core.client.render.RenderUtil;
import com.enderio.core.common.util.ForgeDirectionOffsets;
import com.enderio.core.common.vecmath.Vector3d;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import crazypants.enderio.machine.generator.zombie.ModelZombieJar;
import crazypants.enderio.machine.generator.zombie.TileZombieGenerator;
import crazypants.enderio.tool.SmartTank;
import crazypants.util.RenderPassHelper;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.world.World;
import net.minecraftforge.client.IItemRenderer;
import net.minecraftforge.common.util.ForgeDirection;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class ZombieGeneratorRenderer
extends TileEntitySpecialRenderer
implements IItemRenderer {
    private static final String TEXTURE = "enderio:models/ZombieJar.png";
    private ModelZombieJar model = new ModelZombieJar();

    public void renderTileEntityAt(TileEntity te, double x, double y, double z, float tick) {
        World world = te.getWorldObj();
        TileZombieGenerator gen = (TileZombieGenerator)te;
        float f = world.getBlockLightValue(te.xCoord, te.yCoord, te.zCoord);
        int l = world.getLightBrightnessForSkyBlocks(te.xCoord, te.yCoord, te.zCoord, 0);
        int l1 = l % 65536;
        int l2 = l / 65536;
        Tessellator.instance.setColorOpaque_F(f, f, f);
        OpenGlHelper.setLightmapTextureCoords((int)OpenGlHelper.lightmapTexUnit, (float)l1, (float)l2);
        GL11.glPushMatrix();
        GL11.glTranslatef((float)((float)x), (float)((float)y), (float)((float)z));
        if (RenderPassHelper.getEntityRenderPass() == 0) {
            this.renderModel(gen.facing);
        } else if (RenderPassHelper.getEntityRenderPass() == 1) {
            this.renderFluid(gen);
        }
        GL11.glPopMatrix();
    }

    protected void renderFluid(TileZombieGenerator gen) {
        SmartTank tank = gen.fuelTank;
        if (tank.getFluidAmount() <= 0) {
            return;
        }
        IIcon icon = tank.getFluid().getFluid().getStillIcon();
        if (icon != null) {
            RenderUtil.bindBlockTexture();
            Tessellator tes = Tessellator.instance;
            tes.startDrawingQuads();
            ForgeDirection facingDir = ForgeDirection.values()[gen.facing];
            double facingOffset = 0.075;
            BoundingBox bb = BoundingBox.UNIT_CUBE.scale(0.85, 0.96, 0.85);
            float fullness = (float)tank.getFluidAmount() / (float)tank.getCapacity();
            Vector3d absFac = ForgeDirectionOffsets.absolueOffset((ForgeDirection)facingDir);
            double scaleX = absFac.x == 0.0 ? 0.95 : 1.0 - facingOffset / 2.0;
            double scaleY = 0.85 * (double)fullness;
            double scaleZ = absFac.z == 0.0 ? 0.95 : 1.0 - facingOffset / 2.0;
            bb = bb.scale(scaleX, 0.85 * (double)fullness, scaleZ);
            float ty = -(0.85f - (bb.maxY - bb.minY)) / 2.0f;
            Vector3d transOffset = ForgeDirectionOffsets.offsetScaled((ForgeDirection)facingDir, (double)(-facingOffset));
            bb = bb.translate((float)transOffset.x, ty, (float)transOffset.z);
            int brightness = gen.getWorldObj() == null ? 0xF000F0 : gen.getWorldObj().getLightBrightnessForSkyBlocks(gen.xCoord, gen.yCoord, gen.zCoord, 0);
            tes.setBrightness(brightness);
            CubeRenderer.render((BoundingBox)bb, (IIcon)icon);
            GL11.glPushAttrib((int)8192);
            GL11.glEnable((int)3042);
            GL11.glBlendFunc((int)770, (int)771);
            GL11.glDisable((int)2896);
            GL11.glDisable((int)2884);
            GL11.glDepthMask((boolean)false);
            tes.draw();
            GL11.glDepthMask((boolean)true);
            GL11.glPopAttrib();
        }
    }

    private void renderModel(int facing) {
        GL11.glPushMatrix();
        GL11.glTranslatef((float)0.5f, (float)0.0f, (float)0.5f);
        GL11.glRotatef((float)180.0f, (float)1.0f, (float)0.0f, (float)0.0f);
        GL11.glScalef((float)1.2f, (float)0.9f, (float)1.2f);
        ForgeDirection dir = ForgeDirection.getOrientation((int)facing);
        if (dir == ForgeDirection.SOUTH) {
            facing = 0;
        } else if (dir == ForgeDirection.WEST) {
            facing = -1;
        }
        GL11.glRotatef((float)((float)facing * -90.0f), (float)0.0f, (float)1.0f, (float)0.0f);
        RenderUtil.bindTexture((String)TEXTURE);
        this.model.render(null, 0.0f, 0.0f, -0.1f, 0.0f, 0.0f, 0.0625f);
        GL11.glTranslatef((float)-0.5f, (float)0.0f, (float)-0.5f);
        GL11.glPopMatrix();
    }

    public boolean handleRenderType(ItemStack item, IItemRenderer.ItemRenderType type) {
        return true;
    }

    public boolean shouldUseRenderHelper(IItemRenderer.ItemRenderType type, ItemStack item, IItemRenderer.ItemRendererHelper helper) {
        return true;
    }

    public void renderItem(IItemRenderer.ItemRenderType type, ItemStack item, Object ... data) {
        this.renderItem(0.0f, 0.0f, 0.0f);
    }

    private void renderItem(float x, float y, float z) {
        GL11.glPushMatrix();
        GL11.glTranslatef((float)x, (float)y, (float)z);
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        this.renderModel(ForgeDirection.SOUTH.ordinal());
        GL11.glDisable((int)3042);
        GL11.glPopMatrix();
    }
}

