/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.machine.generator.zombie;

import com.enderio.core.client.gui.widget.GuiToolTip;
import com.enderio.core.client.render.ColorUtil;
import com.enderio.core.client.render.RenderUtil;
import crazypants.enderio.EnderIO;
import crazypants.enderio.fluid.Fluids;
import crazypants.enderio.machine.IoMode;
import crazypants.enderio.machine.generator.zombie.ContainerZombieGenerator;
import crazypants.enderio.machine.generator.zombie.TileZombieGenerator;
import crazypants.enderio.machine.gui.GuiPoweredMachineBase;
import crazypants.enderio.machine.power.PowerDisplayUtil;
import java.awt.Color;
import java.awt.Rectangle;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidTank;
import org.lwjgl.opengl.GL11;

public class GuiZombieGenerator
extends GuiPoweredMachineBase<TileZombieGenerator> {
    public GuiZombieGenerator(InventoryPlayer inventory, final TileZombieGenerator tileEntity) {
        super(tileEntity, (Container)new ContainerZombieGenerator(inventory, tileEntity), "zombieGenerator");
        this.addToolTip(new GuiToolTip(new Rectangle(80, 21, 15, 47), new String[]{""}){

            protected void updateText() {
                this.text.clear();
                String heading = EnderIO.lang.localize("zombieGenerator.fuelTank");
                this.text.add(heading);
                this.text.add(Fluids.toCapactityString((IFluidTank)((TileZombieGenerator)((GuiZombieGenerator)GuiZombieGenerator.this).getTileEntity()).fuelTank));
                if (tileEntity.fuelTank.getFluidAmount() < tileEntity.getActivationAmount()) {
                    this.text.add(EnderIO.lang.localize("gui.fluid.minReq", new Object[]{tileEntity.getActivationAmount() + Fluids.MB()}));
                }
            }
        });
    }

    @Override
    protected boolean showRecipeButton() {
        return false;
    }

    @Override
    public void renderSlotHighlights(IoMode mode) {
        super.renderSlotHighlights(mode);
        if (mode == IoMode.PULL || mode == IoMode.PUSH_PULL) {
            int x = 78;
            int y = 19;
            int w = 19;
            int h = 51;
            this.renderSlotHighlight(PULL_COLOR, x, y, w, h);
        }
    }

    @Override
    protected void drawGuiContainerBackgroundLayer(float par1, int par2, int par3) {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.bindGuiTexture();
        int sx = (this.width - this.xSize) / 2;
        int sy = (this.height - this.ySize) / 2;
        this.drawTexturedModalRect(sx, sy, 0, 0, this.xSize, this.ySize);
        TileZombieGenerator gen = (TileZombieGenerator)this.getTileEntity();
        FontRenderer fr = this.getFontRenderer();
        int output = 0;
        if (gen.isActive()) {
            output = gen.outputPerTick;
        }
        String txt = EnderIO.lang.localize("combustionGenerator.output") + " " + PowerDisplayUtil.formatPower(output) + " " + PowerDisplayUtil.abrevation() + PowerDisplayUtil.perTickStr();
        int sw = fr.getStringWidth(txt);
        fr.drawStringWithShadow(txt, this.guiLeft + this.xSize / 2 - sw / 2, this.guiTop + fr.FONT_HEIGHT / 2 + 3, ColorUtil.getRGB((Color)Color.WHITE));
        int x = this.guiLeft + 80;
        int y = this.guiTop + 21;
        if (gen.fuelTank.getFluidAmount() > 0) {
            RenderUtil.renderGuiTank((FluidStack)gen.fuelTank.getFluid(), (int)gen.fuelTank.getCapacity(), (int)gen.fuelTank.getFluidAmount(), (double)x, (double)y, (double)this.zLevel, (double)16.0, (double)47.0);
            if (gen.isActive()) {
                txt = gen.tickPerBucketOfFuel / 1000 + " " + EnderIO.lang.localize("power.tmb");
                sw = fr.getStringWidth(txt);
                fr.drawStringWithShadow(txt, x - sw / 2 + 7, y + fr.FONT_HEIGHT / 2 + 46, ColorUtil.getRGB((Color)Color.WHITE));
            }
        }
        this.bindGuiTexture();
        super.drawGuiContainerBackgroundLayer(par1, par2, par3);
    }

    @Override
    protected int getPowerX() {
        return 15;
    }

    @Override
    protected int getPowerY() {
        return 20;
    }

    @Override
    protected int getPowerHeight() {
        return 48;
    }
}

