/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.machine.generator.stirling;

import com.enderio.core.client.gui.widget.GuiToolTip;
import com.enderio.core.client.render.ColorUtil;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import crazypants.enderio.EnderIO;
import crazypants.enderio.config.Config;
import crazypants.enderio.machine.generator.stirling.StirlingGeneratorContainer;
import crazypants.enderio.machine.generator.stirling.TileEntityStirlingGenerator;
import crazypants.enderio.machine.gui.GuiPoweredMachineBase;
import crazypants.enderio.machine.power.PowerDisplayUtil;
import crazypants.enderio.power.Capacitors;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.text.FieldPosition;
import java.text.MessageFormat;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.util.EnumChatFormatting;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class GuiStirlingGenerator
extends GuiPoweredMachineBase<TileEntityStirlingGenerator> {
    public GuiStirlingGenerator(InventoryPlayer par1InventoryPlayer, TileEntityStirlingGenerator te) {
        super(te, (Container)new StirlingGeneratorContainer(par1InventoryPlayer, te), "stirlingGenerator");
        final StirlingGeneratorContainer c = (StirlingGeneratorContainer)this.inventorySlots;
        Rectangle r = new Rectangle(c.getUpgradeOffset(), new Dimension(16, 16));
        MessageFormat fmt = new MessageFormat(EnderIO.lang.localize("stirlingGenerator.upgrades"));
        this.ttMan.addToolTip(new GuiToolTip(r, new String[]{EnderIO.lang.localize("stirlingGenerator.upgradeslot"), GuiStirlingGenerator.formatUpgrade(fmt, Capacitors.ACTIVATED_CAPACITOR), GuiStirlingGenerator.formatUpgrade(fmt, Capacitors.ENDER_CAPACITOR)}){

            public boolean shouldDraw() {
                return !c.getUpgradeSlot().getHasStack() && super.shouldDraw();
            }
        });
        this.addProgressTooltip(80, 52, 14, 14);
    }

    private static float getFactor(Capacitors upgrade) {
        return TileEntityStirlingGenerator.getEnergyMultiplier(upgrade) * TileEntityStirlingGenerator.getBurnTimeMultiplier(upgrade);
    }

    private static String formatUpgrade(MessageFormat fmt, Capacitors upgrade) {
        float efficiency = GuiStirlingGenerator.getFactor(upgrade) / GuiStirlingGenerator.getFactor(Capacitors.BASIC_CAPACITOR);
        Object[] args = new Object[]{EnderIO.lang.localizeExact(upgrade.unlocalisedName.concat(".name")), Float.valueOf(efficiency), EnumChatFormatting.WHITE, EnumChatFormatting.GRAY};
        return fmt.format(args, new StringBuffer(), (FieldPosition)null).toString();
    }

    @Override
    protected boolean showRecipeButton() {
        return false;
    }

    @Override
    protected String formatProgressTooltip(int scaledProgress, float remaining) {
        int totalBurnTime = ((TileEntityStirlingGenerator)this.getTileEntity()).totalBurnTime;
        int remainingTicks = (int)(remaining * (float)totalBurnTime);
        int remainingSecs = remainingTicks / 20;
        int remainingRF = ((TileEntityStirlingGenerator)this.getTileEntity()).getPowerUsePerTick() * remainingTicks;
        return MessageFormat.format(EnderIO.lang.localize("stirlingGenerator.remaining"), Float.valueOf(remaining), remainingSecs / 60, remainingSecs % 60, remainingRF);
    }

    @Override
    protected int scaleProgressForTooltip(float progress) {
        int totalBurnTime = ((TileEntityStirlingGenerator)this.getTileEntity()).totalBurnTime;
        int scale = Math.max(100, (totalBurnTime + 19) / 20);
        return (int)(progress * (float)scale);
    }

    @Override
    protected void drawGuiContainerBackgroundLayer(float par1, int par2, int par3) {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.bindGuiTexture();
        int sx = (this.width - this.xSize) / 2;
        int sy = (this.height - this.ySize) / 2;
        this.drawTexturedModalRect(sx, sy, 0, 0, this.xSize, this.ySize);
        if (this.shouldRenderProgress()) {
            int scaled = this.getProgressScaled(12);
            this.drawTexturedModalRect(sx + 80, sy + 64 - scaled, 176, 12 - scaled, 14, scaled + 2);
        }
        super.drawGuiContainerBackgroundLayer(par1, par2, par3);
        FontRenderer fr = this.getFontRenderer();
        int y = this.guiTop + fr.FONT_HEIGHT / 2 + 3;
        int output = 0;
        if (((TileEntityStirlingGenerator)this.getTileEntity()).isActive()) {
            output = ((TileEntityStirlingGenerator)this.getTileEntity()).getPowerUsePerTick();
        }
        String txt = EnderIO.lang.localize("stirlingGenerator.output") + " " + PowerDisplayUtil.formatPower(output) + " " + PowerDisplayUtil.abrevation() + PowerDisplayUtil.perTickStr();
        int sw = fr.getStringWidth(txt);
        fr.drawStringWithShadow(txt, this.guiLeft + this.xSize / 2 - sw / 2, y, ColorUtil.getRGB((Color)Color.WHITE));
        txt = String.format("%s %d%%", EnderIO.lang.localize("stirlingGenerator.burnRate"), Math.round(((TileEntityStirlingGenerator)this.getTileEntity()).getBurnTimeMultiplier() / Config.stirlingGeneratorBurnTimeMultiplierT1 * 100.0f));
        sw = fr.getStringWidth(txt);
        fr.drawStringWithShadow(txt, this.guiLeft + this.xSize / 2 - sw / 2, y += fr.FONT_HEIGHT + 3, ColorUtil.getRGB((Color)Color.WHITE));
    }
}

