/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.machine.generator.combustion;

import com.enderio.core.client.gui.widget.GuiToolTip;
import com.enderio.core.client.render.ColorUtil;
import com.enderio.core.client.render.RenderUtil;
import crazypants.enderio.EnderIO;
import crazypants.enderio.fluid.Fluids;
import crazypants.enderio.machine.IoMode;
import crazypants.enderio.machine.generator.combustion.ContainerCombustionEngine;
import crazypants.enderio.machine.generator.combustion.TileCombustionGenerator;
import crazypants.enderio.machine.gui.GuiPoweredMachineBase;
import crazypants.enderio.machine.power.PowerDisplayUtil;
import java.awt.Color;
import java.awt.Rectangle;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidTank;
import org.lwjgl.opengl.GL11;

public class GuiCombustionGenerator
extends GuiPoweredMachineBase<TileCombustionGenerator> {
    public GuiCombustionGenerator(InventoryPlayer par1InventoryPlayer, TileCombustionGenerator te) {
        super(te, (Container)new ContainerCombustionEngine(par1InventoryPlayer, te), "combustionGen");
        this.addToolTip(new GuiToolTip(new Rectangle(114, 21, 15, 47), new String[]{""}){

            protected void updateText() {
                this.text.clear();
                String heading = EnderIO.lang.localize("combustionGenerator.coolantTank");
                if (((TileCombustionGenerator)GuiCombustionGenerator.this.getTileEntity()).getCoolantTank().getFluid() != null) {
                    heading = heading + ": " + ((TileCombustionGenerator)GuiCombustionGenerator.this.getTileEntity()).getCoolantTank().getFluid().getLocalizedName();
                }
                this.text.add(heading);
                this.text.add(Fluids.toCapactityString((IFluidTank)((TileCombustionGenerator)GuiCombustionGenerator.this.getTileEntity()).getCoolantTank()));
            }
        });
        this.addToolTip(new GuiToolTip(new Rectangle(48, 21, 15, 47), new String[]{""}){

            protected void updateText() {
                this.text.clear();
                String heading = EnderIO.lang.localize("combustionGenerator.fuelTank");
                if (((TileCombustionGenerator)GuiCombustionGenerator.this.getTileEntity()).getFuelTank().getFluid() != null) {
                    heading = heading + ": " + ((TileCombustionGenerator)GuiCombustionGenerator.this.getTileEntity()).getFuelTank().getFluid().getLocalizedName();
                }
                this.text.add(heading);
                this.text.add(Fluids.toCapactityString((IFluidTank)((TileCombustionGenerator)GuiCombustionGenerator.this.getTileEntity()).getFuelTank()));
            }
        });
    }

    @Override
    protected boolean showRecipeButton() {
        return false;
    }

    @Override
    public void renderSlotHighlights(IoMode mode) {
        super.renderSlotHighlights(mode);
        if (mode == IoMode.PULL || mode == IoMode.PUSH_PULL) {
            int x = 46;
            int y = 19;
            int w = 19;
            int h = 51;
            this.renderSlotHighlight(PULL_COLOR, x, y, w, h);
            x = 112;
            this.renderSlotHighlight(PULL_COLOR, x, y, w, h);
        }
    }

    @Override
    protected void drawGuiContainerBackgroundLayer(float par1, int par2, int par3) {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.bindGuiTexture();
        int sx = (this.width - this.xSize) / 2;
        int sy = (this.height - this.ySize) / 2;
        this.drawTexturedModalRect(sx, sy, 0, 0, this.xSize, this.ySize);
        TileCombustionGenerator gen = (TileCombustionGenerator)this.getTileEntity();
        FontRenderer fr = this.getFontRenderer();
        int output = 0;
        if (gen.isActive()) {
            output = gen.getGeneratedLastTick();
        }
        String txt = EnderIO.lang.localize("combustionGenerator.output") + " " + PowerDisplayUtil.formatPower(output) + " " + PowerDisplayUtil.abrevation() + PowerDisplayUtil.perTickStr();
        int sw = fr.getStringWidth(txt);
        fr.drawStringWithShadow(txt, this.guiLeft + this.xSize / 2 - sw / 2, this.guiTop + fr.FONT_HEIGHT / 2 + 3, ColorUtil.getRGB((Color)Color.WHITE));
        int x = this.guiLeft + 48;
        int y = this.guiTop + 21;
        if (gen.getCoolantTank().getFluidAmount() > 0) {
            x = this.guiLeft + 114;
            RenderUtil.renderGuiTank((FluidStack)gen.getCoolantTank().getFluid(), (int)4000, (int)(gen.getCoolantTank().getFluidAmount() - 1000), (double)x, (double)y, (double)this.zLevel, (double)15.0, (double)47.0);
            if (gen.isActive()) {
                txt = gen.getNumTicksPerMbCoolant() + " " + EnderIO.lang.localize("power.tmb");
                sw = fr.getStringWidth(txt);
                fr.drawStringWithShadow(txt, x - sw / 2 + 7, y + fr.FONT_HEIGHT / 2 + 47, ColorUtil.getRGB((Color)Color.WHITE));
            }
            x = this.guiLeft + 72;
            y = this.guiTop + 14;
            RenderUtil.renderGuiTank((FluidStack)gen.getCoolantTank().getFluid(), (int)1000, (int)Math.min(gen.getCoolantTank().getFluidAmount(), 1000), (double)x, (double)(y + 14), (double)this.zLevel, (double)33.0, (double)33.0);
            this.bindGuiTexture();
            this.drawTexturedModalRect(x, y + 14, 0, 223, 33, 33);
            y += 7;
        }
        if (gen.getFuelTank().getFluidAmount() > 0) {
            x = this.guiLeft + 48;
            RenderUtil.renderGuiTank((FluidStack)gen.getFuelTank().getFluid(), (int)4000, (int)(gen.getFuelTank().getFluidAmount() - 1000), (double)x, (double)y, (double)this.zLevel, (double)15.0, (double)47.0);
            if (gen.isActive()) {
                txt = gen.getNumTicksPerMbFuel() + " " + EnderIO.lang.localize("power.tmb");
                sw = fr.getStringWidth(txt);
                fr.drawStringWithShadow(txt, x - sw / 2 + 7, y + fr.FONT_HEIGHT / 2 + 47, ColorUtil.getRGB((Color)Color.WHITE));
            }
            RenderUtil.renderGuiTank((FluidStack)gen.getFuelTank().getFluid(), (int)1000, (int)Math.min(gen.getFuelTank().getFluidAmount(), 1000), (double)(this.guiLeft + 81), (double)(this.guiTop + 38), (double)this.zLevel, (double)14.0, (double)14.0);
        }
        this.bindGuiTexture();
        super.drawGuiContainerBackgroundLayer(par1, par2, par3);
    }

    @Override
    protected int getPowerX() {
        return 10;
    }

    @Override
    protected int getPowerY() {
        return 13;
    }

    @Override
    protected int getPowerHeight() {
        return 60;
    }
}

