/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.machine.farm.farmers;

import com.enderio.core.common.util.BlockCoord;
import crazypants.enderio.machine.farm.FarmStationContainer;
import crazypants.enderio.machine.farm.TileFarmStation;
import crazypants.enderio.machine.farm.farmers.HarvestResult;
import crazypants.enderio.machine.farm.farmers.IFarmerJoe;
import crazypants.enderio.machine.farm.farmers.IHarvestResult;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.common.util.ForgeDirection;

public class CustomSeedFarmer
implements IFarmerJoe {
    protected Block plantedBlock;
    protected int plantedBlockMeta;
    protected int grownBlockMeta;
    protected ItemStack seeds;
    protected boolean requiresFarmland = true;
    protected List<Block> tilledBlocks = new ArrayList<Block>();
    protected boolean ignoreSustainCheck = false;
    protected boolean disableTreeFarm;

    public CustomSeedFarmer(Block plantedBlock, ItemStack seeds) {
        this(plantedBlock, 0, 7, seeds);
    }

    public CustomSeedFarmer(Block plantedBlock, int grownBlockMeta, ItemStack seeds) {
        this(plantedBlock, 0, grownBlockMeta, seeds);
    }

    public CustomSeedFarmer(Block plantedBlock, int plantedBlockMeta, int grownBlockMeta, ItemStack seeds) {
        this.plantedBlock = plantedBlock;
        this.plantedBlockMeta = plantedBlockMeta;
        this.grownBlockMeta = grownBlockMeta;
        this.seeds = seeds;
        FarmStationContainer.slotItemsSeeds.add(seeds);
        this.addTilledBlock(Blocks.farmland);
    }

    public void addTilledBlock(Block block) {
        this.tilledBlocks.add(block);
    }

    public boolean isIgnoreGroundCanSustainCheck() {
        return this.ignoreSustainCheck;
    }

    public void setIgnoreGroundCanSustainCheck(boolean ignoreSustainCheck) {
        this.ignoreSustainCheck = ignoreSustainCheck;
    }

    public int getPlantedBlockMeta() {
        return this.plantedBlockMeta;
    }

    public Block getPlantedBlock() {
        return this.plantedBlock;
    }

    public ItemStack getSeeds() {
        return this.seeds;
    }

    public int getFullyGrownBlockMeta() {
        return this.grownBlockMeta;
    }

    @Override
    public boolean canHarvest(TileFarmStation farm, BlockCoord bc, Block block, int meta) {
        return block == this.getPlantedBlock() && this.getFullyGrownBlockMeta() == meta;
    }

    @Override
    public boolean canPlant(ItemStack stack) {
        if (stack == null) {
            return false;
        }
        return stack.isItemEqual(this.getSeeds());
    }

    @Override
    public boolean prepareBlock(TileFarmStation farm, BlockCoord bc, Block block, int meta) {
        if (!farm.isOpen(bc)) {
            return false;
        }
        if (this.requiresFarmland()) {
            boolean tilled;
            World worldObj = farm.getWorldObj();
            if (this.isGroundTilled(farm, bc)) {
                return this.plantFromInventory(farm, bc);
            }
            if (farm.hasSeed(this.getSeeds(), bc) && !(tilled = this.tillBlock(farm, bc))) {
                return false;
            }
        }
        return this.plantFromInventory(farm, bc);
    }

    public boolean requiresFarmland() {
        return this.requiresFarmland;
    }

    public void setRequiresFarmland(boolean requiresFarmland) {
        this.requiresFarmland = requiresFarmland;
    }

    protected boolean plantFromInventory(TileFarmStation farm, BlockCoord bc) {
        World worldObj = farm.getWorldObj();
        if (this.canPlant(worldObj, bc) && farm.takeSeedFromSupplies(this.getSeeds(), bc) != null) {
            return this.plant(farm, worldObj, bc);
        }
        return false;
    }

    @Override
    public IHarvestResult harvestBlock(TileFarmStation farm, BlockCoord bc, Block block, int meta) {
        if (!this.canHarvest(farm, bc, block, meta)) {
            return null;
        }
        if (!farm.hasHoe()) {
            farm.setNotification("noHoe");
            return null;
        }
        World worldObj = farm.getWorldObj();
        ArrayList<EntityItem> result = new ArrayList<EntityItem>();
        ArrayList drops = block.getDrops(worldObj, bc.x, bc.y, bc.z, meta, farm.getMaxLootingValue());
        farm.damageHoe(1, bc);
        farm.actionPerformed(false);
        boolean removed = false;
        if (drops != null) {
            for (ItemStack stack : drops) {
                if (!removed && stack.isItemEqual(this.getSeeds())) {
                    --stack.stackSize;
                    removed = true;
                    if (stack.stackSize <= 0) continue;
                    result.add(new EntityItem(worldObj, (double)bc.x + 0.5, (double)bc.y + 0.5, (double)bc.z + 0.5, stack.copy()));
                    continue;
                }
                result.add(new EntityItem(worldObj, (double)bc.x + 0.5, (double)bc.y + 0.5, (double)bc.z + 0.5, stack.copy()));
            }
        }
        if (removed) {
            if (!this.plant(farm, worldObj, bc)) {
                result.add(new EntityItem(worldObj, (double)bc.x + 0.5, (double)bc.y + 0.5, (double)bc.z + 0.5, this.getSeeds().copy()));
                worldObj.setBlock(bc.x, bc.y, bc.z, Blocks.air, 0, 3);
            }
        } else {
            worldObj.setBlock(bc.x, bc.y, bc.z, Blocks.air, 0, 3);
        }
        return new HarvestResult(result, bc);
    }

    protected boolean tillBlock(TileFarmStation farm, BlockCoord plantingLocation) {
        World worldObj = farm.getWorldObj();
        BlockCoord dirtLoc = plantingLocation.getLocation(ForgeDirection.DOWN);
        Block dirtBlock = farm.getBlock(dirtLoc);
        if ((dirtBlock == Blocks.dirt || dirtBlock == Blocks.grass) && farm.hasHoe()) {
            farm.damageHoe(1, dirtLoc);
            worldObj.setBlock(dirtLoc.x, dirtLoc.y, dirtLoc.z, Blocks.farmland);
            worldObj.playSoundEffect((double)((float)dirtLoc.x + 0.5f), (double)((float)dirtLoc.y + 0.5f), (double)((float)dirtLoc.z + 0.5f), Blocks.farmland.stepSound.getStepResourcePath(), (Blocks.farmland.stepSound.getVolume() + 1.0f) / 2.0f, Blocks.farmland.stepSound.getPitch() * 0.8f);
            farm.actionPerformed(false);
            return true;
        }
        return false;
    }

    protected boolean isGroundTilled(TileFarmStation farm, BlockCoord plantingLocation) {
        Block target = farm.getBlock(plantingLocation.getLocation(ForgeDirection.DOWN));
        for (Block tst : this.tilledBlocks) {
            if (tst != target) continue;
            return true;
        }
        return false;
    }

    protected boolean canPlant(World worldObj, BlockCoord bc) {
        Block target = this.getPlantedBlock();
        Block ground = worldObj.getBlock(bc.x, bc.y - 1, bc.z);
        IPlantable plantable = (IPlantable)this.getPlantedBlock();
        return target.canPlaceBlockAt(worldObj, bc.x, bc.y, bc.z) && target.canBlockStay(worldObj, bc.x, bc.y, bc.z) && (ground.canSustainPlant((IBlockAccess)worldObj, bc.x, bc.y - 1, bc.z, ForgeDirection.UP, plantable) || this.ignoreSustainCheck);
    }

    protected boolean plant(TileFarmStation farm, World worldObj, BlockCoord bc) {
        worldObj.setBlock(bc.x, bc.y, bc.z, Blocks.air, 0, 3);
        if (this.canPlant(worldObj, bc)) {
            worldObj.setBlock(bc.x, bc.y, bc.z, this.getPlantedBlock(), this.getPlantedBlockMeta(), 3);
            farm.actionPerformed(false);
            return true;
        }
        return false;
    }

    public boolean doesDisableTreeFarm() {
        return this.disableTreeFarm;
    }
}

