/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.machine.farm;

import com.enderio.core.common.util.BlockCoord;
import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import crazypants.enderio.EnderIO;
import crazypants.enderio.ModObject;
import crazypants.enderio.config.Config;
import crazypants.enderio.machine.AbstractPoweredTaskEntity;
import crazypants.enderio.machine.ContinuousTask;
import crazypants.enderio.machine.IMachineRecipe;
import crazypants.enderio.machine.IPoweredTask;
import crazypants.enderio.machine.SlotDefinition;
import crazypants.enderio.machine.farm.FakeFarmPlayer;
import crazypants.enderio.machine.farm.Fertilizer;
import crazypants.enderio.machine.farm.PacketFarmAction;
import crazypants.enderio.machine.farm.PacketFarmLockedSlot;
import crazypants.enderio.machine.farm.PacketUpdateNotification;
import crazypants.enderio.machine.farm.farmers.FarmersCommune;
import crazypants.enderio.machine.farm.farmers.IHarvestResult;
import crazypants.enderio.machine.farm.farmers.RubberTreeFarmerIC2;
import crazypants.enderio.network.PacketHandler;
import crazypants.enderio.power.BasicCapacitor;
import crazypants.enderio.tool.ArrayMappingTool;
import java.util.BitSet;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemShears;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.EnumSkyBlock;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.util.ForgeDirection;

public class TileFarmStation
extends AbstractPoweredTaskEntity {
    private static final int TICKS_PER_WORK = 20;
    public static final String NOTIFICATION_NO_HOE = "noHoe";
    public static final String NOTIFICATION_NO_AXE = "noAxe";
    public static final String NOTIFICATION_NO_SEEDS = "noSeeds";
    private BlockCoord lastScanned;
    private EntityPlayerMP farmerJoe;
    public static final int NUM_TOOL_SLOTS = 3;
    private static final int minToolSlot = 0;
    private static final int maxToolSlot = 2;
    public static final int NUM_FERTILIZER_SLOTS = 2;
    public static final int minFirtSlot = 3;
    public static final int maxFirtSlot = 4;
    public static final int NUM_SUPPLY_SLOTS = 4;
    public static final int minSupSlot = 5;
    public static final int maxSupSlot = 8;
    private final BitSet lockedSlots = new BitSet();
    public String notification = "";
    public boolean sendNotification = false;
    private boolean wasActive;
    private int bonemealCooldown = 5;

    public TileFarmStation() {
        super(new SlotDefinition(9, 6, 1));
    }

    public int getFarmSize() {
        return Config.farmDefaultSize + this.getUpgradeDist();
    }

    public void actionPerformed(boolean isAxe) {
        if (isAxe) {
            this.usePower(Config.farmAxeActionEnergyUseRF);
        } else {
            this.usePower(Config.farmActionEnergyUseRF);
        }
        this.clearNotification();
    }

    public boolean tillBlock(BlockCoord plantingLocation) {
        BlockCoord dirtLoc = plantingLocation.getLocation(ForgeDirection.DOWN);
        Block dirtBlock = this.getBlock(dirtLoc);
        if (dirtBlock == Blocks.dirt || dirtBlock == Blocks.grass) {
            if (!this.hasHoe()) {
                this.setNotification(NOTIFICATION_NO_HOE);
                return false;
            }
            this.damageHoe(1, dirtLoc);
            this.worldObj.setBlock(dirtLoc.x, dirtLoc.y, dirtLoc.z, Blocks.farmland);
            this.worldObj.playSoundEffect((double)((float)dirtLoc.x + 0.5f), (double)((float)dirtLoc.y + 0.5f), (double)((float)dirtLoc.z + 0.5f), Blocks.farmland.stepSound.getStepResourcePath(), (Blocks.farmland.stepSound.getVolume() + 1.0f) / 2.0f, Blocks.farmland.stepSound.getPitch() * 0.8f);
            this.actionPerformed(false);
            return true;
        }
        return dirtBlock == Blocks.farmland;
    }

    public int getMaxLootingValue() {
        int result = 0;
        for (int i = 0; i <= 2; ++i) {
            int level;
            if (this.inventory[i] == null || (level = this.getLooting(this.inventory[i])) <= result) continue;
            result = level;
        }
        return result;
    }

    private int getUpgradeDist() {
        int upg = this.slotDefinition.getMaxUpgradeSlot();
        if (this.inventory[upg] == null) {
            return 0;
        }
        return Config.farmBonusSize * this.inventory[upg].getItemDamage();
    }

    public boolean hasHoe() {
        return this.hasTool(ToolType.HOE);
    }

    public boolean hasAxe() {
        return this.hasTool(ToolType.AXE);
    }

    public boolean hasShears() {
        return this.hasTool(ToolType.SHEARS);
    }

    public int getAxeLootingValue() {
        ItemStack tool = this.getTool(ToolType.AXE);
        if (tool == null) {
            return 0;
        }
        return this.getLooting(tool);
    }

    public void damageAxe(Block blk, BlockCoord bc) {
        this.damageTool(ToolType.AXE, blk, bc, 1);
    }

    public void damageHoe(int i, BlockCoord bc) {
        this.damageTool(ToolType.HOE, null, bc, i);
    }

    public void damageShears(Block blk, BlockCoord bc) {
        this.damageTool(ToolType.SHEARS, blk, bc, 1);
    }

    public boolean hasTool(ToolType type) {
        return this.getTool(type) != null;
    }

    private ItemStack getTool(ToolType type) {
        for (int i = 0; i <= 2; ++i) {
            if (!type.itemMatches(this.inventory[i]) || this.inventory[i].stackSize <= 0) continue;
            return this.inventory[i];
        }
        return null;
    }

    public void damageTool(ToolType type, Block blk, BlockCoord bc, int damage) {
        ItemStack tool = this.getTool(type);
        if (tool == null) {
            return;
        }
        float rand = this.worldObj.rand.nextFloat();
        if (rand >= Config.farmToolTakeDamageChance) {
            return;
        }
        boolean canDamage = this.canDamage(tool);
        if (type == ToolType.AXE) {
            tool.getItem().onBlockDestroyed(tool, this.worldObj, blk, bc.x, bc.y, bc.z, (EntityLivingBase)this.farmerJoe);
        } else if (type == ToolType.HOE) {
            int origDamage = tool.getItemDamage();
            tool.getItem().onItemUse(tool, (EntityPlayer)this.farmerJoe, this.worldObj, bc.x, bc.y, bc.z, 1, 0.5f, 0.5f, 0.5f);
            if (origDamage == tool.getItemDamage() && canDamage) {
                tool.damageItem(1, (EntityLivingBase)this.farmerJoe);
            }
        } else if (canDamage) {
            tool.damageItem(1, (EntityLivingBase)this.farmerJoe);
        }
        if (tool.stackSize == 0 || canDamage && tool.getItemDamage() >= tool.getMaxDamage()) {
            this.destroyTool(type);
        }
    }

    private boolean canDamage(ItemStack stack) {
        return stack != null && stack.isItemStackDamageable() && stack.getItem().isDamageable();
    }

    private void destroyTool(ToolType type) {
        for (int i = 0; i <= 2; ++i) {
            if (!type.itemMatches(this.inventory[i]) || this.inventory[i].stackSize != 0) continue;
            this.inventory[i] = null;
            this.markDirty();
            return;
        }
    }

    private int getLooting(ItemStack stack) {
        return Math.max(EnchantmentHelper.getEnchantmentLevel((int)Enchantment.looting.effectId, (ItemStack)stack), EnchantmentHelper.getEnchantmentLevel((int)Enchantment.fortune.effectId, (ItemStack)stack));
    }

    public EntityPlayerMP getFakePlayer() {
        return this.farmerJoe;
    }

    public Block getBlock(BlockCoord bc) {
        return this.worldObj.getBlock(bc.x, bc.y, bc.z);
    }

    public Block getBlock(int x, int y, int z) {
        return this.worldObj.getBlock(x, y, z);
    }

    public int getBlockMeta(BlockCoord bc) {
        return this.worldObj.getBlockMetadata(bc.x, bc.y, bc.z);
    }

    public boolean isOpen(BlockCoord bc) {
        Block block = this.worldObj.getBlock(bc.x, bc.y, bc.z);
        return block.isAir((IBlockAccess)this.worldObj, bc.x, bc.y, bc.z) || block.isReplaceable((IBlockAccess)this.worldObj, bc.x, bc.y, bc.z);
    }

    public void setNotification(String unloc) {
        String newNote = EnderIO.lang.localize("farm.note." + unloc);
        if (!newNote.equals(this.notification)) {
            this.notification = newNote;
            this.sendNotification = true;
        }
    }

    public void clearNotification() {
        if (this.hasNotification()) {
            this.notification = "";
            this.sendNotification = true;
        }
    }

    public boolean hasNotification() {
        return !"".equals(this.notification);
    }

    private void sendNotification() {
        PacketHandler.INSTANCE.sendToAll((IMessage)new PacketUpdateNotification(this, this.notification));
    }

    @Override
    protected boolean isMachineItemValidForSlot(int i, ItemStack stack) {
        if (stack == null) {
            return false;
        }
        if (i <= 2) {
            if (ToolType.isTool(stack)) {
                for (int j = 0; j <= 2; ++j) {
                    if (!ToolType.getToolType(stack).itemMatches(this.inventory[j])) continue;
                    return false;
                }
                return true;
            }
            return false;
        }
        if (i <= 4) {
            return Fertilizer.isFertilizer(stack);
        }
        if (i <= 8) {
            return (this.inventory[i] != null || !this.isSlotLocked(i)) && FarmersCommune.instance.canPlant(stack);
        }
        return false;
    }

    @Override
    public void doUpdate() {
        super.doUpdate();
        if (this.isActive() != this.wasActive) {
            this.wasActive = this.isActive();
            this.worldObj.updateLightByType(EnumSkyBlock.Block, this.xCoord, this.yCoord, this.zCoord);
        }
    }

    @Override
    protected boolean checkProgress(boolean redstoneChecksPassed) {
        if (redstoneChecksPassed) {
            this.usePower();
            if (this.canTick(redstoneChecksPassed)) {
                this.doTick();
            }
        }
        return false;
    }

    protected boolean canTick(boolean redstoneChecksPassed) {
        if (!this.shouldDoWorkThisTick(2)) {
            return false;
        }
        if (this.getEnergyStored() < this.getPowerUsePerTick()) {
            this.setNotification("noPower");
            return false;
        }
        return true;
    }

    protected void doTick() {
        Fertilizer fertilizer;
        IHarvestResult harvest;
        if (this.sendNotification && this.shouldDoWorkThisTick(20)) {
            this.sendNotification = false;
            this.sendNotification();
        }
        if (!this.hasPower() && Config.farmActionEnergyUseRF > 0 && Config.farmAxeActionEnergyUseRF > 0) {
            this.setNotification("noPower");
            return;
        }
        if ("noPower".equals(this.notification)) {
            this.clearNotification();
        }
        BlockCoord bc = null;
        int infiniteLoop = 20;
        while (bc == null || bc.equals((Object)this.getLocation()) || !this.worldObj.getChunkProvider().chunkExists(bc.x >> 4, bc.z >> 4)) {
            if (infiniteLoop-- <= 0) {
                return;
            }
            bc = this.getNextCoord();
        }
        Block block = this.worldObj.getBlock(bc.x, bc.y, bc.z);
        if (block == null) {
            return;
        }
        int meta = this.worldObj.getBlockMetadata(bc.x, bc.y, bc.z);
        if (this.farmerJoe == null) {
            this.farmerJoe = new FakeFarmPlayer(MinecraftServer.getServer().worldServerForDimension(this.worldObj.provider.dimensionId));
        }
        if (this.isOpen(bc)) {
            FarmersCommune.instance.prepareBlock(this, bc, block, meta);
            block = this.worldObj.getBlock(bc.x, bc.y, bc.z);
        }
        if (this.isOutputFull()) {
            this.setNotification("outputFull");
            return;
        }
        if (!this.hasPower() && Config.farmActionEnergyUseRF > 0 && Config.farmAxeActionEnergyUseRF > 0) {
            this.setNotification("noPower");
            return;
        }
        if (!this.isOpen(bc) && (harvest = FarmersCommune.instance.harvestBlock(this, bc, block, meta)) != null && harvest.getDrops() != null) {
            PacketFarmAction pkt = new PacketFarmAction(harvest.getHarvestedBlocks());
            PacketHandler.INSTANCE.sendToAllAround((IMessage)pkt, new NetworkRegistry.TargetPoint(this.worldObj.provider.dimensionId, (double)bc.x, (double)bc.y, (double)bc.z, 64.0));
            for (EntityItem ei : harvest.getDrops()) {
                if (ei == null) continue;
                this.insertHarvestDrop((Entity)ei, bc);
                if (ei.isDead) continue;
                this.worldObj.spawnEntityInWorld((Entity)ei);
            }
            return;
        }
        if (!(this.hasPower() || Config.farmBonemealActionEnergyUseRF <= 0 && Config.farmBonemealTryEnergyUseRF <= 0)) {
            this.setNotification("noPower");
            return;
        }
        if (this.hasBonemeal() && this.bonemealCooldown-- <= 0 && ((fertilizer = Fertilizer.getInstance(this.inventory[3])).applyOnPlant() != this.isOpen(bc) || fertilizer.applyOnAir() == this.worldObj.isAirBlock(bc.x, bc.y, bc.z))) {
            this.farmerJoe.inventory.mainInventory[0] = this.inventory[3];
            this.farmerJoe.inventory.currentItem = 0;
            if (fertilizer.apply(this.inventory[3], (EntityPlayer)this.farmerJoe, this.worldObj, bc)) {
                this.inventory[3] = this.farmerJoe.inventory.mainInventory[0];
                PacketHandler.INSTANCE.sendToAllAround((IMessage)new PacketFarmAction(bc), new NetworkRegistry.TargetPoint(this.worldObj.provider.dimensionId, (double)bc.x, (double)bc.y, (double)bc.z, 64.0));
                if (this.inventory[3] != null && this.inventory[3].stackSize == 0) {
                    this.inventory[3] = null;
                }
                this.usePower(Config.farmBonemealActionEnergyUseRF);
                this.bonemealCooldown = 20;
            } else {
                this.usePower(Config.farmBonemealTryEnergyUseRF);
                this.bonemealCooldown = 5;
            }
            this.farmerJoe.inventory.mainInventory[0] = null;
        }
    }

    private boolean hasBonemeal() {
        if (this.inventory[3] != null) {
            return true;
        }
        for (int i = 4; i <= 4; ++i) {
            if (this.inventory[i] == null) continue;
            this.inventory[3] = this.inventory[i];
            this.inventory[i] = null;
            return true;
        }
        return false;
    }

    private boolean isOutputFull() {
        for (int i = this.slotDefinition.minOutputSlot; i <= this.slotDefinition.maxOutputSlot; ++i) {
            ItemStack curStack = this.inventory[i];
            if (curStack != null && curStack.stackSize >= curStack.getMaxStackSize()) continue;
            return false;
        }
        return true;
    }

    public boolean hasSeed(ItemStack seeds, BlockCoord bc) {
        int slot = this.getSupplySlotForCoord(bc);
        ItemStack inv = this.inventory[slot];
        return inv != null && (inv.stackSize > 1 || !this.isSlotLocked(slot)) && inv.isItemEqual(seeds);
    }

    public int isLowOnSaplings(BlockCoord bc) {
        int slot = this.getSupplySlotForCoord(bc);
        ItemStack inv = this.inventory[slot];
        return 90 * (Config.farmSaplingReserveAmount - (inv == null ? 0 : inv.stackSize)) / Config.farmSaplingReserveAmount;
    }

    public ItemStack takeSeedFromSupplies(ItemStack stack, BlockCoord forBlock) {
        return this.takeSeedFromSupplies(stack, forBlock, true);
    }

    public ItemStack takeSeedFromSupplies(ItemStack stack, BlockCoord forBlock, boolean matchMetadata) {
        if (stack == null || forBlock == null) {
            return null;
        }
        int slot = this.getSupplySlotForCoord(forBlock);
        ItemStack inv = this.inventory[slot];
        if (inv != null && (matchMetadata ? inv.isItemEqual(stack) : inv.getItem() == stack.getItem())) {
            if (inv.stackSize <= 1 && this.isSlotLocked(slot)) {
                return null;
            }
            ItemStack result = inv.copy();
            result.stackSize = 1;
            inv = inv.copy();
            --inv.stackSize;
            if (inv.stackSize == 0) {
                inv = null;
            }
            this.setInventorySlotContents(slot, inv);
            return result;
        }
        return null;
    }

    public ItemStack takeSeedFromSupplies(BlockCoord bc) {
        return this.takeSeedFromSupplies(this.getSeedTypeInSuppliesFor(bc), bc);
    }

    public ItemStack getSeedTypeInSuppliesFor(BlockCoord bc) {
        int slot = this.getSupplySlotForCoord(bc);
        ItemStack inv = this.inventory[slot];
        if (!(inv == null || inv.stackSize <= 1 && this.isSlotLocked(slot))) {
            return inv.copy();
        }
        return null;
    }

    protected int getSupplySlotForCoord(BlockCoord forBlock) {
        if (forBlock.x <= this.xCoord && forBlock.z > this.zCoord) {
            return 5;
        }
        if (forBlock.x > this.xCoord && forBlock.z > this.zCoord - 1) {
            return 6;
        }
        if (forBlock.x < this.xCoord && forBlock.z <= this.zCoord) {
            return 7;
        }
        return 8;
    }

    private void insertHarvestDrop(Entity entity, BlockCoord bc) {
        if (!this.worldObj.isRemote && entity instanceof EntityItem && !entity.isDead) {
            EntityItem item = (EntityItem)entity;
            ItemStack stack = item.getEntityItem().copy();
            int numInserted = this.insertResult(stack, bc);
            stack.stackSize -= numInserted;
            item.setEntityItemStack(stack);
            if (stack.stackSize == 0) {
                item.setDead();
            }
        }
    }

    private int insertResult(ItemStack stack, BlockCoord bc) {
        int slot = bc != null ? this.getSupplySlotForCoord(bc) : 5;
        int[] slots = new int[4];
        int k = 0;
        int j = slot;
        while (j <= 8) {
            slots[k++] = j++;
        }
        j = 5;
        while (j < slot) {
            slots[k++] = j++;
        }
        int origSize = stack.stackSize;
        stack = stack.copy();
        int inserted = 0;
        for (int j2 = 0; j2 < slots.length && inserted < stack.stackSize; ++j2) {
            int i = slots[j2];
            ItemStack curStack = this.inventory[i];
            int inventoryStackLimit = this.getInventoryStackLimit(i);
            if (!this.isItemValidForSlot(i, stack) || curStack != null && curStack.stackSize >= inventoryStackLimit) continue;
            if (curStack == null) {
                if (stack.stackSize < inventoryStackLimit) {
                    this.inventory[i] = stack.copy();
                    inserted = stack.stackSize;
                    continue;
                }
                this.inventory[i] = stack.copy();
                this.inventory[i].stackSize = inserted = inventoryStackLimit;
                continue;
            }
            if (!curStack.isItemEqual(stack)) continue;
            inserted = Math.min(inventoryStackLimit - curStack.stackSize, stack.stackSize);
            this.inventory[i].stackSize += inserted;
        }
        stack.stackSize -= inserted;
        if (inserted >= origSize) {
            return origSize;
        }
        IMachineRecipe.ResultStack[] in = new IMachineRecipe.ResultStack[]{new IMachineRecipe.ResultStack(stack)};
        this.mergeResults(in);
        return origSize - (in[0].item == null ? 0 : in[0].item.stackSize);
    }

    @Nonnull
    private BlockCoord getNextCoord() {
        int size = this.getFarmSize();
        BlockCoord loc = this.getLocation();
        if (this.lastScanned == null) {
            this.lastScanned = new BlockCoord(loc.x - size, loc.y, loc.z - size);
            return this.lastScanned;
        }
        int nextX = this.lastScanned.x + 1;
        int nextZ = this.lastScanned.z;
        if (nextX > loc.x + size) {
            nextX = loc.x - size;
            if (++nextZ > loc.z + size) {
                nextX = loc.x - size;
                nextZ = loc.z - size;
            }
        }
        this.lastScanned = new BlockCoord(nextX, this.lastScanned.y, nextZ);
        return this.lastScanned;
    }

    public void toggleLockedState(int slot) {
        if (this.worldObj.isRemote) {
            PacketHandler.INSTANCE.sendToServer((IMessage)new PacketFarmLockedSlot(this, slot));
        }
        this.lockedSlots.flip(slot);
    }

    public boolean isSlotLocked(int slot) {
        return this.lockedSlots.get(slot);
    }

    @Override
    public String getInventoryName() {
        return EnderIO.blockFarmStation.getLocalizedName();
    }

    @Override
    public boolean hasCustomInventoryName() {
        return false;
    }

    @Override
    public String getMachineName() {
        return ModObject.blockFarmStation.unlocalisedName;
    }

    @Override
    public float getProgress() {
        return 0.5f;
    }

    @Override
    public void onCapacitorTypeChange() {
        int ppt = this.calcPowerUsePerTick();
        switch (this.getCapacitorType()) {
            case BASIC_CAPACITOR: {
                this.setCapacitor(new BasicCapacitor(ppt * 40, 250000, ppt));
                break;
            }
            case ACTIVATED_CAPACITOR: {
                this.setCapacitor(new BasicCapacitor(ppt * 40, 500000, ppt));
                break;
            }
            case ENDER_CAPACITOR: {
                this.setCapacitor(new BasicCapacitor(ppt * 40, 1000000, ppt));
            }
        }
        this.currentTask = this.createTask();
    }

    private int calcPowerUsePerTick() {
        return Math.round((float)Config.farmContinuousEnergyUseRF * ((float)this.getFarmSize() / (float)Config.farmDefaultSize));
    }

    @Override
    public void readCustomNBT(NBTTagCompound nbtRoot) {
        super.readCustomNBT(nbtRoot);
        this.currentTask = this.createTask();
    }

    @Override
    public void readCommon(NBTTagCompound nbtRoot) {
        super.readCommon(nbtRoot);
        this.lockedSlots.clear();
        for (int i : nbtRoot.getIntArray("lockedSlots")) {
            this.lockedSlots.set(i);
        }
        int slotLayoutVersion = nbtRoot.getInteger("slotLayoutVersion");
        if (slotLayoutVersion == 0) {
            this.inventory = new ArrayMappingTool<ItemStack>("TTSSSSOOOOC", "TTTBBSSSSOOOOOOC").map(this.inventory);
        } else if (slotLayoutVersion == 1) {
            this.inventory = new ArrayMappingTool<ItemStack>("TTTSSSSOOOOC", "TTTBBSSSSOOOOOOC").map(this.inventory);
        } else if (slotLayoutVersion == 2) {
            this.inventory = new ArrayMappingTool<ItemStack>("TTTSSSSOOOOOOC", "TTTBBSSSSOOOOOOC").map(this.inventory);
        }
    }

    IPoweredTask createTask() {
        return new ContinuousTask(this.getPowerUsePerTick());
    }

    @Override
    public void writeCustomNBT(NBTTagCompound nbtRoot) {
        super.writeCustomNBT(nbtRoot);
        nbtRoot.setBoolean("isActive", this.isActive());
    }

    @Override
    public void writeCommon(NBTTagCompound nbtRoot) {
        super.writeCommon(nbtRoot);
        if (!this.lockedSlots.isEmpty()) {
            int[] locked = new int[this.lockedSlots.cardinality()];
            int i = 0;
            int bit = -1;
            while ((bit = this.lockedSlots.nextSetBit(bit + 1)) >= 0) {
                locked[i] = bit;
                ++i;
            }
            nbtRoot.setIntArray("lockedSlots", locked);
        }
        nbtRoot.setInteger("slotLayoutVersion", 3);
    }

    @Override
    public int getInventoryStackLimit(int slot) {
        if (slot >= 5 && slot <= 8) {
            switch (this.getCapacitorType()) {
                case BASIC_CAPACITOR: {
                    return 16;
                }
                case ACTIVATED_CAPACITOR: {
                    return 32;
                }
                case ENDER_CAPACITOR: {
                    return 64;
                }
            }
        }
        return 64;
    }

    @Override
    public int getInventoryStackLimit() {
        return this.getInventoryStackLimit(5);
    }

    public static enum ToolType {
        HOE{

            @Override
            boolean match(ItemStack item) {
                for (ItemStack stack : Config.farmHoes) {
                    if (stack.getItem() != item.getItem()) continue;
                    return true;
                }
                return false;
            }
        }
        ,
        AXE{

            @Override
            boolean match(ItemStack item) {
                return item.getItem().getHarvestLevel(item, "axe") >= 0;
            }
        }
        ,
        TREETAP{

            @Override
            boolean match(ItemStack item) {
                return item.getItem().getClass() == RubberTreeFarmerIC2.treeTap;
            }
        }
        ,
        SHEARS{

            @Override
            boolean match(ItemStack item) {
                return item.getItem() instanceof ItemShears;
            }
        }
        ,
        NONE{

            @Override
            boolean match(ItemStack item) {
                return false;
            }
        };


        public final boolean itemMatches(ItemStack item) {
            if (item == null) {
                return false;
            }
            return this.match(item) && !this.isBrokenTinkerTool(item);
        }

        private boolean isBrokenTinkerTool(ItemStack item) {
            return item.hasTagCompound() && item.getTagCompound().hasKey("InfiTool") && item.getTagCompound().getCompoundTag("InfiTool").getBoolean("Broken");
        }

        abstract boolean match(ItemStack var1);

        public static boolean isTool(ItemStack stack) {
            for (ToolType type : ToolType.values()) {
                if (!type.itemMatches(stack)) continue;
                return true;
            }
            return false;
        }

        public static ToolType getToolType(ItemStack stack) {
            for (ToolType type : ToolType.values()) {
                if (!type.itemMatches(stack)) continue;
                return type;
            }
            return NONE;
        }
    }
}

