/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.machine.farm;

import com.enderio.core.api.client.gui.IGuiScreen;
import com.enderio.core.api.client.render.IWidgetIcon;
import com.enderio.core.client.gui.button.IconButton;
import com.enderio.core.client.gui.button.ToggleButton;
import com.enderio.core.client.render.ColorUtil;
import com.enderio.core.client.render.RenderUtil;
import com.enderio.core.common.vecmath.Vector4f;
import crazypants.enderio.EnderIO;
import crazypants.enderio.gui.IconEIO;
import crazypants.enderio.machine.farm.FarmStationContainer;
import crazypants.enderio.machine.farm.TileFarmStation;
import crazypants.enderio.machine.gui.GuiPoweredMachineBase;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.Slot;
import org.lwjgl.opengl.GL11;

public class GuiFarmStation
extends GuiPoweredMachineBase<TileFarmStation> {
    private static final int LOCK_ID = 1234;

    public GuiFarmStation(InventoryPlayer par1InventoryPlayer, TileFarmStation machine) {
        super(machine, (Container)new FarmStationContainer(par1InventoryPlayer, machine), "farmStation");
        this.setYSize(this.ySize + 3);
    }

    @Override
    public void initGui() {
        super.initGui();
        int x = this.getGuiLeft() + 36;
        int y = this.getGuiTop() + 43;
        this.buttonList.add(this.createLockButton(5, x, y));
        this.buttonList.add(this.createLockButton(6, x + 52, y));
        this.buttonList.add(this.createLockButton(7, x, y + 20));
        this.buttonList.add(this.createLockButton(8, x + 52, y + 20));
        ((FarmStationContainer)this.inventorySlots).createGhostSlots(this.getGhostSlots());
    }

    private IconButton createLockButton(int slot, int x, int y) {
        return new ToggleButton((IGuiScreen)this, 1234 + slot, x, y, (IWidgetIcon)IconEIO.LOCK_UNLOCKED, (IWidgetIcon)IconEIO.LOCK_LOCKED).setSelected(((TileFarmStation)this.getTileEntity()).isSlotLocked(slot));
    }

    protected void drawForegroundImpl(int mouseX, int mouseY) {
        super.drawForegroundImpl(mouseX, mouseY);
        if (!this.isConfigOverlayEnabled()) {
            for (int i = 5; i <= 8; ++i) {
                if (!((TileFarmStation)this.getTileEntity()).isSlotLocked(i)) continue;
                Slot slot = this.inventorySlots.getSlot(i);
                GL11.glEnable((int)3042);
                RenderUtil.renderQuad2D((double)slot.xDisplayPosition, (double)slot.yDisplayPosition, (double)0.0, (double)16.0, (double)16.0, (Vector4f)new Vector4f(0.0, 0.0, 0.0, 0.5));
            }
        }
    }

    @Override
    protected void drawGuiContainerBackgroundLayer(float par1, int par2, int par3) {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.bindGuiTexture();
        int sx = (this.width - this.xSize) / 2;
        int sy = (this.height - this.ySize) / 2;
        this.drawTexturedModalRect(sx, sy, 0, 0, this.xSize, this.ySize);
        FontRenderer fr = Minecraft.getMinecraft().fontRenderer;
        GL11.glEnable((int)3042);
        fr.drawString("SW", sx + 55, sy + 48, ColorUtil.getARGB((float)1.0f, (float)1.0f, (float)0.35f, (float)1.0f), true);
        fr.drawString("NW", sx + 55, sy + 66, ColorUtil.getARGB((float)1.0f, (float)1.0f, (float)0.35f, (float)1.0f), true);
        fr.drawString("SE", sx + 73, sy + 48, ColorUtil.getARGB((float)1.0f, (float)1.0f, (float)0.35f, (float)1.0f), true);
        fr.drawString("NE", sx + 73, sy + 66, ColorUtil.getARGB((float)1.0f, (float)1.0f, (float)0.35f, (float)1.0f), true);
        GL11.glDisable((int)3042);
        this.bindGuiTexture();
        super.drawGuiContainerBackgroundLayer(par1, par2, par3);
    }

    protected void actionPerformed(GuiButton b) {
        if (b.id >= 1239 && b.id <= 1242) {
            ((TileFarmStation)this.getTileEntity()).toggleLockedState(b.id - 1234);
        }
        super.actionPerformed(b);
    }

    @Override
    protected boolean showRecipeButton() {
        return false;
    }

    @Override
    protected String getPowerOutputLabel() {
        return EnderIO.lang.localize("farm.gui.baseUse");
    }

    @Override
    protected int getPowerHeight() {
        return super.getPowerHeight() + 3;
    }
}

