/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.machine.farm;

import com.enderio.core.client.gui.widget.GhostBackgroundItemSlot;
import com.enderio.core.client.gui.widget.GhostSlot;
import cpw.mods.fml.common.registry.GameRegistry;
import crazypants.enderio.config.Config;
import crazypants.enderio.item.darksteel.DarkSteelItems;
import crazypants.enderio.machine.farm.TileFarmStation;
import crazypants.enderio.machine.farm.farmers.RubberTreeFarmerIC2;
import crazypants.enderio.machine.gui.AbstractMachineContainer;
import java.awt.Point;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.inventory.Slot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;

public class FarmStationContainer
extends AbstractMachineContainer<TileFarmStation> {
    private static final Item[] slotItems1;
    private static final List<ItemStack> slotItemsStacks1;
    private static final Item[] slotItems2;
    private static final Item[] slotItems3;
    public static final List<ItemStack> slotItemsSeeds;
    public static final List<ItemStack> slotItemsProduce;
    public static final List<ItemStack> slotItemsFertilizer;
    private static final Random rand;
    private static final int ROW_TOOLS = 19;
    private static final int ROW_IO = 44;
    private static final int COL_TOOLS = 44;
    private static final int COL_INPUT = 53;
    private static final int COL_FERTILIZER = 116;
    private static final int COL_OUTPUT = 107;
    private static final int SLOT_SIZE = 18;
    private static final int ONE = 0;
    private static final int TWO = 18;
    private static final int THREE = 36;
    private static final Point[] points;

    public FarmStationContainer(InventoryPlayer inventory, TileFarmStation te) {
        super(inventory, te);
    }

    @Override
    protected void addMachineSlots(InventoryPlayer playerInv) {
        int i = 0;
        for (Point p : points) {
            final int slot = i++;
            this.addSlotToContainer(new Slot(this.getInv(), slot, p.x, p.y){

                public boolean isItemValid(ItemStack itemStack) {
                    return ((TileFarmStation)FarmStationContainer.this.getInv()).isItemValidForSlot(slot, itemStack);
                }

                public int getSlotStackLimit() {
                    return ((TileFarmStation)FarmStationContainer.this.getInv()).getInventoryStackLimit(slot);
                }
            });
        }
    }

    private static void clean(List list) {
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            Object o = iterator.next();
            if (o != null && (!(o instanceof ItemStack) || ((ItemStack)o).getItem() != null)) continue;
            iterator.remove();
        }
    }

    public void createGhostSlots(List<GhostSlot> slots) {
        int i;
        FarmStationContainer.clean(slotItemsStacks1);
        FarmStationContainer.clean(slotItemsFertilizer);
        FarmStationContainer.clean(slotItemsSeeds);
        FarmStationContainer.clean(slotItemsProduce);
        slots.add((GhostSlot)new GhostBackgroundItemSlot(slotItemsStacks1.get(rand.nextInt(slotItemsStacks1.size())), FarmStationContainer.points[0].x, FarmStationContainer.points[0].y));
        slots.add((GhostSlot)new GhostBackgroundItemSlot(slotItems2[rand.nextInt(slotItems2.length)], FarmStationContainer.points[1].x, FarmStationContainer.points[1].y));
        slots.add((GhostSlot)new GhostBackgroundItemSlot(slotItems3[rand.nextInt(slotItems3.length)], FarmStationContainer.points[2].x, FarmStationContainer.points[2].y));
        slots.add((GhostSlot)new GhostBackgroundItemSlot(slotItemsFertilizer.get(rand.nextInt(slotItemsFertilizer.size())), FarmStationContainer.points[3].x, FarmStationContainer.points[3].y));
        slots.add((GhostSlot)new GhostBackgroundItemSlot(slotItemsFertilizer.get(rand.nextInt(slotItemsFertilizer.size())), FarmStationContainer.points[4].x, FarmStationContainer.points[4].y));
        for (i = 0; i < 4; ++i) {
            slots.add((GhostSlot)new GhostBackgroundItemSlot(slotItemsSeeds.get(rand.nextInt(slotItemsSeeds.size())), FarmStationContainer.points[5 + i].x, FarmStationContainer.points[5 + i].y));
        }
        for (i = 0; i < 6; ++i) {
            slots.add((GhostSlot)new GhostBackgroundItemSlot(slotItemsProduce.get(rand.nextInt(slotItemsProduce.size())), FarmStationContainer.points[9 + i].x, FarmStationContainer.points[9 + i].y));
        }
    }

    @Override
    public Point getPlayerInventoryOffset() {
        return new Point(8, 87);
    }

    @Override
    public Point getUpgradeOffset() {
        return new Point(12, 63);
    }

    static {
        Item[] itemArray;
        slotItems1 = new Item[]{Items.wooden_hoe, Items.stone_hoe, Items.iron_hoe, Items.golden_hoe, Items.diamond_hoe};
        slotItemsStacks1 = new ArrayList<ItemStack>();
        for (Item item : slotItems1) {
            slotItemsStacks1.add(new ItemStack(item));
        }
        slotItemsStacks1.addAll(Config.farmHoes);
        slotItems2 = new Item[]{Items.wooden_axe, Items.stone_axe, Items.iron_axe, Items.golden_axe, Items.diamond_axe, DarkSteelItems.itemDarkSteelAxe};
        if (RubberTreeFarmerIC2.treeTap != null) {
            Item[] itemArray2 = new Item[3];
            itemArray2[0] = Items.shears;
            itemArray2[1] = DarkSteelItems.itemDarkSteelShears;
            itemArray = itemArray2;
            itemArray2[2] = GameRegistry.findItem((String)"IC2", (String)"itemTreetap");
        } else {
            Item[] itemArray3 = new Item[2];
            itemArray3[0] = Items.shears;
            itemArray = itemArray3;
            itemArray3[1] = DarkSteelItems.itemDarkSteelShears;
        }
        slotItems3 = itemArray;
        slotItemsSeeds = new ArrayList<ItemStack>();
        slotItemsSeeds.add(new ItemStack(Items.wheat_seeds));
        slotItemsSeeds.add(new ItemStack(Blocks.carrots));
        slotItemsSeeds.add(new ItemStack(Blocks.potatoes));
        slotItemsSeeds.add(new ItemStack((Block)Blocks.red_mushroom));
        slotItemsSeeds.add(new ItemStack((Block)Blocks.brown_mushroom));
        slotItemsSeeds.add(new ItemStack(Blocks.nether_wart));
        slotItemsSeeds.add(new ItemStack(Blocks.sapling));
        slotItemsSeeds.add(new ItemStack(Items.reeds));
        slotItemsProduce = new ArrayList<ItemStack>();
        slotItemsProduce.add(new ItemStack(Blocks.log, 1, 0));
        slotItemsProduce.add(new ItemStack(Blocks.wheat));
        slotItemsProduce.add(new ItemStack((Block)Blocks.leaves, 1, 0));
        slotItemsProduce.add(new ItemStack(Items.apple));
        slotItemsFertilizer = new ArrayList<ItemStack>();
        slotItemsFertilizer.add(new ItemStack(Items.dye, 1, 15));
        rand = new Random();
        points = new Point[]{new Point(44, 19), new Point(62, 19), new Point(80, 19), new Point(116, 19), new Point(134, 19), new Point(53, 44), new Point(71, 44), new Point(53, 62), new Point(71, 62), new Point(107, 44), new Point(125, 44), new Point(143, 44), new Point(107, 62), new Point(125, 62), new Point(143, 62)};
    }
}

