/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.machine.enchanter;

import com.enderio.core.api.client.gui.IResourceTooltipProvider;
import com.enderio.core.common.util.Util;
import cpw.mods.fml.common.network.IGuiHandler;
import crazypants.enderio.BlockEio;
import crazypants.enderio.EnderIO;
import crazypants.enderio.ModObject;
import crazypants.enderio.machine.enchanter.ContainerEnchanter;
import crazypants.enderio.machine.enchanter.GuiEnchanter;
import crazypants.enderio.machine.enchanter.TileEnchanter;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;

public class BlockEnchanter
extends BlockEio
implements IGuiHandler,
IResourceTooltipProvider {
    public static int renderId = -1;

    public static BlockEnchanter create() {
        BlockEnchanter res = new BlockEnchanter();
        res.init();
        return res;
    }

    protected BlockEnchanter() {
        super(ModObject.blockEnchanter.unlocalisedName, TileEnchanter.class);
        this.setBlockTextureName("enderio:blockEnchanter");
        this.setLightOpacity(4);
    }

    protected void init() {
        super.init();
        EnderIO.guiHandler.registerGuiHandler(91, this);
    }

    public void onBlockPlacedBy(World world, int x, int y, int z, EntityLivingBase player, ItemStack stack) {
        super.onBlockPlacedBy(world, x, y, z, player, stack);
        int heading = MathHelper.floor_double((double)((double)(player.rotationYaw * 4.0f / 360.0f) + 0.5)) & 3;
        TileEnchanter te = (TileEnchanter)world.getTileEntity(x, y, z);
        switch (heading) {
            case 0: {
                te.setFacing((short)2);
                break;
            }
            case 1: {
                te.setFacing((short)5);
                break;
            }
            case 2: {
                te.setFacing((short)3);
                break;
            }
            case 3: {
                te.setFacing((short)4);
                break;
            }
        }
        if (world.isRemote) {
            return;
        }
        world.markBlockForUpdate(x, y, z);
    }

    protected boolean openGui(World world, int x, int y, int z, EntityPlayer entityPlayer, int side) {
        if (!world.isRemote) {
            entityPlayer.openGui((Object)EnderIO.instance, 91, world, x, y, z);
        }
        return true;
    }

    public void breakBlock(World world, int x, int y, int z, Block block, int meta) {
        TileEntity te = world.getTileEntity(x, y, z);
        if (te instanceof TileEnchanter) {
            this.dropItems(world, x, y, z, (TileEnchanter)te);
        }
        super.breakBlock(world, x, y, z, block, meta);
    }

    public boolean doNormalDrops(World world, int x, int y, int z) {
        return false;
    }

    private void dropItems(World world, int x, int y, int z, TileEnchanter te) {
        if (te.getStackInSlot(0) != null) {
            Util.dropItems((World)world, (ItemStack)te.getStackInSlot(0), (int)x, (int)y, (int)z, (boolean)true);
        }
        if (te.getStackInSlot(1) != null) {
            Util.dropItems((World)world, (ItemStack)te.getStackInSlot(1), (int)x, (int)y, (int)z, (boolean)true);
        }
    }

    public int quantityDropped(Random p_149745_1_) {
        return 0;
    }

    public int getRenderType() {
        return renderId;
    }

    public boolean isOpaqueCube() {
        return false;
    }

    public boolean renderAsNormalBlock() {
        return false;
    }

    public Object getServerGuiElement(int ID, EntityPlayer player, World world, int x, int y, int z) {
        TileEntity te = world.getTileEntity(x, y, z);
        if (te instanceof TileEnchanter) {
            return new ContainerEnchanter(player, player.inventory, (TileEnchanter)te);
        }
        return null;
    }

    public Object getClientGuiElement(int ID, EntityPlayer player, World world, int x, int y, int z) {
        TileEntity te = world.getTileEntity(x, y, z);
        if (te instanceof TileEnchanter) {
            return new GuiEnchanter(player, player.inventory, (TileEnchanter)te);
        }
        return null;
    }

    public String getUnlocalizedNameForTooltip(ItemStack itemStack) {
        return this.getUnlocalizedName();
    }
}

