/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.machine.crafter;

import com.enderio.core.client.gui.widget.GhostSlot;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import crazypants.enderio.machine.crafter.PacketCrafter;
import crazypants.enderio.machine.crafter.TileCrafter;
import crazypants.enderio.machine.gui.AbstractMachineContainer;
import crazypants.enderio.network.PacketHandler;
import java.awt.Point;
import java.util.List;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;

public class ContainerCrafter
extends AbstractMachineContainer<TileCrafter> {
    public ContainerCrafter(InventoryPlayer playerInv, TileCrafter te) {
        super(playerInv, te);
    }

    public void addCrafterSlots(List<GhostSlot> ghostSlots) {
        int topY = 16;
        int leftX = 31;
        int index = 0;
        for (int row = 0; row < 3; ++row) {
            for (int col = 0; col < 3; ++col) {
                int x = leftX + col * 18;
                int y = topY + row * 18;
                ghostSlots.add(new DummySlot(index, x, y));
                ++index;
            }
        }
        ghostSlots.add(new DummySlot(9, 90, 34));
    }

    @Override
    public Point getPlayerInventoryOffset() {
        return new Point(30, 84);
    }

    @Override
    public Point getUpgradeOffset() {
        return new Point(6, 60);
    }

    @Override
    protected void addMachineSlots(InventoryPlayer playerInv) {
        int topY = 16;
        int leftX = 113;
        int index = 0;
        for (int row = 0; row < 3; ++row) {
            for (int col = 0; col < 3; ++col) {
                int x = leftX + col * 18;
                int y = topY + row * 18;
                this.addSlotToContainer(new InputSlot(this.getInv(), index, x, y));
                ++index;
            }
        }
        this.addSlotToContainer(new Slot(this.getInv(), 9, 172, 34){

            public boolean isItemValid(ItemStack itemStack) {
                return false;
            }
        });
    }

    private class DummySlot
    extends GhostSlot {
        private final int slotIndex;

        public DummySlot(int slotIndex, int x, int y) {
            this.slotIndex = slotIndex;
            this.x = x;
            this.y = y;
        }

        public ItemStack getStack() {
            return ((TileCrafter)ContainerCrafter.this.getInv()).craftingGrid.getStackInSlot(this.slotIndex);
        }

        public void putStack(ItemStack stack) {
            if (this.slotIndex >= 9) {
                return;
            }
            if (stack != null) {
                stack = stack.copy();
                stack.stackSize = 1;
            }
            PacketHandler.INSTANCE.sendToServer((IMessage)PacketCrafter.setSlot((TileCrafter)ContainerCrafter.this.getInv(), this.slotIndex, stack));
        }
    }

    private class InputSlot
    extends Slot {
        public InputSlot(IInventory par1iInventory, int par2, int par3, int par4) {
            super(par1iInventory, par2, par3, par4);
        }

        public boolean isItemValid(ItemStack itemStack) {
            ItemStack refStack = ((TileCrafter)ContainerCrafter.this.getInv()).craftingGrid.getStackInSlot(this.slotNumber);
            if (refStack == null || itemStack == null) {
                return false;
            }
            return TileCrafter.compareDamageable(itemStack, refStack);
        }
    }
}

