/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.machine.capbank.render;

import com.enderio.core.client.render.BoundingBox;
import com.enderio.core.client.render.RenderUtil;
import com.enderio.core.common.util.BlockCoord;
import com.enderio.core.common.util.ForgeDirectionOffsets;
import com.enderio.core.common.vecmath.Vector3d;
import com.enderio.core.common.vecmath.Vector4f;
import com.enderio.core.common.vecmath.Vertex;
import crazypants.enderio.EnderIO;
import crazypants.enderio.machine.capbank.CapBankType;
import crazypants.enderio.machine.capbank.InfoDisplayType;
import crazypants.enderio.machine.capbank.TileCapBank;
import crazypants.enderio.machine.capbank.network.CapBankClientNetwork;
import crazypants.enderio.machine.capbank.render.IInfoRenderer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.client.resources.IResourceManagerReloadListener;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class FillGauge
implements IInfoRenderer,
IResourceManagerReloadListener {
    private static final double HEIGHT = 0.75;
    private static final double VERT_BORDER = 0.125;
    private static final double WIDTH = 0.25;
    private IIcon barIcon;
    private IIcon gaugeIcon;
    private float barHeightV;
    private Map<GaugeKey, List<Vertex>> gaugeVertexCache;
    private Map<GaugeKey, List<Vertex>> levelVertexCache;
    private float barMinV;

    FillGauge() {
        RenderUtil.registerReloadListener((IResourceManagerReloadListener)this);
    }

    @Override
    public void render(TileCapBank cb, ForgeDirection dir, double x, double y, double z, float partialTick) {
        CapBankClientNetwork nw = null;
        if (cb.getNetwork() != null) {
            nw = (CapBankClientNetwork)cb.getNetwork();
            nw.requestPowerUpdate(cb, 20);
        }
        int brightness = cb.getWorldObj().getLightBrightnessForSkyBlocks(cb.xCoord + dir.offsetX, cb.yCoord + dir.offsetY, cb.zCoord + dir.offsetZ, 0);
        GaugeInfo info = this.getGaugeInfo(cb, dir);
        GaugeKey key = new GaugeKey(dir, info.type);
        this.doRender(nw, brightness, info, key);
    }

    public void doRender(CapBankClientNetwork nw, int brightness, GaugeInfo info, GaugeKey key) {
        if (this.gaugeVertexCache == null) {
            this.createVertexCache();
        }
        RenderUtil.bindBlockTexture();
        Tessellator tes = Tessellator.instance;
        tes.startDrawingQuads();
        tes.setBrightness(brightness);
        tes.setColorOpaque_F(1.0f, 1.0f, 1.0f);
        List<Vertex> verts = this.gaugeVertexCache.get(key);
        RenderUtil.addVerticesToTessellator(verts, (Tessellator)Tessellator.instance);
        this.renderFillBar(key, nw, info);
        tes.draw();
    }

    private void renderFillBar(GaugeKey key, CapBankClientNetwork nw, GaugeInfo info) {
        double ratio = 0.0;
        if (nw != null) {
            ratio = nw.getEnergyStoredRatio();
        }
        if (ratio <= 0.0) {
            return;
        }
        double maxY = ratio * (double)info.height;
        if (maxY <= (double)info.yPosition) {
            return;
        }
        Vector3d offset = ForgeDirectionOffsets.offsetScaled((ForgeDirection)key.dir, (double)0.005);
        Tessellator.instance.addTranslation((float)offset.x, (float)offset.y, (float)offset.z);
        List<Vertex> verts = this.levelVertexCache.get(key);
        if (maxY >= (double)(info.yPosition + 1)) {
            RenderUtil.addVerticesToTessellator(verts, (Tessellator)Tessellator.instance);
        } else {
            double myMaxY = maxY - (double)info.yPosition;
            if (info.type == Type.BOTTOM || info.type == Type.SINGLE) {
                myMaxY = Math.max(0.2, myMaxY);
            }
            ArrayList<Vertex> newVerts = new ArrayList<Vertex>();
            for (Vertex v : verts) {
                v = new Vertex(v);
                newVerts.add(v);
                if (!(v.y() > myMaxY)) continue;
                v.setXYZ(v.x(), myMaxY, v.z());
                v.setUV((double)v.u(), (double)(this.barMinV + (float)(myMaxY * (double)this.barHeightV)));
            }
            RenderUtil.addVerticesToTessellator(newVerts, (Tessellator)Tessellator.instance);
        }
        offset.scale(-1.0);
        Tessellator.instance.addTranslation((float)offset.x, (float)offset.y, (float)offset.z);
    }

    private GaugeInfo getGaugeInfo(TileCapBank cb, ForgeDirection dir) {
        if (!cb.getType().isMultiblock()) {
            return new GaugeInfo(1, 0);
        }
        int height = 1;
        int yPos = 0;
        BlockCoord loc = cb.getLocation();
        boolean found = true;
        while (found) {
            loc = loc.getLocation(ForgeDirection.UP);
            if (this.isGaugeType(cb.getWorldObj(), loc, dir, cb.getType())) {
                ++height;
                continue;
            }
            found = false;
        }
        loc = cb.getLocation();
        found = true;
        while (found) {
            loc = loc.getLocation(ForgeDirection.DOWN);
            if (this.isGaugeType(cb.getWorldObj(), loc, dir, cb.getType())) {
                ++height;
                ++yPos;
                continue;
            }
            found = false;
        }
        return new GaugeInfo(height, yPos);
    }

    private boolean isGaugeType(World worldObj, BlockCoord bc, ForgeDirection face, CapBankType type) {
        TileEntity te = worldObj.getTileEntity(bc.x, bc.y, bc.z);
        if (te instanceof TileCapBank) {
            TileCapBank cb = (TileCapBank)te;
            return type == cb.getType() && cb.getDisplayType(face) == InfoDisplayType.LEVEL_BAR;
        }
        return false;
    }

    public void onResourceManagerReload(IResourceManager p_110549_1_) {
        this.createVertexCache();
    }

    private void createVertexCache() {
        this.barIcon = EnderIO.blockCapBank.getFillBarIcon();
        this.barMinV = this.barIcon.getMinV();
        this.barHeightV = this.barIcon.getMaxV() - this.barIcon.getMinV();
        this.gaugeIcon = EnderIO.blockCapBank.getGaugeIcon();
        this.gaugeVertexCache = new HashMap<GaugeKey, List<Vertex>>();
        this.levelVertexCache = new HashMap<GaugeKey, List<Vertex>>();
        for (ForgeDirection dir : ForgeDirection.VALID_DIRECTIONS) {
            if (dir.offsetY != 0) continue;
            for (Type type : Type.values()) {
                GaugeKey key = new GaugeKey(dir, type);
                this.gaugeVertexCache.put(key, this.createGaugeBoundForFace(key, this.gaugeIcon));
                this.levelVertexCache.put(key, this.createGaugeBoundForFace(key, this.barIcon));
            }
        }
    }

    protected List<Vertex> createGaugeBoundForFace(GaugeKey key, IIcon icon) {
        ForgeDirection dir = key.dir;
        Type type = key.type;
        double widthScale = 0.25;
        double heightScale = 0.8;
        double xScale = dir.offsetX == 0 ? widthScale : 1.0;
        double yScale = 1.0;
        double zScale = dir.offsetZ == 0 ? widthScale : 1.0;
        BoundingBox bb = BoundingBox.UNIT_CUBE;
        Vector3d off = ForgeDirectionOffsets.forDirCopy((ForgeDirection)dir);
        off.scale(-1.0);
        bb = bb.translate(off);
        bb = bb.scale(xScale, yScale, zScale);
        off.scale(-1.0);
        bb = bb.translate(off);
        Vector4f uv = this.getUvForType(key.type, icon);
        List result = bb.getCornersWithUvForFace(dir, uv.x, uv.y, uv.z, uv.w);
        return result;
    }

    private Vector4f getUvForType(Type type, IIcon icon) {
        double uWidth = (icon.getMaxU() - icon.getMinU()) / 4.0f;
        Vector4f res = new Vector4f();
        res.x = (float)((double)icon.getMinU() + (double)type.ordinal() * uWidth);
        res.y = (float)((double)res.x + uWidth);
        res.z = icon.getMinV();
        res.w = icon.getMaxV();
        return res;
    }

    static class GaugeKey {
        ForgeDirection dir;
        Type type;

        GaugeKey(ForgeDirection dir, Type type) {
            this.dir = dir;
            this.type = type;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.dir == null ? 0 : this.dir.hashCode());
            result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            GaugeKey other = (GaugeKey)obj;
            if (this.dir != other.dir) {
                return false;
            }
            return this.type == other.type;
        }
    }

    static class GaugeInfo {
        int height;
        int yPosition;
        Type type;

        GaugeInfo(int height, int position) {
            this.height = height;
            this.yPosition = position;
            this.type = this.calcType();
        }

        Type calcType() {
            if (this.height == 1) {
                return Type.SINGLE;
            }
            if (this.yPosition == 0) {
                return Type.BOTTOM;
            }
            if (this.yPosition == this.height - 1) {
                return Type.TOP;
            }
            return Type.MIDDLE;
        }
    }

    static enum Type {
        SINGLE,
        TOP,
        BOTTOM,
        MIDDLE;

    }
}

