/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.machine.capbank.network;

import cofh.api.energy.IEnergyContainerItem;
import crazypants.enderio.EnderIO;
import crazypants.enderio.machine.capbank.TileCapBank;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;

public class InventoryImpl
implements IInventory {
    private ItemStack[] inventory;
    private TileCapBank capBank;

    public static boolean isInventoryEmtpy(TileCapBank cap) {
        for (ItemStack st : cap.getInventory()) {
            if (st == null) continue;
            return false;
        }
        return true;
    }

    public static boolean isInventoryEmtpy(ItemStack[] inv) {
        if (inv == null) {
            return true;
        }
        for (ItemStack st : inv) {
            if (st == null) continue;
            return false;
        }
        return true;
    }

    public TileCapBank getCapBank() {
        return this.capBank;
    }

    public void setCapBank(TileCapBank cap) {
        this.capBank = cap;
        if (cap == null) {
            this.inventory = null;
            return;
        }
        this.inventory = cap.getInventory();
    }

    public boolean isEmtpy() {
        return InventoryImpl.isInventoryEmtpy(this.inventory);
    }

    public ItemStack[] getStacks() {
        return this.inventory;
    }

    public ItemStack getStackInSlot(int slot) {
        if (this.inventory == null) {
            return null;
        }
        if (slot < 0 || slot >= this.inventory.length) {
            return null;
        }
        return this.inventory[slot];
    }

    public ItemStack decrStackSize(int fromSlot, int amount) {
        if (this.inventory == null) {
            return null;
        }
        if (fromSlot < 0 || fromSlot >= this.inventory.length) {
            return null;
        }
        ItemStack item = this.inventory[fromSlot];
        if (item == null) {
            return null;
        }
        if (item.stackSize <= amount) {
            ItemStack result = item.copy();
            this.inventory[fromSlot] = null;
            return result;
        }
        item.stackSize -= amount;
        return item.copy();
    }

    public void setInventorySlotContents(int slot, ItemStack itemstack) {
        if (this.inventory == null) {
            return;
        }
        if (slot < 0 || slot >= this.inventory.length) {
            return;
        }
        this.inventory[slot] = itemstack;
    }

    public int getSizeInventory() {
        return 4;
    }

    public ItemStack getStackInSlotOnClosing(int p_70304_1_) {
        return null;
    }

    public String getInventoryName() {
        return EnderIO.blockCapBank.getUnlocalizedName() + ".name";
    }

    public boolean hasCustomInventoryName() {
        return false;
    }

    public int getInventoryStackLimit() {
        return 1;
    }

    public boolean isUseableByPlayer(EntityPlayer p_70300_1_) {
        return true;
    }

    public boolean isItemValidForSlot(int slot, ItemStack itemstack) {
        if (itemstack == null) {
            return false;
        }
        return itemstack.getItem() instanceof IEnergyContainerItem;
    }

    public void openInventory() {
    }

    public void closeInventory() {
    }

    public void markDirty() {
    }
}

