/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.machine.capbank.network;

import cofh.api.energy.IEnergyContainerItem;
import com.enderio.core.common.util.BlockCoord;
import com.enderio.core.common.util.RoundRobinIterator;
import cpw.mods.fml.common.gameevent.TickEvent;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import crazypants.enderio.conduit.ConduitNetworkTickHandler;
import crazypants.enderio.conduit.ConnectionMode;
import crazypants.enderio.conduit.power.IPowerConduit;
import crazypants.enderio.machine.IoMode;
import crazypants.enderio.machine.RedstoneControlMode;
import crazypants.enderio.machine.capbank.CapBankType;
import crazypants.enderio.machine.capbank.TileCapBank;
import crazypants.enderio.machine.capbank.network.EnergyReceptor;
import crazypants.enderio.machine.capbank.network.ICapBankNetwork;
import crazypants.enderio.machine.capbank.network.InventoryImpl;
import crazypants.enderio.machine.capbank.network.NetworkState;
import crazypants.enderio.machine.capbank.network.NetworkUtil;
import crazypants.enderio.machine.capbank.packet.PacketNetworkEnergyResponse;
import crazypants.enderio.machine.capbank.packet.PacketNetworkStateResponse;
import crazypants.enderio.network.PacketHandler;
import crazypants.enderio.power.IPowerInterface;
import crazypants.enderio.power.IPowerStorage;
import crazypants.enderio.power.PerTickIntAverageCalculator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class CapBankNetwork
implements ICapBankNetwork {
    private static final int IO_CAP = 2000000000;
    private final List<TileCapBank> capBanks = new ArrayList<TileCapBank>();
    private final Set<EnergyReceptor> receptors = new HashSet<EnergyReceptor>();
    private RoundRobinIterator<EnergyReceptor> receptorIterator;
    private final int id;
    private int maxIO;
    private int maxInput = -1;
    private int maxOutput = -1;
    private long timeAtLastApply;
    private long energyStored;
    private long prevEnergyStored = -1L;
    private long energyReceived;
    private long energySend;
    private long maxEnergyStored;
    private CapBankType type;
    private final Set<BlockCoord> redstoneRecievers = new HashSet<BlockCoord>();
    private RedstoneControlMode inputControlMode = RedstoneControlMode.IGNORE;
    private RedstoneControlMode outputControlMode = RedstoneControlMode.IGNORE;
    private boolean inputRedstoneConditionMet = true;
    private boolean outputRedstoneConditionMet = true;
    private final ConduitNetworkTickHandler.TickListener tickListener = new TickReciever();
    private final PerTickIntAverageCalculator powerTrackerIn = new PerTickIntAverageCalculator(2);
    private final PerTickIntAverageCalculator powerTrackerOut = new PerTickIntAverageCalculator(2);
    private final InventoryImpl inventory = new InventoryImpl();
    private boolean firstUpate = true;

    public CapBankNetwork(int id) {
        this.id = id;
    }

    public void init(TileCapBank cap, Collection<TileCapBank> neighbours, World world) {
        if (world.isRemote) {
            throw new UnsupportedOperationException();
        }
        this.type = cap.getType();
        this.inputControlMode = cap.getInputControlMode();
        this.outputControlMode = cap.getOutputControlMode();
        for (TileCapBank con : neighbours) {
            ICapBankNetwork network = con.getNetwork();
            if (network == null) continue;
            network.destroyNetwork();
        }
        this.setNetwork(world, cap);
    }

    protected void setNetwork(World world, TileCapBank cap) {
        if (cap == null) {
            return;
        }
        HashSet<TileCapBank> work = new HashSet<TileCapBank>();
        while (true) {
            ICapBankNetwork network;
            if ((network = cap.getNetwork()) != this) {
                if (network != null) {
                    network.destroyNetwork();
                }
                if (cap.setNetwork(this)) {
                    this.addMember(cap);
                    NetworkUtil.getNeigbours(cap, work);
                }
            }
            if (work.isEmpty()) {
                return;
            }
            Iterator iter = work.iterator();
            cap = (TileCapBank)iter.next();
            iter.remove();
        }
    }

    @Override
    public void destroyNetwork() {
        this.distributeEnergyToBanks();
        TileCapBank cap = null;
        for (TileCapBank cb : this.capBanks) {
            cb.setNetwork(null);
            if (cap != null) continue;
            cap = cb;
        }
        this.capBanks.clear();
        if (cap != null) {
            PacketHandler.INSTANCE.sendToAll((IMessage)new PacketNetworkStateResponse(this, true));
        }
    }

    @Override
    public Collection<TileCapBank> getMembers() {
        return this.capBanks;
    }

    @Override
    public void addMember(TileCapBank cap) {
        if (!this.capBanks.contains(cap)) {
            this.capBanks.add(cap);
            long newIO = this.maxIO + cap.getType().getMaxIO();
            if (newIO > 2000000000L) {
                newIO = 2000000000L;
            }
            this.maxIO = (int)newIO;
            this.energyStored += (long)cap.getEnergyStored();
            this.maxEnergyStored += (long)cap.getMaxEnergyStored();
            if (this.maxInput == -1) {
                this.maxInput = cap.getMaxInputOverride();
            }
            if (this.maxOutput == -1) {
                this.maxOutput = cap.getMaxOutputOverride();
            }
            cap.setInputControlMode(this.inputControlMode);
            cap.setOutputControlMode(this.outputControlMode);
            List<EnergyReceptor> recs = cap.getReceptors();
            if (!recs.isEmpty()) {
                this.addReceptors(recs);
            }
            if (this.inventory.isEmtpy()) {
                this.inventory.setCapBank(cap);
            } else if (!InventoryImpl.isInventoryEmtpy(cap)) {
                if (this.inventory.isEmtpy()) {
                    this.inventory.setCapBank(cap);
                } else {
                    cap.dropItems();
                }
            }
        }
    }

    @Override
    public InventoryImpl getInventory() {
        return this.inventory;
    }

    @Override
    public int getId() {
        return this.id;
    }

    @Override
    public NetworkState getState() {
        return new NetworkState(this);
    }

    @Override
    public void onUpdateEntity(TileCapBank tileCapBank) {
        World world = tileCapBank.getWorldObj();
        if (world == null) {
            return;
        }
        if (world.isRemote) {
            return;
        }
        long curTime = world.getTotalWorldTime();
        if (curTime != this.timeAtLastApply) {
            this.timeAtLastApply = curTime;
            ConduitNetworkTickHandler.instance.addListener(this.tickListener);
        }
    }

    private void doNetworkTick() {
        this.chargeItems(this.inventory.getStacks());
        this.transmitEnergy();
        if (this.energyStored != this.prevEnergyStored) {
            this.distributeEnergyToBanks();
        }
        this.powerTrackerIn.tick(this.energyReceived);
        this.powerTrackerOut.tick(this.energySend);
        this.prevEnergyStored = this.energyStored;
        this.energyReceived = 0L;
        this.energySend = 0L;
        if (this.firstUpate) {
            if (!this.capBanks.isEmpty()) {
                PacketHandler.sendToAllAround(new PacketNetworkStateResponse(this), (TileEntity)this.capBanks.get(0));
                PacketHandler.sendToAllAround(new PacketNetworkEnergyResponse(this), (TileEntity)this.capBanks.get(0));
            }
            this.firstUpate = false;
        }
    }

    private void transmitEnergy() {
        if (!this.outputRedstoneConditionMet) {
            return;
        }
        if (this.receptors.isEmpty()) {
            return;
        }
        int available = this.getEnergyAvailableForTick(this.getMaxOutput());
        if (available <= 0) {
            return;
        }
        if (this.receptorIterator == null) {
            ArrayList<EnergyReceptor> rl = new ArrayList<EnergyReceptor>(this.receptors);
            this.receptorIterator = new RoundRobinIterator(rl);
        }
        int totalSent = 0;
        Iterator iter = this.receptorIterator.iterator();
        while (available > 0 && iter.hasNext()) {
            int sent = this.sendPowerTo((EnergyReceptor)iter.next(), available);
            totalSent += sent;
            available -= sent;
        }
        this.addEnergy(-totalSent);
    }

    protected int getEnergyAvailableForTick(int limit) {
        int available = this.energyStored > (long)limit ? limit : (int)this.energyStored;
        return available;
    }

    private int sendPowerTo(EnergyReceptor next, int available) {
        IPowerConduit con = next.getConduit();
        if (con != null && next.getMode() == IoMode.NONE && con.getConnectionMode(next.getDir().getOpposite()) == ConnectionMode.IN_OUT) {
            return 0;
        }
        IPowerInterface inf = next.getReceptor();
        int result = inf.recieveEnergy(next.getDir().getOpposite(), available);
        if (result < 0) {
            result = 0;
        }
        return result;
    }

    public boolean chargeItems(ItemStack[] items) {
        if (items == null) {
            return false;
        }
        boolean chargedItem = false;
        int available = this.getEnergyAvailableForTick(this.getMaxIO());
        for (ItemStack item : items) {
            int canUse;
            int used;
            if (item == null || available <= 0 || item.stackSize != 1 || !(item.getItem() instanceof IEnergyContainerItem)) continue;
            IEnergyContainerItem chargable = (IEnergyContainerItem)item.getItem();
            int max = chargable.getMaxEnergyStored(item);
            int cur = chargable.getEnergyStored(item);
            if (cur >= max || (used = chargable.receiveEnergy(item, canUse = Math.min(available, max - cur), false)) <= 0) continue;
            this.addEnergy(-used);
            chargedItem = true;
            available -= used;
        }
        return chargedItem;
    }

    private void distributeEnergyToBanks() {
        if (this.capBanks.isEmpty()) {
            return;
        }
        int energyPerCapBank = (int)(this.energyStored / (long)this.capBanks.size());
        int remaining = (int)(this.energyStored % (long)this.capBanks.size());
        for (TileCapBank cb : this.capBanks) {
            cb.setEnergyStored(energyPerCapBank);
        }
        TileCapBank cb = this.capBanks.get(0);
        cb.setEnergyStored(cb.getEnergyStored() + remaining);
    }

    @Override
    public float getAverageChangePerTick() {
        return this.powerTrackerIn.getAverage() - this.powerTrackerOut.getAverage();
    }

    @Override
    public float getAverageInputPerTick() {
        return this.powerTrackerIn.getAverage();
    }

    @Override
    public float getAverageOutputPerTick() {
        return this.powerTrackerOut.getAverage();
    }

    @Override
    public int receiveEnergy(int maxReceive, boolean simulate) {
        if (maxReceive <= 0 || !this.inputRedstoneConditionMet) {
            return 0;
        }
        long spaceAvailable = this.maxEnergyStored - this.energyStored;
        if (spaceAvailable > Integer.MAX_VALUE) {
            spaceAvailable = Integer.MAX_VALUE;
        }
        int res = Math.min(maxReceive, (int)spaceAvailable);
        res = Math.min(res, this.getMaxInput());
        if (!simulate) {
            this.addEnergy(res);
        }
        return res;
    }

    @Override
    public void addEnergy(int energy) {
        if (energy > 0) {
            this.energyReceived += (long)energy;
        } else {
            this.energySend -= (long)energy;
        }
        if (!this.type.isCreative()) {
            this.energyStored += (long)energy;
            if (this.energyStored > this.maxEnergyStored) {
                this.energyStored = this.maxEnergyStored;
            } else if (this.energyStored < 0L) {
                this.energyStored = 0L;
            }
        }
    }

    public void addEnergyReceptor(EnergyReceptor rec) {
        this.receptors.add(rec);
        this.receptorIterator = null;
    }

    @Override
    public void addReceptors(Collection<EnergyReceptor> rec) {
        if (rec.isEmpty()) {
            return;
        }
        this.receptors.addAll(rec);
        this.receptorIterator = null;
    }

    @Override
    public void removeReceptors(Collection<EnergyReceptor> rec) {
        if (rec.isEmpty()) {
            return;
        }
        this.receptors.removeAll(rec);
        this.receptorIterator = null;
    }

    public void removeReceptor(EnergyReceptor rec) {
        this.receptors.remove(rec);
        this.receptorIterator = null;
    }

    @Override
    public long getEnergyStoredL() {
        return this.energyStored;
    }

    @Override
    public long getMaxEnergyStoredL() {
        return this.maxEnergyStored;
    }

    @Override
    public int getMaxIO() {
        return this.maxIO;
    }

    @Override
    public int getMaxInput() {
        if (this.maxInput == -1) {
            return this.maxIO;
        }
        return Math.min(this.maxInput, this.maxIO);
    }

    @Override
    public int getMaxOutput() {
        if (this.maxOutput == -1) {
            return this.maxIO;
        }
        return Math.min(this.maxOutput, this.maxIO);
    }

    @Override
    public void setMaxInput(int max) {
        this.maxInput = max >= this.maxIO ? -1 : (max < 0 ? 0 : max);
        for (TileCapBank cb : this.capBanks) {
            cb.setMaxInput(this.maxInput);
        }
    }

    @Override
    public void setMaxOutput(int max) {
        this.maxOutput = max >= this.maxIO ? -1 : (max < 0 ? 0 : max);
        for (TileCapBank cb : this.capBanks) {
            cb.setMaxOutput(this.maxOutput);
        }
    }

    @Override
    public RedstoneControlMode getInputControlMode() {
        return this.inputControlMode;
    }

    @Override
    public void setInputControlMode(RedstoneControlMode inputControlMode) {
        if (this.inputControlMode == inputControlMode) {
            return;
        }
        this.inputControlMode = inputControlMode;
        for (TileCapBank capBank : this.capBanks) {
            capBank.setInputControlMode(inputControlMode);
        }
        this.updateRedstoneConditions();
    }

    @Override
    public RedstoneControlMode getOutputControlMode() {
        return this.outputControlMode;
    }

    @Override
    public void setOutputControlMode(RedstoneControlMode outputControlMode) {
        if (this.outputControlMode == outputControlMode) {
            return;
        }
        this.outputControlMode = outputControlMode;
        for (TileCapBank capBank : this.capBanks) {
            capBank.setOutputControlMode(outputControlMode);
        }
        this.updateRedstoneConditions();
    }

    @Override
    public void updateRedstoneSignal(TileCapBank tileCapBank, boolean recievingSignal) {
        if (recievingSignal) {
            this.redstoneRecievers.add(tileCapBank.getLocation());
        } else {
            this.redstoneRecievers.remove(tileCapBank.getLocation());
        }
        this.updateRedstoneConditions();
    }

    @Override
    public boolean isInputEnabled() {
        return this.inputRedstoneConditionMet;
    }

    @Override
    public boolean isOutputEnabled() {
        return this.outputRedstoneConditionMet;
    }

    private void updateRedstoneConditions() {
        int powerLevel = this.redstoneRecievers.isEmpty() ? 0 : 15;
        this.inputRedstoneConditionMet = RedstoneControlMode.isConditionMet(this.inputControlMode, powerLevel);
        this.outputRedstoneConditionMet = RedstoneControlMode.isConditionMet(this.outputControlMode, powerLevel);
    }

    @Override
    public IPowerStorage getController() {
        return this;
    }

    @Override
    public boolean isOutputEnabled(ForgeDirection direction) {
        return this.isOutputEnabled();
    }

    @Override
    public boolean isInputEnabled(ForgeDirection direction) {
        return this.isInputEnabled();
    }

    @Override
    public boolean isCreative() {
        return this.type.isCreative();
    }

    @Override
    public boolean isNetworkControlledIo(ForgeDirection direction) {
        return true;
    }

    @Override
    public void invalidateDisplayInfoCache() {
    }

    private class TickReciever
    implements ConduitNetworkTickHandler.TickListener {
        private TickReciever() {
        }

        @Override
        public void tickStart(TickEvent.ServerTickEvent evt) {
        }

        @Override
        public void tickEnd(TickEvent.ServerTickEvent evt) {
            CapBankNetwork.this.doNetworkTick();
        }
    }
}

