/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.machine.buffer;

import com.enderio.core.client.gui.widget.TextFieldEnder;
import com.enderio.core.client.render.RenderUtil;
import com.enderio.core.common.vecmath.Vector4f;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import crazypants.enderio.EnderIO;
import crazypants.enderio.machine.IoMode;
import crazypants.enderio.machine.buffer.ContainerBuffer;
import crazypants.enderio.machine.buffer.PacketBufferIO;
import crazypants.enderio.machine.buffer.TileBuffer;
import crazypants.enderio.machine.gui.GuiPoweredMachineBase;
import crazypants.enderio.machine.power.PowerDisplayUtil;
import crazypants.enderio.network.PacketHandler;
import net.minecraft.client.gui.GuiTextField;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.Slot;
import org.lwjgl.opengl.GL11;

public class GuiBuffer
extends GuiPoweredMachineBase<TileBuffer> {
    private static final String TEXTURE_SIMPLE = "buffer";
    private static final String TEXTURE_FULL = "buffer_full";
    private TextFieldEnder maxInput;
    private TextFieldEnder maxOutput;
    private int lastInput;
    private int lastOutput;

    public GuiBuffer(InventoryPlayer par1InventoryPlayer, TileBuffer te) {
        super(te, (Container)new ContainerBuffer(par1InventoryPlayer, te), TEXTURE_SIMPLE, TEXTURE_FULL);
        this.redstoneButton.setPosition(this.isFull() ? 153 : 120, 24);
        this.configB.setPosition(this.isFull() ? 153 : 120, 42);
        if (te.hasPower()) {
            int x = this.isFull() ? 20 : 58;
            int y = this.guiTop + 27;
            this.maxInput = new TextFieldEnder(this.getFontRenderer(), x, y, 60, 12);
            this.maxOutput = new TextFieldEnder(this.getFontRenderer(), x, y += 28, 60, 12);
            this.textFields.add(this.maxInput);
            this.textFields.add(this.maxOutput);
        }
    }

    @Override
    public void initGui() {
        super.initGui();
        if (((TileBuffer)this.getTileEntity()).hasPower()) {
            this.maxInput.setMaxStringLength(10);
            this.maxInput.setText(PowerDisplayUtil.formatPower(((TileBuffer)this.getTileEntity()).getMaxInput()));
            this.maxOutput.setMaxStringLength(10);
            this.maxOutput.setText(PowerDisplayUtil.formatPower(((TileBuffer)this.getTileEntity()).getMaxOutput()));
        }
    }

    protected void keyTyped(char par1, int par2) {
        super.keyTyped(par1, par2);
        if (par1 == 'e') {
            super.keyTyped(par1, 1);
        }
        if (((TileBuffer)this.getTileEntity()).hasPower()) {
            this.updateInputOutput();
        }
    }

    private void updateInputOutput() {
        int input = PowerDisplayUtil.parsePower((GuiTextField)this.maxInput);
        this.setMaxInput(input);
        int output = PowerDisplayUtil.parsePower((GuiTextField)this.maxOutput);
        this.setMaxOutput(output);
        this.sendUpdateToServer();
    }

    private void setMaxOutput(int output) {
        if (output != this.lastOutput) {
            this.lastOutput = output;
            this.maxOutput.setText(PowerDisplayUtil.formatPower(output));
        }
    }

    private void setMaxInput(int input) {
        if (input != this.lastInput) {
            this.lastInput = input;
            this.maxInput.setText(PowerDisplayUtil.formatPower(input));
            this.sendUpdateToServer();
        }
    }

    protected void sendUpdateToServer() {
        PacketHandler.INSTANCE.sendToServer((IMessage)new PacketBufferIO((TileBuffer)this.getTileEntity(), this.lastInput, this.lastOutput));
    }

    @Override
    protected boolean showRecipeButton() {
        return false;
    }

    @Override
    protected boolean renderPowerBar() {
        return ((TileBuffer)this.getTileEntity()).hasPower();
    }

    public int getYSize() {
        return this.ySize;
    }

    @Override
    protected int getPowerHeight() {
        return 52;
    }

    @Override
    protected int getPowerX() {
        return this.isFull() ? 6 : 44;
    }

    @Override
    protected int getPowerY() {
        return 15;
    }

    @Override
    protected int getPowerV() {
        return 0;
    }

    @Override
    protected void drawGuiContainerBackgroundLayer(float par1, int par2, int par3) {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.bindGuiTexture(this.isFull() ? 1 : 0);
        int sx = (this.width - this.xSize) / 2;
        int sy = (this.height - this.ySize) / 2;
        this.drawTexturedModalRect(sx, sy, 0, 0, this.xSize, this.ySize);
        this.bindGuiTexture();
        if (((TileBuffer)this.getTileEntity()).hasPower()) {
            this.drawPowerBg(sx, sy);
        }
        if (((TileBuffer)this.getTileEntity()).hasInventory()) {
            this.drawSlotBg(sx, sy);
        }
        super.drawGuiContainerBackgroundLayer(par1, par2, par3);
        String invName = EnderIO.lang.localizeExact(((TileBuffer)this.getTileEntity()).getInventoryName() + ".name");
        this.getFontRenderer().drawStringWithShadow(invName, sx + this.xSize / 2 - this.getFontRenderer().getStringWidth(invName) / 2, sy + 4, 0xFFFFFF);
        if (((TileBuffer)this.getTileEntity()).hasPower()) {
            this.getFontRenderer().drawStringWithShadow(EnderIO.lang.localize("gui.simple.in"), sx += this.isFull() ? 19 : 57, sy += 17, 0xFFFFFF);
            this.getFontRenderer().drawStringWithShadow(EnderIO.lang.localize("gui.simple.out"), sx, sy + 27, 0xFFFFFF);
        }
    }

    boolean isFull() {
        return ((TileBuffer)this.getTileEntity()).hasInventory() && ((TileBuffer)this.getTileEntity()).hasPower();
    }

    @Override
    public void renderSlotHighlights(IoMode mode) {
        if (!((TileBuffer)this.getTileEntity()).hasInventory()) {
            return;
        }
        for (int slot = 0; slot < ((TileBuffer)this.getTileEntity()).getSizeInventory(); ++slot) {
            this.renderSlotHighlight(slot, mode);
        }
    }

    protected void renderSlotHighlight(int slot, IoMode mode) {
        Slot invSlot = (Slot)this.inventorySlots.inventorySlots.get(slot);
        if (mode == IoMode.PULL) {
            this.renderSlotHighlight(slot, PULL_COLOR);
        } else if (mode == IoMode.PUSH) {
            this.renderSlotHighlight(slot, PUSH_COLOR);
        } else if (mode == IoMode.PUSH_PULL) {
            this.renderSplitHighlight(invSlot.xDisplayPosition, invSlot.yDisplayPosition, 16, 16);
        }
    }

    protected void renderSplitHighlight(int x, int y, int width, int height) {
        GL11.glEnable((int)3042);
        RenderUtil.renderQuad2D((double)(this.getGuiLeft() + x), (double)(this.getGuiTop() + y), (double)0.0, (double)width, (double)(height / 2), (Vector4f)PULL_COLOR);
        RenderUtil.renderQuad2D((double)(this.getGuiLeft() + x), (double)(this.getGuiTop() + y + height / 2), (double)0.0, (double)width, (double)(height / 2), (Vector4f)PUSH_COLOR);
        GL11.glDisable((int)3042);
    }

    private void drawPowerBg(int sx, int sy) {
        this.drawTexturedModalRect(sx + (this.isFull() ? 5 : 43), sy + 14, this.xSize + 10, 0, 12, 54);
    }

    private void drawSlotBg(int sx, int sy) {
        this.drawTexturedModalRect(sx + (this.isFull() ? 95 : 61), sy + 14, this.xSize + 22, 0, 54, 54);
    }
}

