/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.machine.buffer;

import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import crazypants.enderio.EnderIO;
import crazypants.enderio.ModObject;
import crazypants.enderio.machine.AbstractMachineBlock;
import crazypants.enderio.machine.IMachineRecipe;
import crazypants.enderio.machine.MachineRecipeInput;
import crazypants.enderio.machine.MachineRecipeRegistry;
import crazypants.enderio.machine.buffer.BlockItemBuffer;
import crazypants.enderio.machine.buffer.ContainerBuffer;
import crazypants.enderio.machine.buffer.GuiBuffer;
import crazypants.enderio.machine.buffer.PacketBufferIO;
import crazypants.enderio.machine.buffer.TileBuffer;
import crazypants.enderio.machine.painter.BasicPainterTemplate;
import crazypants.enderio.machine.painter.IPaintableTileEntity;
import crazypants.enderio.machine.painter.PainterUtil;
import crazypants.enderio.network.PacketHandler;
import crazypants.util.IFacade;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class BlockBuffer
extends AbstractMachineBlock<TileBuffer>
implements IFacade {
    private static final String[] textureNames = new String[]{"blockBufferItem", "blockBufferPower", "blockBufferOmni", "blockBufferCreative"};
    @SideOnly(value=Side.CLIENT)
    private IIcon[] textures;

    public static BlockBuffer create() {
        PacketHandler.INSTANCE.registerMessage(PacketBufferIO.class, PacketBufferIO.class, PacketHandler.nextID(), Side.SERVER);
        BlockBuffer res = new BlockBuffer();
        res.init();
        return res;
    }

    private BlockBuffer() {
        super(ModObject.blockBuffer, TileBuffer.class);
    }

    @Override
    protected void init() {
        GameRegistry.registerBlock((Block)this, BlockItemBuffer.class, (String)this.modObject.unlocalisedName);
        GameRegistry.registerTileEntity((Class)this.teClass, (String)(this.modObject.unlocalisedName + "TileEntity"));
        EnderIO.guiHandler.registerGuiHandler(this.getGuiId(), this);
        MachineRecipeRegistry.instance.registerRecipe(ModObject.blockPainter.unlocalisedName, new PainterTemplate());
    }

    public Object getServerGuiElement(int ID, EntityPlayer player, World world, int x, int y, int z) {
        TileEntity te = world.getTileEntity(x, y, z);
        if (te instanceof TileBuffer) {
            return new ContainerBuffer(player.inventory, (TileBuffer)te);
        }
        return null;
    }

    public Object getClientGuiElement(int ID, EntityPlayer player, World world, int x, int y, int z) {
        TileEntity te = world.getTileEntity(x, y, z);
        if (te instanceof TileBuffer) {
            return new GuiBuffer(player.inventory, (TileBuffer)te);
        }
        return null;
    }

    @Override
    protected int getGuiId() {
        return 100;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void registerBlockIcons(IIconRegister iIconRegister) {
        super.registerBlockIcons(iIconRegister);
        this.textures = new IIcon[textureNames.length];
        for (int i = 0; i < textureNames.length; ++i) {
            this.textures[i] = iIconRegister.registerIcon("enderio:" + textureNames[i]);
        }
    }

    @Override
    protected String getMachineFrontIconKey(boolean active) {
        return this.getSideIconKey(active);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public IIcon getIcon(int blockSide, int blockMeta) {
        return blockSide > 1 ? this.textures[blockMeta] : super.getIcon(blockSide, blockMeta);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public IIcon getIcon(IBlockAccess world, int x, int y, int z, int blockSide) {
        TileEntity te = world.getTileEntity(x, y, z);
        if (te instanceof TileBuffer) {
            TileBuffer tef = (TileBuffer)te;
            if (tef.getSourceBlock() != null) {
                return tef.getSourceBlock().getIcon(blockSide, tef.getSourceBlockMetadata());
            }
            if (blockSide > 1) {
                return this.textures[world.getBlockMetadata(x, y, z)];
            }
        }
        return super.getIcon(world, x, y, z, blockSide);
    }

    @Override
    public void onBlockPlacedBy(World world, int x, int y, int z, EntityLivingBase entity, ItemStack stack) {
        TileEntity te;
        if (entity instanceof EntityPlayer && (te = world.getTileEntity(x, y, z)) instanceof TileBuffer) {
            TileBuffer ta = (TileBuffer)te;
            if (stack.stackTagCompound != null) {
                ta.readCommon(stack.stackTagCompound);
            }
            world.markBlockForUpdate(x, y, z);
        }
    }

    public int damageDropped(int meta) {
        return meta;
    }

    public ItemStack createItemStackForSourceBlock(ItemStack machine, Block block, int sourceMeta) {
        PainterUtil.setSourceBlock(machine, block, sourceMeta);
        return machine;
    }

    @Override
    public int getFacadeMetadata(IBlockAccess world, int x, int y, int z, int side) {
        TileEntity te = world.getTileEntity(x, y, z);
        if (te instanceof TileBuffer) {
            return ((TileBuffer)te).getSourceBlockMetadata();
        }
        return 0;
    }

    @Override
    public Block getFacade(IBlockAccess world, int x, int y, int z, int side) {
        Block sourceBlock;
        TileEntity te = world.getTileEntity(x, y, z);
        if (te instanceof IPaintableTileEntity && (sourceBlock = ((IPaintableTileEntity)te).getSourceBlock()) != null) {
            return sourceBlock;
        }
        return this;
    }

    @Override
    public Block getVisualBlock(IBlockAccess world, int x, int y, int z, ForgeDirection side) {
        return this.getFacade(world, x, y, z, side.ordinal());
    }

    @Override
    public int getVisualMeta(IBlockAccess world, int x, int y, int z, ForgeDirection side) {
        return this.getFacadeMetadata(world, x, y, z, side.ordinal());
    }

    @Override
    public boolean supportsVisualConnections() {
        return true;
    }

    public final class PainterTemplate
    extends BasicPainterTemplate {
        public PainterTemplate() {
            super(new Block[]{BlockBuffer.this});
        }

        @Override
        public IMachineRecipe.ResultStack[] getCompletedResult(float chance, MachineRecipeInput ... inputs) {
            ItemStack paintSource = MachineRecipeInput.getInputForSlot(1, inputs);
            if (paintSource == null) {
                return new IMachineRecipe.ResultStack[0];
            }
            ItemStack target = MachineRecipeInput.getInputForSlot(0, inputs);
            target = target.copy();
            target.stackSize = 1;
            return new IMachineRecipe.ResultStack[]{new IMachineRecipe.ResultStack(BlockBuffer.this.createItemStackForSourceBlock(target, Block.getBlockFromItem((Item)paintSource.getItem()), paintSource.getItemDamage()))};
        }
    }
}

