/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.machine.alloy;

import crazypants.enderio.ModObject;
import crazypants.enderio.machine.IMachineRecipe;
import crazypants.enderio.machine.MachineRecipeInput;
import crazypants.enderio.machine.recipe.IRecipe;
import crazypants.enderio.machine.recipe.Recipe;
import crazypants.enderio.machine.recipe.RecipeBonusType;
import crazypants.enderio.machine.recipe.RecipeInput;
import crazypants.enderio.machine.recipe.RecipeOutput;
import crazypants.enderio.material.OreDictionaryPreferences;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.FurnaceRecipes;
import net.minecraft.tileentity.TileEntityFurnace;

public class VanillaSmeltingRecipe
implements IMachineRecipe {
    private static int RF_PER_ITEM = TileEntityFurnace.getItemBurnTime((ItemStack)new ItemStack(Items.coal, 1, 0)) * 10 / 8;
    private boolean enabled = true;
    private List<RecipeInput> excludes = new ArrayList<RecipeInput>();

    @Override
    public String getUid() {
        return "VanillaSmeltingRecipe";
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public void addExclude(RecipeInput ri) {
        this.excludes.add(ri);
    }

    @Override
    public int getEnergyRequired(MachineRecipeInput ... inputs) {
        int numInputs = this.getNumInputs(inputs);
        return numInputs * RF_PER_ITEM;
    }

    @Override
    public RecipeBonusType getBonusType(MachineRecipeInput ... inputs) {
        return RecipeBonusType.NONE;
    }

    private int getNumInputs(MachineRecipeInput[] inputs) {
        int numInputs = 0;
        for (MachineRecipeInput input : inputs) {
            if (input == null || !this.isValidInput(input)) continue;
            numInputs += input.item.stackSize;
        }
        return Math.min(numInputs, 3);
    }

    @Override
    public boolean isRecipe(MachineRecipeInput ... inputs) {
        if (!this.enabled) {
            return false;
        }
        ItemStack output = null;
        for (MachineRecipeInput ri : inputs) {
            ItemStack newOutput;
            if (ri == null || ri.item == null || this.isExcluded(ri.item) || !(output == null ? (output = FurnaceRecipes.smelting().getSmeltingResult(ri.item)) == null : (newOutput = FurnaceRecipes.smelting().getSmeltingResult(ri.item)) == null || !newOutput.isItemEqual(output))) continue;
            return false;
        }
        return output != null;
    }

    private boolean isExcluded(ItemStack item) {
        for (RecipeInput ri : this.excludes) {
            if (ri == null || !ri.isInput(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public IMachineRecipe.ResultStack[] getCompletedResult(float chance, MachineRecipeInput ... inputs) {
        ItemStack output = null;
        boolean inputCount = false;
        for (MachineRecipeInput ri : inputs) {
            if (ri == null || ri.item == null || output != null) continue;
            output = FurnaceRecipes.smelting().getSmeltingResult(ri.item);
        }
        if (output == null) {
            return new IMachineRecipe.ResultStack[0];
        }
        int stackSize = output.stackSize;
        output = OreDictionaryPreferences.instance.getPreferred(output);
        ItemStack result = output.copy();
        result.stackSize = stackSize;
        result.stackSize *= this.getNumInputs(inputs);
        return new IMachineRecipe.ResultStack[]{new IMachineRecipe.ResultStack(result)};
    }

    @Override
    public float getExperienceForOutput(ItemStack output) {
        if (output == null) {
            return 0.0f;
        }
        float result = FurnaceRecipes.smelting().func_151398_b(output);
        if (result > 1.0f) {
            result = 1.0f;
        }
        return result * (float)output.stackSize;
    }

    @Override
    public boolean isValidInput(MachineRecipeInput input) {
        if (!this.enabled) {
            return false;
        }
        if (input == null || input.item == null) {
            return false;
        }
        if (this.isExcluded(input.item)) {
            return false;
        }
        ItemStack itemstack = FurnaceRecipes.smelting().getSmeltingResult(input.item);
        return itemstack != null;
    }

    @Override
    public String getMachineName() {
        return ModObject.blockAlloySmelter.unlocalisedName;
    }

    @Override
    public List<MachineRecipeInput> getQuantitiesConsumed(MachineRecipeInput[] inputs) {
        int consumed = 0;
        ArrayList<MachineRecipeInput> result = new ArrayList<MachineRecipeInput>();
        for (MachineRecipeInput ri : inputs) {
            int available;
            int canUse;
            int use;
            if (!this.isValidInput(new MachineRecipeInput(ri.slotNumber, ri.item)) || consumed >= 3 || ri == null || ri.item == null || (use = Math.min(canUse = 3 - consumed, available = ri.item.stackSize)) <= 0) continue;
            ItemStack st = ri.item.copy();
            st.stackSize = use;
            result.add(new MachineRecipeInput(ri.slotNumber, st));
            consumed += use;
        }
        return result;
    }

    public List<IRecipe> getAllRecipes() {
        if (!this.enabled) {
            return Collections.emptyList();
        }
        ArrayList<IRecipe> result = new ArrayList<IRecipe>();
        Map metaList = FurnaceRecipes.smelting().getSmeltingList();
        for (Map.Entry entry : metaList.entrySet()) {
            ItemStack output = (ItemStack)entry.getValue();
            output = OreDictionaryPreferences.instance.getPreferred(output).copy();
            result.add(new Recipe(new RecipeInput((ItemStack)entry.getKey()), RF_PER_ITEM, RecipeBonusType.NONE, new RecipeOutput(output)));
        }
        return result;
    }
}

