/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.machine;

import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import crazypants.enderio.EnderIO;
import crazypants.enderio.machine.AbstractMachineBlock;
import net.minecraft.block.Block;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.oredict.RecipeSorter;

public class ClearConfigRecipe
implements IRecipe {
    private ItemStack output;

    public boolean matches(InventoryCrafting inv, World world) {
        int count = 0;
        ItemStack input = null;
        for (int i = 0; i < inv.getSizeInventory(); ++i) {
            ItemStack checkStack = inv.getStackInSlot(i);
            if (checkStack != null && Block.getBlockFromItem((Item)checkStack.getItem()) instanceof AbstractMachineBlock) {
                ++count;
            }
            input = count == 1 && checkStack != null ? checkStack : input;
        }
        if (count == 1 && input.stackTagCompound != null && input.stackTagCompound.getBoolean("eio.abstractMachine")) {
            ItemStack out = input.copy();
            out.stackTagCompound = new NBTTagCompound();
            out.stackTagCompound.setBoolean("clearedConfig", true);
            out.stackSize = 1;
            this.output = out;
        } else {
            this.output = null;
        }
        return count == 1 && this.output != null;
    }

    public ItemStack getCraftingResult(InventoryCrafting inv) {
        return this.output.copy();
    }

    public int getRecipeSize() {
        return 1;
    }

    public ItemStack getRecipeOutput() {
        return this.output;
    }

    @SubscribeEvent
    public void onTooltip(ItemTooltipEvent event) {
        if (this.output != null && ItemStack.areItemStacksEqual((ItemStack)this.output, (ItemStack)event.itemStack)) {
            event.toolTip.add(EnumChatFormatting.RED.toString() + EnumChatFormatting.ITALIC + EnderIO.lang.localize("machine.tooltip.clearConfig"));
        }
    }

    static {
        RecipeSorter.register((String)"EnderIO:clearConfig", ClearConfigRecipe.class, (RecipeSorter.Category)RecipeSorter.Category.SHAPELESS, (String)"after:minecraft:shapeless");
    }
}

