/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.item.skull;

import cpw.mods.fml.common.Optional;
import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import crazypants.enderio.BlockEio;
import crazypants.enderio.ModObject;
import crazypants.enderio.item.skull.ItemEndermanSkull;
import crazypants.enderio.item.skull.TileEndermanSkull;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import thaumcraft.api.crafting.IInfusionStabiliser;

@Optional.Interface(iface="thaumcraft.api.crafting.IInfusionStabiliser", modid="Thaumcraft")
public class BlockEndermanSkull
extends BlockEio
implements IInfusionStabiliser {
    public static int renderId = -1;
    IIcon frontIcon;
    IIcon frontIconEyes;
    IIcon sideIcon;
    IIcon topIcon;

    public static BlockEndermanSkull create() {
        BlockEndermanSkull res = new BlockEndermanSkull();
        res.init();
        return res;
    }

    private BlockEndermanSkull() {
        super(ModObject.blockEndermanSkull.unlocalisedName, TileEndermanSkull.class, Material.circuits);
        this.setBlockBounds(0.25f, 0.0f, 0.25f, 0.75f, 0.5f, 0.75f);
    }

    protected void init() {
        GameRegistry.registerBlock((Block)this, ItemEndermanSkull.class, (String)this.name);
        GameRegistry.registerTileEntity((Class)this.teClass, (String)(this.name + "TileEntity"));
    }

    @SideOnly(value=Side.CLIENT)
    public void registerBlockIcons(IIconRegister iIconRegister) {
        this.frontIcon = iIconRegister.registerIcon("enderio:endermanSkullFront");
        this.frontIconEyes = iIconRegister.registerIcon("enderio:endermanSkullFrontEyes");
        this.sideIcon = iIconRegister.registerIcon("enderio:endermanSkullSide");
        this.topIcon = iIconRegister.registerIcon("enderio:endermanSkullTop");
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon getIcon(int side, int meta) {
        ForgeDirection orint = ForgeDirection.getOrientation((int)side);
        if (orint == ForgeDirection.NORTH) {
            meta = MathHelper.clamp_int((int)meta, (int)0, (int)(SkullType.values().length - 1));
            return SkullType.values()[meta].showEyes ? this.frontIconEyes : this.frontIcon;
        }
        if (orint == ForgeDirection.UP || orint == ForgeDirection.DOWN || orint == ForgeDirection.SOUTH) {
            return this.topIcon;
        }
        return this.sideIcon;
    }

    public int getRenderType() {
        return renderId;
    }

    public boolean isOpaqueCube() {
        return false;
    }

    public boolean renderAsNormalBlock() {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public String getItemIconName() {
        return "enderio:endermanSkull";
    }

    public void onBlockPlacedBy(World world, int x, int y, int z, EntityLivingBase player, ItemStack stack) {
        int inc = MathHelper.floor_double((double)((double)(player.rotationYaw * 16.0f / 360.0f) + 0.5)) & 0xF;
        float facingYaw = -22.5f * (float)inc;
        TileEndermanSkull te = (TileEndermanSkull)world.getTileEntity(x, y, z);
        te.setYaw(facingYaw);
        if (world.isRemote) {
            return;
        }
        world.setBlockMetadataWithNotify(x, y, z, stack.getItemDamage(), 2);
        world.markBlockForUpdate(x, y, z);
    }

    public int damageDropped(int meta) {
        return meta;
    }

    @Optional.Method(modid="Thaumcraft")
    public boolean canStabaliseInfusion(World world, int x, int y, int z) {
        return true;
    }

    public static enum SkullType {
        BASE("base", false),
        REANIMATED("reanimated", true),
        TORMENTED("tormented", false),
        REANIMATED_TORMENTED("reanimatedTormented", true);

        final String name;
        final boolean showEyes;

        private SkullType(String name, boolean showEyes) {
            this.name = name;
            this.showEyes = showEyes;
        }
    }
}

