/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.item.darksteel.upgrade;

import crazypants.enderio.config.Config;
import crazypants.enderio.item.darksteel.DarkSteelItems;
import crazypants.enderio.item.darksteel.upgrade.AbstractUpgrade;
import crazypants.enderio.item.darksteel.upgrade.EnergyUpgrade;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;

public class JumpUpgrade
extends AbstractUpgrade {
    private static final String KEY_LEVEL = "level";
    private static String UPGRADE_NAME = "jumpBoost";
    public static JumpUpgrade JUMP_ONE = new JumpUpgrade("enderio.darksteel.upgrade.jump_one", 1, Config.darkSteelJumpOneCost);
    public static JumpUpgrade JUMP_TWO = new JumpUpgrade("enderio.darksteel.upgrade.jump_two", 2, Config.darkSteelJumpTwoCost);
    public static JumpUpgrade JUMP_THREE = new JumpUpgrade("enderio.darksteel.upgrade.jump_three", 3, Config.darkSteelJumpThreeCost);
    private short level;

    public static boolean isEquipped(EntityPlayer player) {
        ItemStack boots = player.getEquipmentInSlot(1);
        return JumpUpgrade.loadFromItem(boots) != null;
    }

    public static JumpUpgrade loadFromItem(ItemStack stack) {
        if (stack == null) {
            return null;
        }
        if (stack.stackTagCompound == null) {
            return null;
        }
        if (!stack.stackTagCompound.hasKey("enderio.darksteel.upgrade." + UPGRADE_NAME)) {
            return null;
        }
        return new JumpUpgrade((NBTTagCompound)stack.stackTagCompound.getTag("enderio.darksteel.upgrade." + UPGRADE_NAME));
    }

    public JumpUpgrade(NBTTagCompound tag) {
        super(UPGRADE_NAME, tag);
        this.level = tag.getShort(KEY_LEVEL);
    }

    public JumpUpgrade(String unlocName, int level, int levelCost) {
        super(UPGRADE_NAME, unlocName, new ItemStack((Block)Blocks.piston), levelCost);
        this.level = (short)level;
    }

    @Override
    public boolean canAddToItem(ItemStack stack) {
        if (stack == null || stack.getItem() != DarkSteelItems.itemDarkSteelBoots || !EnergyUpgrade.itemHasAnyPowerUpgrade(stack)) {
            return false;
        }
        JumpUpgrade up = JumpUpgrade.loadFromItem(stack);
        if (up == null) {
            return this.getLevel() == 1;
        }
        return up.getLevel() == this.getLevel() - 1;
    }

    @Override
    public boolean hasUpgrade(ItemStack stack) {
        if (!super.hasUpgrade(stack)) {
            return false;
        }
        JumpUpgrade up = JumpUpgrade.loadFromItem(stack);
        if (up == null) {
            return false;
        }
        return up.unlocName.equals(this.unlocName);
    }

    @Override
    public void writeUpgradeToNBT(NBTTagCompound upgradeRoot) {
        upgradeRoot.setShort(KEY_LEVEL, this.getLevel());
    }

    public short getLevel() {
        return this.level;
    }
}

