/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.item.darksteel.upgrade;

import com.enderio.core.client.render.RenderUtil;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import crazypants.enderio.config.Config;
import crazypants.enderio.item.darksteel.DarkSteelController;
import crazypants.enderio.item.darksteel.DarkSteelItems;
import crazypants.enderio.item.darksteel.upgrade.AbstractUpgrade;
import crazypants.enderio.item.darksteel.upgrade.IRenderUpgrade;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.minecraftforge.client.event.RenderPlayerEvent;
import org.lwjgl.opengl.GL11;

public class GliderUpgrade
extends AbstractUpgrade {
    private static String UPGRADE_NAME = "glide";
    public static final GliderUpgrade INSTANCE = new GliderUpgrade();
    @SideOnly(value=Side.CLIENT)
    private Render render;

    public static GliderUpgrade loadFromItem(ItemStack stack) {
        if (stack == null) {
            return null;
        }
        if (stack.stackTagCompound == null) {
            return null;
        }
        if (!stack.stackTagCompound.hasKey("enderio.darksteel.upgrade." + UPGRADE_NAME)) {
            return null;
        }
        return new GliderUpgrade((NBTTagCompound)stack.stackTagCompound.getTag("enderio.darksteel.upgrade." + UPGRADE_NAME));
    }

    public GliderUpgrade(NBTTagCompound tag) {
        super(UPGRADE_NAME, tag);
    }

    public GliderUpgrade() {
        super(UPGRADE_NAME, "enderio.darksteel.upgrade.glider", new ItemStack((Item)DarkSteelItems.itemGliderWing, 1, 1), Config.darkSteelGliderCost);
    }

    @Override
    public boolean canAddToItem(ItemStack stack) {
        if (stack == null || stack.getItem() != DarkSteelItems.itemDarkSteelChestplate) {
            return false;
        }
        GliderUpgrade up = GliderUpgrade.loadFromItem(stack);
        return up == null;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public IRenderUpgrade getRender() {
        return this.render == null ? (this.render = new Render()) : this.render;
    }

    @Override
    public void writeUpgradeToNBT(NBTTagCompound upgradeRoot) {
    }

    @SideOnly(value=Side.CLIENT)
    private class Render
    implements IRenderUpgrade {
        private EntityItem item;
        private ItemStack glider;

        private Render() {
            this.item = new EntityItem((World)Minecraft.getMinecraft().theWorld);
            this.glider = new ItemStack((Item)DarkSteelItems.itemGliderWing, 1, 1);
            this.item.setEntityItemStack(this.glider);
        }

        @Override
        public void render(RenderPlayerEvent event, ItemStack stack, boolean head) {
            if (!head && DarkSteelController.instance.isGlideActive(event.entityPlayer)) {
                RenderUtil.bindItemTexture();
                GL11.glDepthMask((boolean)true);
                this.item.hoverStart = 0.0f;
                IRenderUpgrade.Helper.rotateIfSneaking(event.entityPlayer);
                GL11.glTranslatef((float)0.0f, (float)1.0f, (float)0.25f);
                GL11.glRotatef((float)180.0f, (float)1.0f, (float)0.0f, (float)0.0f);
                GL11.glScalef((float)3.0f, (float)3.0f, (float)3.0f);
                RenderManager.instance.renderEntityWithPosYaw((Entity)this.item, 0.0, 0.0, 0.0, 0.0f, 0.0f);
            }
        }
    }
}

