/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.item.darksteel.upgrade;

import com.enderio.core.client.handlers.SpecialTooltipHandler;
import com.enderio.core.common.util.ItemUtil;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import crazypants.enderio.EnderIO;
import crazypants.enderio.item.darksteel.upgrade.IDarkSteelUpgrade;
import crazypants.enderio.item.darksteel.upgrade.IRenderUpgrade;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumChatFormatting;

public abstract class AbstractUpgrade
implements IDarkSteelUpgrade {
    public static final String KEY_LEVEL_COST = "level_cost";
    private static final String KEY_UNLOC_NAME = "unlocalized_name";
    public static final String KEY_UPGRADE_PREFIX = "enderio.darksteel.upgrade.";
    private static final String KEY_UPGRADE_ITEM = "upgradeItem";
    protected final int levelCost;
    protected final String id;
    protected final String unlocName;
    protected ItemStack upgradeItem;

    protected AbstractUpgrade(String id, String unlocName, ItemStack upgradeItem, int levelCost) {
        this.id = KEY_UPGRADE_PREFIX + id;
        this.unlocName = unlocName;
        this.upgradeItem = upgradeItem;
        this.levelCost = levelCost;
    }

    public AbstractUpgrade(String id, NBTTagCompound tag) {
        this.id = KEY_UPGRADE_PREFIX + id;
        this.levelCost = tag.getInteger(KEY_LEVEL_COST);
        this.unlocName = tag.getString(KEY_UNLOC_NAME);
        if (tag.hasKey(KEY_UPGRADE_ITEM)) {
            this.upgradeItem = ItemStack.loadItemStackFromNBT((NBTTagCompound)((NBTTagCompound)tag.getTag(KEY_UPGRADE_ITEM)));
        }
    }

    @Override
    public boolean isUpgradeItem(ItemStack stack) {
        if (stack == null || stack.getItem() == null || this.getUpgradeItem() == null) {
            return false;
        }
        return stack.isItemEqual(this.getUpgradeItem()) && stack.stackSize == this.getUpgradeItem().stackSize;
    }

    @Override
    public ItemStack getUpgradeItem() {
        return this.upgradeItem;
    }

    @Override
    public String getUpgradeItemName() {
        return this.getUpgradeItem().getDisplayName();
    }

    @SideOnly(value=Side.CLIENT)
    public void addCommonEntries(ItemStack itemstack, EntityPlayer entityplayer, List list, boolean flag) {
        SpecialTooltipHandler.addCommonTooltipFromResources((List)list, (String)this.getUnlocalizedName());
    }

    @SideOnly(value=Side.CLIENT)
    public void addBasicEntries(ItemStack itemstack, EntityPlayer entityplayer, List list, boolean flag) {
        list.add(EnumChatFormatting.DARK_AQUA + EnderIO.lang.localizeExact(this.getUnlocalizedName() + ".name"));
    }

    @SideOnly(value=Side.CLIENT)
    public void addDetailedEntries(ItemStack itemstack, EntityPlayer entityplayer, List list, boolean flag) {
        list.add(EnumChatFormatting.DARK_AQUA + EnderIO.lang.localizeExact(this.getUnlocalizedName() + ".name"));
        SpecialTooltipHandler.addDetailedTooltipFromResources((List)list, (String)this.getUnlocalizedName());
    }

    @Override
    public int getLevelCost() {
        return this.levelCost;
    }

    @Override
    public String getUnlocalizedName() {
        return this.unlocName;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public IRenderUpgrade getRender() {
        return null;
    }

    @Override
    public boolean hasUpgrade(ItemStack stack) {
        if (stack == null) {
            return false;
        }
        if (stack.stackTagCompound == null) {
            return false;
        }
        return stack.stackTagCompound.hasKey(this.id);
    }

    @Override
    public void writeToItem(ItemStack stack) {
        if (stack == null) {
            return;
        }
        NBTTagCompound upgradeRoot = new NBTTagCompound();
        upgradeRoot.setInteger(KEY_LEVEL_COST, this.levelCost);
        upgradeRoot.setString(KEY_UNLOC_NAME, this.getUnlocalizedName());
        if (this.getUpgradeItem() != null) {
            NBTTagCompound itemRoot = new NBTTagCompound();
            this.getUpgradeItem().writeToNBT(itemRoot);
            upgradeRoot.setTag(KEY_UPGRADE_ITEM, (NBTBase)itemRoot);
        }
        this.writeUpgradeToNBT(upgradeRoot);
        NBTTagCompound stackRoot = ItemUtil.getOrCreateNBT((ItemStack)stack);
        stackRoot.setTag(this.id, (NBTBase)upgradeRoot);
        stack.setTagCompound(stackRoot);
    }

    public NBTTagCompound getUpgradeRoot(ItemStack stack) {
        if (!this.hasUpgrade(stack)) {
            return null;
        }
        return (NBTTagCompound)stack.stackTagCompound.getTag(this.id);
    }

    public abstract void writeUpgradeToNBT(NBTTagCompound var1);

    @Override
    public void removeFromItem(ItemStack stack) {
        if (stack == null) {
            return;
        }
        if (stack.stackTagCompound == null) {
            return;
        }
        stack.stackTagCompound.removeTag(this.id);
    }
}

