/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.item.darksteel;

import cofh.api.energy.IEnergyContainerItem;
import com.enderio.core.api.client.gui.IAdvancedTooltipProvider;
import com.enderio.core.common.util.ItemUtil;
import com.enderio.core.common.util.Util;
import cpw.mods.fml.common.eventhandler.EventPriority;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import crazypants.enderio.EnderIO;
import crazypants.enderio.EnderIOTab;
import crazypants.enderio.api.teleport.IItemOfTravel;
import crazypants.enderio.api.teleport.TravelSource;
import crazypants.enderio.config.Config;
import crazypants.enderio.item.darksteel.DarkSteelItems;
import crazypants.enderio.item.darksteel.DarkSteelRecipeManager;
import crazypants.enderio.item.darksteel.IDarkSteelItem;
import crazypants.enderio.item.darksteel.upgrade.EnergyUpgrade;
import crazypants.enderio.item.darksteel.upgrade.TravelUpgrade;
import crazypants.enderio.teleport.TravelController;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.monster.EntityCreeper;
import net.minecraft.entity.monster.EntityEnderman;
import net.minecraft.entity.monster.EntitySkeleton;
import net.minecraft.entity.monster.EntityZombie;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemSword;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.EnumHelper;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.event.entity.living.EnderTeleportEvent;
import net.minecraftforge.event.entity.living.LivingDropsEvent;

public class ItemDarkSteelSword
extends ItemSword
implements IEnergyContainerItem,
IAdvancedTooltipProvider,
IDarkSteelItem,
IItemOfTravel {
    private static final String ENDERZOO_ENDERMINY = "enderzoo.Enderminy";
    static final Item.ToolMaterial MATERIAL = EnumHelper.addToolMaterial((String)"darkSteel", (int)(Config.darkSteelPickMinesTiCArdite ? 5 : 3), (int)1561, (float)7.0f, (float)2.0f, (int)25);
    private final int powerPerDamagePoint = Config.darkSteelPowerStorageBase / MATERIAL.getMaxUses();
    private long lastBlickTick = -1L;

    public static boolean isEquipped(EntityPlayer player) {
        if (player == null) {
            return false;
        }
        ItemStack equipped = player.getCurrentEquippedItem();
        if (equipped == null) {
            return false;
        }
        return equipped.getItem() == DarkSteelItems.itemDarkSteelSword;
    }

    public static boolean isEquippedAndPowered(EntityPlayer player, int requiredPower) {
        if (!ItemDarkSteelSword.isEquipped(player)) {
            return false;
        }
        return EnergyUpgrade.getEnergyStored(player.getCurrentEquippedItem()) >= requiredPower;
    }

    public static ItemDarkSteelSword create() {
        ItemDarkSteelSword res = new ItemDarkSteelSword();
        res.init();
        MinecraftForge.EVENT_BUS.register((Object)res);
        return res;
    }

    public ItemDarkSteelSword() {
        super(MATERIAL);
        this.setCreativeTab(EnderIOTab.tabEnderIO);
        String str = "darkSteel_sword";
        this.setUnlocalizedName(str);
        this.setTextureName(EnderIO.DOMAIN + ":" + str);
    }

    @SideOnly(value=Side.CLIENT)
    public void getSubItems(Item item, CreativeTabs par2CreativeTabs, List par3List) {
        ItemStack is = new ItemStack((Item)this);
        par3List.add(is);
        is = new ItemStack((Item)this);
        EnergyUpgrade.EMPOWERED_FOUR.writeToItem(is);
        EnergyUpgrade.setPowerFull(is);
        TravelUpgrade.INSTANCE.writeToItem(is);
        par3List.add(is);
    }

    @Override
    public int getIngotsRequiredForFullRepair() {
        return 3;
    }

    public boolean isDamaged(ItemStack stack) {
        return false;
    }

    @SubscribeEvent
    public void onEnderTeleport(EnderTeleportEvent evt) {
        if (evt.entityLiving.getEntityData().getBoolean("hitByDarkSteelSword")) {
            evt.setCanceled(true);
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onEntityDrop(LivingDropsEvent evt) {
        if (!(evt.source.getEntity() instanceof EntityPlayer)) {
            return;
        }
        EntityPlayer player = (EntityPlayer)evt.source.getEntity();
        if (this.handleBeheadingWeapons(player, evt)) {
            return;
        }
        double skullDropChance = this.getSkullDropChance(player, evt);
        if (player instanceof FakePlayer) {
            skullDropChance *= (double)Config.fakePlayerSkullChance;
        }
        if (Math.random() <= skullDropChance) {
            this.dropSkull(evt, player);
        }
        if (ItemDarkSteelSword.isEquipped(player)) {
            String name = EntityList.getEntityString((Entity)evt.entityLiving);
            if (evt.entityLiving instanceof EntityEnderman || ENDERZOO_ENDERMINY.equals(name)) {
                int numPearls = 0;
                if (Math.random() <= Config.darkSteelSwordEnderPearlDropChance) {
                    ++numPearls;
                }
                for (int i = 0; i < evt.lootingLevel; ++i) {
                    if (!(Math.random() <= Config.darkSteelSwordEnderPearlDropChancePerLooting)) continue;
                    ++numPearls;
                }
                int existing = 0;
                for (EntityItem stack : evt.drops) {
                    if (stack.getEntityItem() == null || stack.getEntityItem().getItem() != Items.ender_pearl) continue;
                    existing += stack.getEntityItem().stackSize;
                }
                int toDrop = numPearls - existing;
                if (toDrop > 0) {
                    evt.drops.add(Util.createDrop((World)player.worldObj, (ItemStack)new ItemStack(Items.ender_pearl, toDrop, 0), (double)evt.entityLiving.posX, (double)evt.entityLiving.posY, (double)evt.entityLiving.posZ, (boolean)false));
                }
            }
        }
    }

    protected void dropSkull(LivingDropsEvent evt, EntityPlayer player) {
        ItemStack skull = this.getSkullForEntity(evt.entityLiving);
        if (skull != null && !this.containsDrop(evt, skull)) {
            evt.drops.add(Util.createEntityItem((World)player.worldObj, (ItemStack)skull, (double)evt.entityLiving.posX, (double)evt.entityLiving.posY, (double)evt.entityLiving.posZ));
        }
    }

    private boolean handleBeheadingWeapons(EntityPlayer player, LivingDropsEvent evt) {
        ItemStack equipped = player.getCurrentEquippedItem();
        if (equipped == null || equipped.stackTagCompound == null) {
            return false;
        }
        NBTTagCompound infiToolRoot = equipped.getTagCompound().getCompoundTag("InfiTool");
        if (infiToolRoot == null) {
            return false;
        }
        boolean isCleaver = "tconstruct.items.tools.Cleaver".equals(equipped.getItem().getClass().getName());
        boolean hasBeheading = infiToolRoot.hasKey("Beheading");
        if (!isCleaver && !hasBeheading) {
            return false;
        }
        if (!(evt.entityLiving instanceof EntityEnderman)) {
            return true;
        }
        float fromWeapon = isCleaver ? Config.ticCleaverSkullDropChance : Config.vanillaSwordSkullChance;
        float fromLooting = 0.0f;
        if (hasBeheading) {
            fromLooting = Config.ticBeheadingSkullModifier * (float)infiToolRoot.getInteger("Beheading");
        }
        float skullDropChance = fromWeapon + fromLooting;
        if (Math.random() <= (double)skullDropChance) {
            this.dropSkull(evt, player);
        }
        return true;
    }

    private double getSkullDropChance(EntityPlayer player, LivingDropsEvent evt) {
        float fromLooting;
        float fromWeapon;
        if (this.isWitherSkeleton(evt)) {
            if (ItemDarkSteelSword.isEquippedAndPowered(player, Config.darkSteelSwordPowerUsePerHit)) {
                return Config.darkSteelSwordWitherSkullChance + Config.darkSteelSwordWitherSkullLootingModifier * (float)evt.lootingLevel;
            }
            return 0.01;
        }
        if (ItemDarkSteelSword.isEquippedAndPowered(player, Config.darkSteelSwordPowerUsePerHit)) {
            fromWeapon = Config.darkSteelSwordSkullChance;
            fromLooting = Config.darkSteelSwordSkullLootingModifier * (float)evt.lootingLevel;
        } else {
            fromWeapon = Config.vanillaSwordSkullChance;
            fromLooting = Config.vanillaSwordSkullLootingModifier * (float)evt.lootingLevel;
        }
        return fromWeapon + fromLooting;
    }

    protected boolean isWitherSkeleton(LivingDropsEvent evt) {
        return evt.entityLiving instanceof EntitySkeleton && ((EntitySkeleton)evt.entityLiving).getSkeletonType() == 1;
    }

    private boolean containsDrop(LivingDropsEvent evt, ItemStack skull) {
        for (EntityItem ei : evt.drops) {
            if (ei == null || ei.getEntityItem() == null || ei.getEntityItem().getItem() != skull.getItem() || ei.getEntityItem().getItemDamage() != skull.getItemDamage()) continue;
            return true;
        }
        return false;
    }

    private ItemStack getSkullForEntity(EntityLivingBase entityLiving) {
        if (entityLiving instanceof EntitySkeleton) {
            int type = ((EntitySkeleton)entityLiving).getSkeletonType();
            if (type == 1) {
                return new ItemStack(Items.skull, 1, 1);
            }
            return new ItemStack(Items.skull, 1, 0);
        }
        if (entityLiving instanceof EntityZombie) {
            return new ItemStack(Items.skull, 1, 2);
        }
        if (entityLiving instanceof EntityCreeper) {
            return new ItemStack(Items.skull, 1, 4);
        }
        if (entityLiving instanceof EntityEnderman) {
            return new ItemStack((Block)EnderIO.blockEndermanSkull);
        }
        return null;
    }

    protected void init() {
        GameRegistry.registerItem((Item)this, (String)this.getUnlocalizedName());
    }

    public boolean hitEntity(ItemStack stack, EntityLivingBase entity, EntityLivingBase playerEntity) {
        if (playerEntity instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)playerEntity;
            ItemStack sword = player.getCurrentEquippedItem();
            EnergyUpgrade eu = EnergyUpgrade.loadFromItem(stack);
            if (eu != null && eu.isAbsorbDamageWithPower(stack) && eu.getEnergy() > 0) {
                eu.extractEnergy(this.powerPerDamagePoint, false);
            } else {
                super.hitEntity(stack, entity, playerEntity);
            }
            if (eu != null) {
                eu.writeToItem(sword);
                if (eu.getEnergy() > Config.darkSteelSwordPowerUsePerHit) {
                    this.extractEnergy(player.getCurrentEquippedItem(), Config.darkSteelSwordPowerUsePerHit, false);
                    String name = EntityList.getEntityString((Entity)entity);
                    if (entity instanceof EntityEnderman || ENDERZOO_ENDERMINY.equals(name)) {
                        entity.getEntityData().setBoolean("hitByDarkSteelSword", true);
                    }
                }
            }
        }
        return true;
    }

    @Override
    public int receiveEnergy(ItemStack container, int maxReceive, boolean simulate) {
        return EnergyUpgrade.receiveEnergy(container, maxReceive, simulate);
    }

    @Override
    public int extractEnergy(ItemStack container, int maxExtract, boolean simulate) {
        return EnergyUpgrade.extractEnergy(container, maxExtract, simulate);
    }

    @Override
    public int getEnergyStored(ItemStack container) {
        return EnergyUpgrade.getEnergyStored(container);
    }

    @Override
    public int getMaxEnergyStored(ItemStack container) {
        return EnergyUpgrade.getMaxEnergyStored(container);
    }

    public boolean getIsRepairable(ItemStack i1, ItemStack i2) {
        return false;
    }

    public void addCommonEntries(ItemStack itemstack, EntityPlayer entityplayer, List list, boolean flag) {
        DarkSteelRecipeManager.instance.addCommonTooltipEntries(itemstack, entityplayer, list, flag);
    }

    public void addBasicEntries(ItemStack itemstack, EntityPlayer entityplayer, List list, boolean flag) {
        DarkSteelRecipeManager.instance.addBasicTooltipEntries(itemstack, entityplayer, list, flag);
    }

    public void addDetailedEntries(ItemStack itemstack, EntityPlayer entityplayer, List list, boolean flag) {
        String str;
        if (!Config.addDurabilityTootip) {
            list.add(ItemUtil.getDurabilityString((ItemStack)itemstack));
        }
        if ((str = EnergyUpgrade.getStoredEnergyString(itemstack)) != null) {
            list.add(str);
        }
        list.add(EnumChatFormatting.WHITE + EnderIO.lang.localize("item.darkSteel_sword.tooltip.line1"));
        if (EnergyUpgrade.itemHasAnyPowerUpgrade(itemstack)) {
            list.add(EnumChatFormatting.WHITE + EnderIO.lang.localize("item.darkSteel_sword.tooltip.line2"));
            list.add(EnumChatFormatting.WHITE + EnderIO.lang.localize("item.darkSteel_sword.tooltip.line3"));
        }
        DarkSteelRecipeManager.instance.addAdvancedTooltipEntries(itemstack, entityplayer, list, flag);
    }

    public ItemStack createItemStack() {
        return new ItemStack((Item)this);
    }

    @Override
    public boolean isActive(EntityPlayer ep, ItemStack equipped) {
        return this.isTravelUpgradeActive(ep, equipped);
    }

    @Override
    public void extractInternal(ItemStack equipped, int power) {
        this.extractEnergy(equipped, power, false);
    }

    private boolean isTravelUpgradeActive(EntityPlayer ep, ItemStack equipped) {
        return ItemDarkSteelSword.isEquipped(ep) && ep.isSneaking() && TravelUpgrade.loadFromItem(equipped) != null;
    }

    public ItemStack onItemRightClick(ItemStack stack, World world, EntityPlayer player) {
        if (this.isTravelUpgradeActive(player, stack)) {
            if (world.isRemote && TravelController.instance.activateTravelAccessable(stack, world, player, TravelSource.STAFF)) {
                player.swingItem();
                return stack;
            }
            long ticksSinceBlink = EnderIO.proxy.getTickCount() - this.lastBlickTick;
            if (ticksSinceBlink < 0L) {
                this.lastBlickTick = -1L;
            }
            if (Config.travelStaffBlinkEnabled && world.isRemote && ticksSinceBlink >= (long)Config.travelStaffBlinkPauseTicks && TravelController.instance.doBlink(stack, player)) {
                player.swingItem();
                this.lastBlickTick = EnderIO.proxy.getTickCount();
            }
            return stack;
        }
        return super.onItemRightClick(stack, world, player);
    }
}

