/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.item.darksteel;

import cofh.api.energy.IEnergyContainerItem;
import com.enderio.core.common.util.Util;
import com.enderio.core.common.vecmath.VecmathUtil;
import com.enderio.core.common.vecmath.Vector3d;
import com.enderio.core.common.vecmath.Vector4d;
import com.mojang.authlib.GameProfile;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.TickEvent;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import crazypants.enderio.config.Config;
import crazypants.enderio.item.darksteel.DarkSteelItems;
import crazypants.enderio.item.darksteel.DarkSteelRecipeManager;
import crazypants.enderio.item.darksteel.IDarkSteelItem;
import crazypants.enderio.item.darksteel.ItemDarkSteelArmor;
import crazypants.enderio.item.darksteel.ItemDarkSteelSword;
import crazypants.enderio.item.darksteel.PacketDarkSteelPowerPacket;
import crazypants.enderio.item.darksteel.PacketUpgradeState;
import crazypants.enderio.item.darksteel.upgrade.EnergyUpgrade;
import crazypants.enderio.item.darksteel.upgrade.GliderUpgrade;
import crazypants.enderio.item.darksteel.upgrade.IDarkSteelUpgrade;
import crazypants.enderio.item.darksteel.upgrade.IRenderUpgrade;
import crazypants.enderio.item.darksteel.upgrade.JumpUpgrade;
import crazypants.enderio.item.darksteel.upgrade.NightVisionUpgrade;
import crazypants.enderio.item.darksteel.upgrade.SolarUpgrade;
import crazypants.enderio.item.darksteel.upgrade.SpeedUpgrade;
import crazypants.enderio.item.darksteel.upgrade.SwimUpgrade;
import crazypants.enderio.machine.solar.TileEntitySolarPanel;
import crazypants.enderio.network.PacketHandler;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityClientPlayerMP;
import net.minecraft.client.particle.EntityFX;
import net.minecraft.client.particle.EntityReddustFX;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.IAttributeInstance;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.MathHelper;
import net.minecraft.util.MovementInput;
import net.minecraftforge.client.event.RenderPlayerEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import org.lwjgl.opengl.GL11;

public class DarkSteelController {
    public static final DarkSteelController instance = new DarkSteelController();
    private final AttributeModifier[] walkModifiers = new AttributeModifier[]{new AttributeModifier(new UUID(12879874982L, 320981923L), "generic.movementSpeed", (double)SpeedUpgrade.WALK_MULTIPLIERS[0], 1), new AttributeModifier(new UUID(12879874982L, 320981923L), "generic.movementSpeed", (double)SpeedUpgrade.WALK_MULTIPLIERS[1], 1), new AttributeModifier(new UUID(12879874982L, 320981923L), "generic.movementSpeed", (double)SpeedUpgrade.WALK_MULTIPLIERS[2], 1)};
    private final AttributeModifier[] sprintModifiers = new AttributeModifier[]{new AttributeModifier(new UUID(12879874982L, 320981923L), "generic.movementSpeed", (double)SpeedUpgrade.SPRINT_MULTIPLIERS[0], 1), new AttributeModifier(new UUID(12879874982L, 320981923L), "generic.movementSpeed", (double)SpeedUpgrade.SPRINT_MULTIPLIERS[1], 1), new AttributeModifier(new UUID(12879874982L, 320981923L), "generic.movementSpeed", (double)SpeedUpgrade.SPRINT_MULTIPLIERS[2], 1)};
    private final AttributeModifier swordDamageModifierPowered = new AttributeModifier(new UUID(63242325L, 320981923L), "Weapon modifier", 2.0, 0);
    private boolean wasJumping;
    private int jumpCount;
    private int ticksSinceLastJump;
    private static final EnumSet<PacketUpgradeState.Type> DEFAULT_ACTIVE = EnumSet.of(PacketUpgradeState.Type.SPEED, PacketUpgradeState.Type.STEP_ASSIST, PacketUpgradeState.Type.JUMP);
    private final Map<UUID, EnumSet<PacketUpgradeState.Type>> allActive = new HashMap<UUID, EnumSet<PacketUpgradeState.Type>>();
    private boolean nightVisionActive = false;
    private boolean removeNightvision = false;

    private DarkSteelController() {
        PacketHandler.INSTANCE.registerMessage(PacketDarkSteelPowerPacket.class, PacketDarkSteelPowerPacket.class, PacketHandler.nextID(), Side.SERVER);
        PacketHandler.INSTANCE.registerMessage(PacketUpgradeState.class, PacketUpgradeState.class, PacketHandler.nextID(), Side.SERVER);
        PacketHandler.INSTANCE.registerMessage(PacketUpgradeState.class, PacketUpgradeState.class, PacketHandler.nextID(), Side.CLIENT);
    }

    private EnumSet<PacketUpgradeState.Type> getActiveSet(EntityPlayer player) {
        Object active;
        GameProfile gameProfile = player.getGameProfile();
        UUID id = gameProfile == null ? null : gameProfile.getId();
        Object object = active = id == null ? null : this.allActive.get(id);
        if (active == null) {
            active = DEFAULT_ACTIVE.clone();
            if (id != null) {
                this.allActive.put(id, (EnumSet<PacketUpgradeState.Type>)active);
            }
        }
        return active;
    }

    public boolean isActive(EntityPlayer player, PacketUpgradeState.Type type) {
        return this.getActiveSet(player).contains((Object)type);
    }

    public void setActive(EntityPlayer player, PacketUpgradeState.Type type, boolean isActive) {
        EnumSet<PacketUpgradeState.Type> set = this.getActiveSet(player);
        if (isActive) {
            set.add(type);
        } else {
            set.remove((Object)type);
        }
    }

    public boolean isGlideActive(EntityPlayer player) {
        return this.isActive(player, PacketUpgradeState.Type.GLIDE);
    }

    public boolean isSpeedActive(EntityPlayer player) {
        return this.isActive(player, PacketUpgradeState.Type.SPEED);
    }

    public boolean isStepAssistActive(EntityPlayer player) {
        return this.isActive(player, PacketUpgradeState.Type.STEP_ASSIST);
    }

    public boolean isJumpActive(EntityPlayer player) {
        return this.isActive(player, PacketUpgradeState.Type.JUMP);
    }

    @SubscribeEvent
    public void onPlayerTick(TickEvent.PlayerTickEvent event) {
        EntityPlayer player = event.player;
        if (event.phase == TickEvent.Phase.START) {
            this.updateStepHeightAndFallDistance(player);
            this.updateSpeed(player);
            this.updateSword(player);
            this.updateGlide(player);
            this.updateSwim(player);
            this.updateSolar(player);
        }
    }

    private void updateSolar(EntityPlayer player) {
        if (player.worldObj.isRemote) {
            return;
        }
        ItemStack helm = player.getEquipmentInSlot(4);
        SolarUpgrade upgrade = SolarUpgrade.loadFromItem(helm);
        if (upgrade == null) {
            return;
        }
        int RFperSecond = Math.round((float)upgrade.getRFPerSec() * TileEntitySolarPanel.calculateLightRatio(player.worldObj, MathHelper.floor_double((double)player.posX), MathHelper.floor_double((double)(player.posY + 1.0)), MathHelper.floor_double((double)player.posZ)));
        int leftover = RFperSecond % 20;
        boolean addExtraRF = player.worldObj.getTotalWorldTime() % 20L < (long)leftover;
        int toAdd = RFperSecond / 20 + (addExtraRF ? 1 : 0);
        if (toAdd != 0) {
            int nextIndex = player.getEntityData().getInteger("dsarmor:solar") % 4;
            for (int i = 0; i < 4 && toAdd > 0; ++i) {
                ItemStack stack = player.inventory.armorInventory[nextIndex];
                if (stack != null && (EnergyUpgrade.loadFromItem(stack) != null || Config.darkSteelSolarChargeOthers && stack.getItem() instanceof IEnergyContainerItem)) {
                    toAdd -= ((IEnergyContainerItem)stack.getItem()).receiveEnergy(stack, toAdd, false);
                }
                nextIndex = (nextIndex + 1) % 4;
            }
            player.getEntityData().setInteger("dsarmor:solar", nextIndex);
        }
    }

    private void updateSwim(EntityPlayer player) {
        ItemStack boots = player.getEquipmentInSlot(1);
        SwimUpgrade upgrade = SwimUpgrade.loadFromItem(boots);
        if (upgrade == null) {
            return;
        }
        if (player.isInWater() && !player.capabilities.isFlying) {
            player.motionX *= 1.1;
            player.motionZ *= 1.1;
        }
    }

    private void updateGlide(EntityPlayer player) {
        if (!this.isGlideActive(player) || !this.isGliderUpgradeEquipped(player)) {
            return;
        }
        if (!player.onGround && player.motionY < 0.0 && !player.isSneaking() && !player.isInWater()) {
            double horizontalSpeed = Config.darkSteelGliderHorizontalSpeed;
            double verticalSpeed = Config.darkSteelGliderVerticalSpeed;
            if (player.isSprinting()) {
                verticalSpeed = Config.darkSteelGliderVerticalSpeedSprinting;
            }
            Vector3d look = Util.getLookVecEio((EntityPlayer)player);
            Vector3d side = new Vector3d();
            side.cross(new Vector3d(0.0, 1.0, 0.0), look);
            Vector3d playerPos = new Vector3d(player.prevPosX, player.prevPosY, player.prevPosZ);
            Vector3d b = new Vector3d(playerPos);
            b.y += 1.0;
            Vector3d c = new Vector3d(playerPos);
            c.add(side);
            Vector4d plane = new Vector4d();
            VecmathUtil.computePlaneEquation((Vector3d)playerPos, (Vector3d)b, (Vector3d)c, (Vector4d)plane);
            double dist = Math.abs(VecmathUtil.distanceFromPointToPlane((Vector4d)plane, (Vector3d)new Vector3d(player.posX, player.posY, player.posZ)));
            double minDist = 0.15;
            if (dist < minDist) {
                double dropRate = minDist * 10.0 - dist * 10.0;
                verticalSpeed += verticalSpeed * dropRate * 8.0;
                horizontalSpeed -= 0.02 * dropRate;
            }
            double x = Math.cos(Math.toRadians(player.rotationYawHead + 90.0f)) * horizontalSpeed;
            double z = Math.sin(Math.toRadians(player.rotationYawHead + 90.0f)) * horizontalSpeed;
            player.motionX += x;
            player.motionZ += z;
            player.motionY = verticalSpeed;
            player.fallDistance = 0.0f;
        }
    }

    public boolean isGliderUpgradeEquipped(EntityPlayer player) {
        ItemStack chestPlate = player.getEquipmentInSlot(3);
        GliderUpgrade glideUpgrade = GliderUpgrade.loadFromItem(chestPlate);
        return glideUpgrade != null;
    }

    private void updateSword(EntityPlayer player) {
        if (ItemDarkSteelSword.isEquipped(player)) {
            IAttributeInstance attackInst = player.getAttributeMap().getAttributeInstance(SharedMonsterAttributes.attackDamage);
            attackInst.removeModifier(this.swordDamageModifierPowered);
            ItemStack sword = player.getCurrentEquippedItem();
            if (Config.darkSteelSwordPowerUsePerHit <= 0 || EnergyUpgrade.getEnergyStored(sword) >= Config.darkSteelSwordPowerUsePerHit) {
                attackInst.applyModifier(this.swordDamageModifierPowered);
            }
        }
    }

    private void updateSpeed(EntityPlayer player) {
        if (player.worldObj.isRemote || !player.onGround) {
            return;
        }
        IAttributeInstance moveInst = player.getAttributeMap().getAttributeInstance(SharedMonsterAttributes.movementSpeed);
        if (moveInst.getModifier(this.walkModifiers[0].getID()) != null) {
            moveInst.removeModifier(this.walkModifiers[0]);
        } else if (moveInst.getModifier(this.sprintModifiers[0].getID()) != null) {
            moveInst.removeModifier(this.sprintModifiers[0]);
        }
        ItemStack leggings = player.getEquipmentInSlot(2);
        SpeedUpgrade speedUpgrade = SpeedUpgrade.loadFromItem(leggings);
        if (leggings != null && leggings.getItem() == DarkSteelItems.itemDarkSteelLeggings && speedUpgrade != null && this.isSpeedActive(player)) {
            double horzMovement = Math.abs(player.distanceWalkedModified - player.prevDistanceWalkedModified);
            double costModifier = player.isSprinting() ? (double)Config.darkSteelSprintPowerCost : (double)Config.darkSteelWalkPowerCost;
            costModifier += costModifier * (double)speedUpgrade.getWalkMultiplier();
            int cost = (int)(horzMovement * costModifier);
            int totalEnergy = this.getPlayerEnergy(player, DarkSteelItems.itemDarkSteelLeggings);
            if (totalEnergy > 0) {
                this.usePlayerEnergy(player, DarkSteelItems.itemDarkSteelLeggings, cost);
                if (player.isSprinting()) {
                    moveInst.applyModifier(this.sprintModifiers[speedUpgrade.getLevel() - 1]);
                } else {
                    moveInst.applyModifier(this.walkModifiers[speedUpgrade.getLevel() - 1]);
                }
            }
        }
    }

    private void updateStepHeightAndFallDistance(EntityPlayer player) {
        JumpUpgrade jumpUpgrade;
        int costedDistance;
        ItemStack boots = player.getEquipmentInSlot(1);
        if (boots != null && boots.getItem() == DarkSteelItems.itemDarkSteelBoots && !player.capabilities.allowFlying && (costedDistance = (int)player.fallDistance) > 0) {
            int energyCost = costedDistance * Config.darkSteelFallDistanceCost;
            int totalEnergy = this.getPlayerEnergy(player, DarkSteelItems.itemDarkSteelBoots);
            if (totalEnergy > 0 && totalEnergy >= energyCost) {
                this.usePlayerEnergy(player, DarkSteelItems.itemDarkSteelBoots, energyCost);
                player.fallDistance -= (float)costedDistance;
            }
        }
        if ((jumpUpgrade = JumpUpgrade.loadFromItem(boots)) != null && boots != null && boots.getItem() == DarkSteelItems.itemDarkSteelBoots && this.isStepAssistActive(player)) {
            player.stepHeight = 1.0023f;
        } else if (player.stepHeight == 1.0023f) {
            player.stepHeight = 0.5001f;
        }
    }

    void usePlayerEnergy(EntityPlayer player, ItemDarkSteelArmor armor, int cost) {
        ItemStack stack;
        if (cost == 0) {
            return;
        }
        int remaining = cost;
        if (Config.darkSteelDrainPowerFromInventory) {
            for (ItemStack stack2 : player.inventory.mainInventory) {
                IEnergyContainerItem cont;
                int used;
                if (stack2 == null || !(stack2.getItem() instanceof IEnergyContainerItem) || (remaining -= (used = (cont = (IEnergyContainerItem)stack2.getItem()).extractEnergy(stack2, remaining, false))) > 0) continue;
                return;
            }
        }
        if (armor != null && remaining > 0 && (stack = player.inventory.armorInventory[3 - armor.armorType]) != null) {
            armor.extractEnergy(stack, remaining, false);
        }
    }

    private int getPlayerEnergy(EntityPlayer player, ItemDarkSteelArmor armor) {
        int res = 0;
        if (Config.darkSteelDrainPowerFromInventory) {
            for (ItemStack stack : player.inventory.mainInventory) {
                if (stack == null || !(stack.getItem() instanceof IEnergyContainerItem)) continue;
                IEnergyContainerItem cont = (IEnergyContainerItem)stack.getItem();
                res += cont.extractEnergy(stack, Integer.MAX_VALUE, true);
            }
        }
        if (armor != null) {
            ItemStack stack = player.inventory.armorInventory[3 - armor.armorType];
            res = armor.getEnergyStored(stack);
        }
        return res;
    }

    @SubscribeEvent
    public void onStartTracking(PlayerEvent.StartTracking event) {
        if (event.target instanceof EntityPlayerMP) {
            for (PacketUpgradeState.Type type : PacketUpgradeState.Type.values()) {
                PacketHandler.sendTo(new PacketUpgradeState(type, this.isActive((EntityPlayer)event.target, type), event.target.getEntityId()), (EntityPlayerMP)event.entityPlayer);
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public void onClientTick(TickEvent.ClientTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            EntityClientPlayerMP player = Minecraft.getMinecraft().thePlayer;
            if (player == null) {
                return;
            }
            this.updateNightvision((EntityPlayer)player);
            if (player.capabilities.isFlying) {
                return;
            }
            MovementInput input = player.movementInput;
            if (input.jump && !this.wasJumping) {
                this.doJump(player);
            } else if (input.jump && this.jumpCount < 3 && this.ticksSinceLastJump > 5) {
                this.doJump(player);
            }
            boolean bl = this.wasJumping = !player.onGround;
            if (!this.wasJumping) {
                this.jumpCount = 0;
            }
            ++this.ticksSinceLastJump;
        }
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public void onPlayerRender(RenderPlayerEvent.Specials.Post event) {
        if (event.entityLiving.getActivePotionEffect(Potion.invisibility) != null) {
            return;
        }
        EntityPlayer player = event.entityPlayer;
        ItemStack[] armors = player.inventory.armorInventory;
        this.dispatchRenders(armors, (RenderPlayerEvent)event, false);
        float yaw = player.prevRotationYawHead + (player.rotationYawHead - player.prevRotationYawHead) * event.partialRenderTick;
        float yawOffset = player.prevRenderYawOffset + (player.renderYawOffset - player.prevRenderYawOffset) * event.partialRenderTick;
        float pitch = player.prevRotationPitch + (player.rotationPitch - player.prevRotationPitch) * event.partialRenderTick;
        GL11.glPushMatrix();
        if (player.isSneaking()) {
            GL11.glTranslatef((float)0.0f, (float)0.0625f, (float)0.0f);
        }
        GL11.glRotatef((float)yawOffset, (float)0.0f, (float)-1.0f, (float)0.0f);
        GL11.glRotatef((float)(yaw - 270.0f), (float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glRotatef((float)pitch, (float)0.0f, (float)0.0f, (float)1.0f);
        this.dispatchRenders(armors, (RenderPlayerEvent)event, true);
        GL11.glPopMatrix();
    }

    private void dispatchRenders(ItemStack[] armors, RenderPlayerEvent event, boolean head) {
        for (int i = 0; i < armors.length; ++i) {
            Item item;
            ItemStack stack = armors[i];
            if (stack == null || !((item = stack.getItem()) instanceof IDarkSteelItem)) continue;
            for (IDarkSteelUpgrade upg : DarkSteelRecipeManager.instance.getUpgrades()) {
                if (!upg.hasUpgrade(stack)) continue;
                GL11.glPushMatrix();
                GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                IRenderUpgrade render = upg.getRender();
                if (render != null) {
                    upg.getRender().render(event, stack, head);
                }
                GL11.glPopMatrix();
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    private void doJump(EntityClientPlayerMP player) {
        if (!this.isJumpActive((EntityPlayer)player)) {
            return;
        }
        ItemStack boots = player.getEquipmentInSlot(1);
        JumpUpgrade jumpUpgrade = JumpUpgrade.loadFromItem(boots);
        if (jumpUpgrade == null || boots == null || boots.getItem() != DarkSteelItems.itemDarkSteelBoots) {
            return;
        }
        int requiredPower = Config.darkSteelBootsJumpPowerCost * (int)Math.pow(this.jumpCount + 1, 2.5);
        int availablePower = this.getPlayerEnergy((EntityPlayer)player, DarkSteelItems.itemDarkSteelBoots);
        if (availablePower > 0 && requiredPower <= availablePower && this.jumpCount < jumpUpgrade.getLevel()) {
            ++this.jumpCount;
            player.motionY += 0.15 * Config.darkSteelBootsJumpModifier * (double)this.jumpCount;
            this.ticksSinceLastJump = 0;
            this.usePlayerEnergy((EntityPlayer)player, DarkSteelItems.itemDarkSteelBoots, requiredPower);
            player.worldObj.playSound(player.posX, player.posY, player.posZ, "EnderIO:ds.jump", 1.0f, player.worldObj.rand.nextFloat() * 0.5f + 0.75f, false);
            Random rand = player.worldObj.rand;
            for (int i = rand.nextInt(10) + 5; i >= 0; --i) {
                EntityReddustFX fx = new EntityReddustFX(player.worldObj, player.posX + (rand.nextDouble() * 0.5 - 0.25), player.posY - (double)player.yOffset, player.posZ + (rand.nextDouble() * 0.5 - 0.25), 1.0f, 1.0f, 1.0f);
                fx.setVelocity(player.motionX + (rand.nextDouble() * 0.5 - 0.25), player.motionY / 2.0 + rand.nextDouble() * -0.05, player.motionZ + (rand.nextDouble() * 0.5 - 0.25));
                Minecraft.getMinecraft().effectRenderer.addEffect((EntityFX)fx);
            }
            PacketHandler.INSTANCE.sendToServer((IMessage)new PacketDarkSteelPowerPacket(requiredPower, DarkSteelItems.itemDarkSteelBoots.armorType));
        }
    }

    private void updateNightvision(EntityPlayer player) {
        if (this.isNightVisionUpgradeEquipped(player) && this.nightVisionActive) {
            player.addPotionEffect(new PotionEffect(Potion.nightVision.getId(), 210, 0, true));
        }
        if (!this.isNightVisionUpgradeEquipped(player) && this.nightVisionActive) {
            this.nightVisionActive = false;
            this.removeNightvision = true;
        }
        if (this.removeNightvision) {
            player.removePotionEffect(Potion.nightVision.getId());
            this.removeNightvision = false;
        }
    }

    public boolean isNightVisionUpgradeEquipped(EntityPlayer player) {
        ItemStack helmet = player.getEquipmentInSlot(4);
        return NightVisionUpgrade.loadFromItem(helmet) != null;
    }

    public void setNightVisionActive(boolean isNightVisionActive) {
        if (this.nightVisionActive && !isNightVisionActive) {
            this.removeNightvision = true;
        }
        this.nightVisionActive = isNightVisionActive;
    }

    public boolean isNightVisionActive() {
        return this.nightVisionActive;
    }
}

